/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.idmapper;

import com.seeyon.ctp.common.idmapper.GuidMapper;
import com.seeyon.ctp.common.idmapper.MapperException;
import com.seeyon.ctp.common.idmapper.dao.GuidMapperDao;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.idmapper.CTPGuidMapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.util.StringUtils;

public class DBGuidMapper
implements GuidMapper {
    private static final Log log = CtpLogFactory.getLog(DBGuidMapper.class);
    private GuidMapperDao guidMapperDao;

    public void setGuidMapperDao(GuidMapperDao val) {
        this.guidMapperDao = val;
    }

    public GuidMapperDao getGuidMapperDao() {
        return this.guidMapperDao;
    }

    @Override
    public String getGuid(long id, String type) {
        CTPGuidMapper pj = this.guidMapperDao.getByLocalId(id, type);
        if (pj == null) {
            return null;
        }
        return pj.getGuid();
    }

    @Override
    public long getLocalId(String guid, String type) {
        CTPGuidMapper pj = this.guidMapperDao.getByGuid(guid, type);
        if (pj == null) {
            return -1L;
        }
        return pj.getLocalId();
    }

    @Override
    public void map(long id, String guid, String type) throws MapperException {
        log.debug((Object)"do map");
        if (!StringUtils.hasText((String)guid)) {
            throw new MapperException("try map a null guid ");
        }
        if (!StringUtils.hasText((String)type)) {
            throw new MapperException("no type error");
        }
        CTPGuidMapper pj = this.guidMapperDao.getByLocalGuid(id, guid, type);
        if (pj == null) {
            pj = new CTPGuidMapper();
            pj.setNewId();
            pj.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            pj.setGuid(guid);
            pj.setLocalId(id);
            pj.setType(type);
            try {
                this.guidMapperDao.savePojo(pj);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    @Override
    public void remove(long id, String guid, String type) throws MapperException {
        log.debug((Object)"do remove map");
        CTPGuidMapper pj = this.guidMapperDao.getByLocalGuid(id, guid, type);
        if (pj == null) {
            return;
        }
        if (pj.getGuid().equals(guid)) {
            try {
                this.guidMapperDao.deletePojo(pj);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    @Override
    public Map<Long, String> getAll(String type) {
        HashMap<Long, String> result = new HashMap<Long, String>();
        List<CTPGuidMapper> all = this.guidMapperDao.findByType(type);
        if (all != null) {
            for (CTPGuidMapper pojo : all) {
                result.put(pojo.getLocalId(), pojo.getGuid());
            }
        }
        return result;
    }

    @Override
    public Map<String, Long> getAllGuid(String type) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        List<CTPGuidMapper> all = this.guidMapperDao.findByType(type);
        if (all != null) {
            for (CTPGuidMapper pojo : all) {
                result.put(pojo.getGuid(), pojo.getLocalId());
            }
        }
        return result;
    }

    @Override
    public List<Map<Long, String>> getAllList(String type) {
        ArrayList<Map<Long, String>> list = new ArrayList<Map<Long, String>>();
        List<CTPGuidMapper> all = this.guidMapperDao.findByType(type);
        if (all != null) {
            for (CTPGuidMapper pojo : all) {
                HashMap<Long, String> result = new HashMap<Long, String>();
                result.put(pojo.getLocalId(), pojo.getGuid());
                list.add(result);
            }
        }
        return list;
    }

    @Override
    public List<Map<String, Long>> getAllGuidList(String type) {
        ArrayList<Map<String, Long>> list = new ArrayList<Map<String, Long>>();
        List<CTPGuidMapper> all = this.guidMapperDao.findByType(type);
        if (all != null) {
            for (CTPGuidMapper pojo : all) {
                HashMap<String, Long> result = new HashMap<String, Long>();
                result.put(pojo.getGuid(), pojo.getLocalId());
                list.add(result);
            }
        }
        return list;
    }

    @Override
    public List<String> getGuids(long id, String type) {
        List<CTPGuidMapper> l = this.guidMapperDao.getByLocalIds(id, type);
        ArrayList<String> rl = new ArrayList<String>();
        if (l == null || l.isEmpty()) {
            return rl;
        }
        for (int i = 0; i < l.size(); ++i) {
            CTPGuidMapper pj = l.get(i);
            if (pj == null) continue;
            rl.add(pj.getGuid());
        }
        return rl;
    }

    @Override
    public List<Long> getLocalIds(String guid, String type) {
        List<CTPGuidMapper> l = this.guidMapperDao.getByGuids(guid, type);
        ArrayList<Long> rl = new ArrayList<Long>();
        if (l == null || l.isEmpty()) {
            return rl;
        }
        for (int i = 0; i < l.size(); ++i) {
            CTPGuidMapper pj = l.get(i);
            if (pj == null) continue;
            rl.add(pj.getLocalId());
        }
        return rl;
    }

    public String getInsertSQL(CTPGuidMapper pojo) throws MapperException {
        if (pojo == null) {
            throw new MapperException("no pojo to insert");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("insert v3x_common_guidmapper( id,localId,guid,type ) values(");
        sb.append(pojo.getId());
        sb.append(",");
        sb.append(pojo.getLocalId());
        sb.append(",");
        sb.append(pojo.getGuid());
        sb.append(",");
        sb.append(pojo.getType());
        sb.append(")");
        return sb.toString();
    }

    public String getInsertSQL(long id, long localId, String guid, String type) throws MapperException {
        CTPGuidMapper pojo = new CTPGuidMapper();
        pojo.setId(id);
        pojo.setLocalId(localId);
        pojo.setGuid(guid);
        pojo.setType(type);
        return this.getInsertSQL(pojo);
    }

    public String getUpdateSQL(CTPGuidMapper pojo) throws MapperException {
        if (pojo == null) {
            throw new MapperException("no pojo to insert");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("update v3x_common_guidmapper set localId=");
        sb.append(pojo.getLocalId());
        sb.append(", guid='");
        sb.append(pojo.getGuid());
        sb.append("',type='");
        sb.append(pojo.getType());
        sb.append("'  where id=");
        sb.append(pojo.getId());
        return sb.toString();
    }

    public String getUpdateSQL(long id, long localId, String guid, String type) throws MapperException {
        CTPGuidMapper pojo = new CTPGuidMapper();
        pojo.setId(id);
        pojo.setLocalId(localId);
        pojo.setGuid(guid);
        pojo.setType(type);
        return this.getUpdateSQL(pojo);
    }

    public String getDeleteSQL(long id) throws MapperException {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from v3x_common_guidmapper ");
        sb.append("  where id=");
        sb.append(id);
        return sb.toString();
    }

    @Override
    public void update(long id, String guid, String type) throws MapperException {
        log.info((Object)"update map");
        CTPGuidMapper pojo = this.guidMapperDao.getByLocalGuid(id, guid, type);
        if (pojo == null) {
            return;
        }
        if (pojo.getGuid().equals(guid)) {
            try {
                pojo.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                this.guidMapperDao.updatePojo(pojo);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    @Override
    public void updateGuid(long id, String guid, String type) throws MapperException {
        CTPGuidMapper pojo = this.guidMapperDao.getByLocalId(id, type);
        if (pojo == null) {
            return;
        }
        if (!pojo.getGuid().equals(guid)) {
            try {
                pojo.setGuid(guid);
                pojo.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                this.guidMapperDao.updatePojo(pojo);
                log.info((Object)"update guid");
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    @Override
    public void removeByGuid(String guid, String type) throws MapperException {
        log.info((Object)"do remove map");
        CTPGuidMapper pj = this.guidMapperDao.getByGuid(guid, type);
        if (pj == null) {
            return;
        }
        if (pj.getGuid().equals(guid)) {
            try {
                this.guidMapperDao.deletePojo(pj);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    @Override
    public void saveAll(List<CTPGuidMapper> list) throws MapperException {
        this.guidMapperDao.saveAllGuidMapper(list);
    }

    @Override
    public void removeByLocalIdAndGuid(long localId, String guid) throws MapperException {
        List<CTPGuidMapper> pj = this.guidMapperDao.getByLocalIdWithoutType(localId);
        if (pj != null) {
            for (CTPGuidMapper guidMapperPojo : pj) {
                this.guidMapperDao.deletePojo(guidMapperPojo);
            }
        }
        if ((pj = this.guidMapperDao.getByGuidWithoutType(guid)) != null) {
            for (CTPGuidMapper guidMapperPojo : pj) {
                this.guidMapperDao.deletePojo(guidMapperPojo);
            }
        }
    }
}

