/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.config.manager.ConfigManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.ResourceCache;
import com.seeyon.ctp.common.i18n.ResourceLoader;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.domain.ResourceInfoVO;
import com.seeyon.ctp.common.i18n.expand.CustomSaver;
import com.seeyon.ctp.common.i18n.m3.M3CustomI18nManager;
import com.seeyon.ctp.common.i18n.m3.M3I18nLoaderManager;
import com.seeyon.ctp.common.i18n.m3.M3I18nResourceCacheHolder;
import com.seeyon.ctp.common.i18n.manager.I18nResourceCacheHolder;
import com.seeyon.ctp.common.i18n.manager.I18nResourceManager;
import com.seeyon.ctp.common.i18n.pager.PageParameter;
import com.seeyon.ctp.common.i18n.pager.PageResult;
import com.seeyon.ctp.common.i18n.pager.PageUtil;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.config.ConfigItem;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UniqueList;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.HandleNotification;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.util.Assert;

@ProcessInDataSource(name=DataSourceName.BASE)
public class I18nResourceManagerImpl
implements I18nResourceManager {
    private static final Log log = CtpLogFactory.getLog(I18nResourceManagerImpl.class);
    private ConfigManager configManager;
    private AppLogManager appLogManager;

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    public ConfigManager getConfigManager() {
        if (this.configManager == null) {
            return (ConfigManager)AppContext.getBean("configManager");
        }
        return this.configManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public ResourceInfo resourceLoaded(Locale locale, String levelType, String filePath, String relativePath, String key, String value) {
        if (locale != null && StringUtils.isNotBlank((CharSequence)levelType) && StringUtils.isNotBlank((CharSequence)filePath)) {
            ResourceInfo info = new ResourceInfo();
            info.setKey(key);
            info.setValue(value);
            info.setLocale(locale);
            info.setLevelType(levelType);
            info.setFilePath(filePath);
            info.setRelativePath(relativePath);
            I18nResourceCacheHolder.saveOrUpdateResourceInfo(locale, info, false);
            return info;
        }
        log.debug((Object)"resource info is absence");
        return null;
    }

    @Override
    public void loadFinished() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"resource load finished---->>>>>> ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"cache:");
        }
        for (Locale locale : LocaleContext.getAllLocales()) {
            Map<String, ResourceInfo> resMap = ResourceLoader.getResources(locale);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(locale.toString() + ":" + resMap.size()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"resInfoMap:");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource total count is " + I18nResourceCacheHolder.getResourceSize()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------");
        }
    }

    @Override
    @AjaxAccess
    public FlipInfo findALLResource(FlipInfo flipInfo, Map params) throws IOException {
        try {
            String condition = String.valueOf(params.get("condition"));
            String value = String.valueOf(params.get("value"));
            String showType = String.valueOf(params.get("showType"));
            String resourceKey = String.valueOf(params.get("resourceKey"));
            ArrayList<ResourceInfoVO> cnlistInfos = new ArrayList<ResourceInfoVO>(flipInfo.getSize());
            boolean m3 = "M3".equals(showType);
            PageResult<Map<Locale, ResourceInfo>> result = this.getResource(condition, value, m3, resourceKey, flipInfo);
            List<Map<Locale, ResourceInfo>> listInfos = result.getDataList();
            for (int j = 0; j < listInfos.size(); ++j) {
                Map<Locale, ResourceInfo> item = listInfos.get(j);
                if (item.isEmpty()) continue;
                ResourceInfoVO vo = new ResourceInfoVO();
                List<Locale> allLocales = LocaleContext.getAllLocales();
                for (Locale l : allLocales) {
                    ResourceInfo r = item.get(l);
                    if (r == null) continue;
                    vo.addResourceInfo(r);
                }
                cnlistInfos.add(vo);
            }
            DBAgent.memoryPaging(cnlistInfos, flipInfo);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return flipInfo;
    }

    private PageResult<Map<Locale, ResourceInfo>> listResourceInfo(boolean m3, String resourceKey, PageParameter parameter) throws BusinessException {
        List<Map<Locale, ResourceInfo>> infos = this.getResourcebyType(m3, resourceKey);
        PageUtil.updatePageParameter(infos, parameter);
        PageUtil.sortDataList4Key(infos);
        return new PageResult<Map<Locale, ResourceInfo>>(infos, parameter);
    }

    private PageResult<Map<Locale, ResourceInfo>> queryResourceInfoByKey(String key, boolean m3, String resourceKey, PageParameter parameter) throws BusinessException {
        List<Map<Locale, ResourceInfo>> infos = this.getResourcebyType(m3, resourceKey);
        ArrayList<Map<Locale, ResourceInfo>> newInfos = new ArrayList<Map<Locale, ResourceInfo>>();
        if (StringUtils.isNotBlank((CharSequence)key)) {
            for (int i = 0; i < infos.size(); ++i) {
                Map<Locale, ResourceInfo> m = infos.get(i);
                HashMap<Locale, ResourceInfo> mlr = new HashMap<Locale, ResourceInfo>();
                for (Map.Entry<Locale, ResourceInfo> s : m.entrySet()) {
                    ResourceInfo info = s.getValue();
                    String infoKey = info.getKey();
                    if (!StringUtils.isNotBlank((CharSequence)infoKey) || info.getKey().toLowerCase().indexOf(key.toLowerCase()) == -1) continue;
                    Locale loc = s.getKey();
                    mlr.put(loc, info);
                }
                if (!MapUtils.isNotEmpty(mlr)) continue;
                newInfos.add(mlr);
            }
            PageUtil.updatePageParameter(newInfos, parameter);
            PageUtil.sortDataList4Key(newInfos);
            return new PageResult<Map<Locale, ResourceInfo>>(newInfos, parameter);
        }
        PageUtil.updatePageParameter(infos, parameter);
        PageUtil.sortDataList4Key(infos);
        return new PageResult<Map<Locale, ResourceInfo>>(infos, parameter);
    }

    private List<Map<Locale, ResourceInfo>> getResourcebyType(boolean m3, String resourceKey) {
        Map<String, List<Map<Locale, ResourceInfo>>> map = m3 ? M3I18nResourceCacheHolder.getM3ResourceInfo() : I18nResourceCacheHolder.getPcResourceInfo();
        List<Map<Locale, ResourceInfo>> infos = map.get(resourceKey);
        return infos;
    }

    private PageResult<Map<Locale, ResourceInfo>> queryResourceByValue(String value, String resourceKey, boolean m3, PageParameter parameter) throws BusinessException {
        List<Map<Locale, ResourceInfo>> infos = this.getResourcebyType(m3, resourceKey);
        ArrayList<Map<Locale, ResourceInfo>> newInfos = new ArrayList<Map<Locale, ResourceInfo>>();
        ArrayList keyLists = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            for (int i = 0; i < infos.size(); ++i) {
                Map<Locale, ResourceInfo> m = infos.get(i);
                HashMap mlr = new HashMap();
                for (Map.Entry<Locale, ResourceInfo> s : m.entrySet()) {
                    ResourceInfo info = s.getValue();
                    String infoValue = info.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)infoValue) || infoValue.toLowerCase().indexOf(value.toLowerCase()) == -1) continue;
                    Locale loc = s.getKey();
                    String key = info.getKey();
                    if (keyLists.contains(key)) continue;
                    keyLists.add(key);
                    List<Map<Locale, ResourceInfo>> pages = this.queryResourceInfoByKey(key, m3, resourceKey, null).getDataList();
                    if (!CollectionUtils.isNotEmpty(pages)) continue;
                    newInfos.addAll(pages);
                }
            }
            PageUtil.updatePageParameter(newInfos, parameter);
            PageUtil.sortDataList4Key(newInfos);
            return new PageResult<Map<Locale, ResourceInfo>>(newInfos, parameter);
        }
        PageUtil.updatePageParameter(infos, parameter);
        PageUtil.sortDataList4Key(infos);
        return new PageResult<Map<Locale, ResourceInfo>>(infos, parameter);
    }

    @Override
    public void saveResourceInfo(ResourceInfo info) throws BusinessException {
        Assert.notNull((Object)info, (String)"can not save resource: params is null");
        Locale locale = info.getLocale();
        Assert.notNull((Object)locale, (String)"can not save resource: locale is null");
        String uniqueKey = info.getUniqueKey();
        Assert.notNull((Object)uniqueKey, (String)"can not save resource: key is null");
        String value = info.getValue();
        Assert.notNull((Object)value, (String)"can not save resource: value is null");
        I18nResourceCacheHolder.saveOrUpdateResourceInfo(locale, info, true);
        info.setLevelType("custom");
        if (!info.isJs() && !info.isM3()) {
            HashMap<String, ResourceInfo> resourceMap = new HashMap<String, ResourceInfo>();
            resourceMap.put(uniqueKey, info);
            ResourceLoader.updateResourcesCache(locale, resourceMap);
            CustomSaver.getInstance().save(locale, uniqueKey, value, info);
        } else if (info.isJs()) {
            String relativePath = File.separator + "i18n" + File.separator + "custom_js_" + I18nUtil.getLocalAsString(locale);
            info.setFilePath(SystemEnvironment.getApplicationFolder() + relativePath);
            info.setRelativePath(relativePath);
            this.updateCustomJs(locale);
        } else if (info.isM3()) {
            // empty if block
        }
        log.debug((Object)("i18n resource saved: " + info.getKey()));
    }

    @Override
    public void resetResourceInfo(String key) throws BusinessException {
        Assert.notNull((Object)key, (String)"can not save resource: key is null");
        List<Locale> allLocales = LocaleContext.getAllLocales();
        for (Locale locale : allLocales) {
            ResourceInfo info = I18nResourceCacheHolder.getResourceInfo(locale, key);
            if (info == null || info.isJs() || info.isM3()) continue;
            I18nResourceCacheHolder.removeResourceInfo(info.getLocale(), info);
            ResourceLoader.resetResourcesCache(info.getLocale(), info.getUniqueKey());
            CustomSaver.getInstance().delete(info.getLocale(), info.getUniqueKey());
            log.debug((Object)("i18n resource delete: " + info.getUniqueKey()));
        }
    }

    private PageResult<Map<Locale, ResourceInfo>> getResource(String condition, String value, boolean m3, String resourceKey, FlipInfo flipInfo) throws BusinessException {
        PageResult<Map<Locale, ResourceInfo>> result = null;
        result = StringUtils.equals((CharSequence)condition, (CharSequence)"keyinfo") ? this.queryResourceInfoByKey(value, m3, resourceKey, new PageParameter(flipInfo.getPage(), flipInfo.getSize())) : (StringUtils.equals((CharSequence)condition, (CharSequence)"valueinfo") && StringUtils.isNotBlank((CharSequence)value) ? this.queryResourceByValue(value, resourceKey, m3, new PageParameter(flipInfo.getPage(), flipInfo.getSize())) : this.listResourceInfo(m3, resourceKey, new PageParameter(flipInfo.getPage(), flipInfo.getSize())));
        return result;
    }

    @Override
    public void importProperties(String srcFilePath, String copyFilePath) throws Exception {
        Properties prop = null;
        InputStream in = null;
        FileOutputStream oFile = null;
        try {
            in = new BufferedInputStream(new FileInputStream(srcFilePath));
            prop = new Properties();
            prop.load(in);
            oFile = new FileOutputStream(copyFilePath, true);
            prop.store(oFile, "");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)"\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            if (oFile != null) {
                try {
                    oFile.close();
                }
                catch (IOException e) {
                    log.error((Object)"\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void saveImportLanguage4PC(Map<String, Map<Locale, String>> i18nDatas, List<Locale> uploadLocales) {
        ResourceInfo resource;
        for (Map.Entry<String, Map<Locale, String>> entry : i18nDatas.entrySet()) {
            String i18nKey = entry.getKey();
            Map<Locale, String> rsMap = entry.getValue();
            for (Locale locale : rsMap.keySet()) {
                String i18nValue = rsMap.get(locale);
                resource = I18nResourceCacheHolder.getResourceInfo(locale, i18nKey);
                if (resource != null) {
                    String oldI18nValue = resource.getValue();
                    if (!StringUtils.isNotEmpty((CharSequence)i18nValue) || i18nValue.equals(oldI18nValue)) continue;
                    resource = this.newResourceInfo(i18nKey, locale, i18nValue);
                } else {
                    resource = this.newResourceInfo(i18nKey, locale, i18nValue);
                }
                I18nResourceCacheHolder.saveOrUpdateResourceInfo(locale, resource, true);
            }
        }
        List<Map<Locale, ResourceInfo>> customDatas = I18nResourceCacheHolder.queryPCResourceByLevelType("custom");
        HashMap properties = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(customDatas)) {
            for (Map<Locale, ResourceInfo> infos : customDatas) {
                for (Map.Entry entry : infos.entrySet()) {
                    Locale locale = (Locale)entry.getKey();
                    resource = (ResourceInfo)entry.getValue();
                    if (!properties.containsKey(locale)) {
                        Properties prop = new Properties();
                        prop.put(resource.getKey(), resource.getValue());
                        properties.put(locale, prop);
                        continue;
                    }
                    ((Properties)properties.get(locale)).put(resource.getKey(), resource.getValue());
                }
            }
            for (Locale locale : properties.keySet()) {
                CustomSaver.getInstance().save(locale, (Properties)properties.get(locale));
            }
        }
    }

    private ResourceInfo newResourceInfo(String i18nKey, Locale locale, String i18nValue) {
        ResourceInfo resource = new ResourceInfo();
        resource.setKey(i18nKey);
        resource.setUniqueKey(i18nKey);
        resource.setValue(i18nValue);
        resource.setLevelType("custom");
        resource.setLocale(locale);
        resource.setFilePath(CustomSaver.getInstance().getCustomPath(locale));
        resource.setRelativePath(CustomSaver.getInstance().getRelativePath(locale));
        return resource;
    }

    private void updateCustomJs(Locale locale) {
        List<ResourceInfo> infos = I18nResourceCacheHolder.queryJsResourceByLevelType("custom", locale);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (ResourceInfo rInfo : infos) {
            dataMap.put(rInfo.getUniqueKey(), rInfo.getValue());
        }
        this.updateCustomJsFile(locale, dataMap, "custom_js_");
    }

    private void updateCustomJsFile(Locale locale, Map<String, String> dataMap, String customType) {
        String relativePath = File.separator + "i18n" + File.separator + customType + I18nUtil.getLocalAsString(locale);
        File customFile = null;
        try {
            customFile = new File(SystemEnvironment.getPartitionPublicFolder(), relativePath);
        }
        catch (BusinessException e) {
            log.error((Object)("\u83b7\u53d6\u516c\u5171\u8d44\u6e90\u76ee\u5f55\u5931\u8d25" + e.getMessage()));
        }
        I18nUtil.writeCustomJs(dataMap, customFile);
    }

    @Override
    @AjaxAccess
    public boolean addLanguageInfo(String ressourceKey, String resourceName, String showName, boolean isDefault) {
        boolean flag = false;
        ArrayList array = null;
        ArrayList<Map> localeList = new ArrayList<Map>();
        try {
            ConfigItem configItem = this.getConfigManager().getConfigItem("system_locale", "system_locale");
            if (configItem != null) {
                String localesInfo = configItem.getConfigValue();
                String shortName = "";
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{localesInfo})) {
                    array = (ArrayList)JSONUtil.parseJSONString(localesInfo);
                    for (int i = 0; i < array.size(); ++i) {
                        Map jsonObj = (Map)array.get(i);
                        if (isDefault) {
                            jsonObj.put("whetherDefault", false);
                        }
                        if (!"false".equals(MapUtils.getString((Map)jsonObj, (Object)"stopped"))) continue;
                        localeList.add(jsonObj);
                    }
                }
                HashMap<String, Object> newResource = new HashMap<String, Object>();
                newResource.put("key", ressourceKey);
                newResource.put("whetherDefault", isDefault);
                newResource.put("stopped", false);
                newResource.put("candel", true);
                newResource.put("showName", showName);
                newResource.put("resourceName", resourceName);
                if (array == null) {
                    array = new ArrayList();
                }
                array.add(newResource);
                configItem.setConfigValue(JSONUtil.toJSONString(array));
                this.getConfigManager().updateConfigItem(configItem);
                localeList.add(newResource);
                this.initLocales(localeList);
                flag = true;
                User user = AppContext.getCurrentUser();
                this.appLogManager.insertLog(user, AppLogAction.i18n_lang_new, user.getName(), showName);
                if (isDefault) {
                    this.appLogManager.insertLog(user, AppLogAction.i18n_lang_default, user.getName(), showName);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("\u4fdd\u5b58\u8bed\u79cd\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01" + e.getMessage()));
        }
        return flag;
    }

    @Override
    @AjaxAccess
    public boolean deleteLanguage(String resourceKey, boolean isDefault) {
        boolean flag = false;
        List array = null;
        ArrayList<Map> localeList = new ArrayList<Map>();
        try {
            ConfigItem configItem = this.getConfigManager().getConfigItem("system_locale", "system_locale");
            if (configItem != null) {
                String localesInfo = configItem.getConfigValue();
                String shortName = "";
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{localesInfo})) {
                    array = (List)JSONUtil.parseJSONString(localesInfo);
                    for (int i = 0; i < array.size(); ++i) {
                        Map jsonObj = (Map)array.get(i);
                        if (isDefault && "zh_CN".equals(jsonObj.get("key"))) {
                            jsonObj.put("whetherDefault", true);
                        }
                        if ("false".equals(MapUtils.getString((Map)jsonObj, (Object)"stopped"))) {
                            localeList.add(jsonObj);
                        }
                        if (!resourceKey.equals(jsonObj.get("key"))) continue;
                        shortName = MapUtils.getString((Map)jsonObj, (Object)"showName");
                        array.remove(jsonObj);
                        localeList.remove(jsonObj);
                        Map<String, String> resoureLocaleMap = I18nResourceCacheHolder.getResouceLocaleType();
                        if (resoureLocaleMap.containsKey(resourceKey)) continue;
                        resoureLocaleMap.put(resourceKey, jsonObj.get("resourceName").toString());
                        I18nResourceCacheHolder.setResouceLocaleType(resoureLocaleMap);
                    }
                }
                if (array != null) {
                    configItem.setConfigValue(JSONUtil.toJSONString(array));
                    this.getConfigManager().updateConfigItem(configItem);
                    this.initLocales(localeList);
                }
                User user = AppContext.getCurrentUser();
                this.appLogManager.insertLog(user, AppLogAction.i18n_lang_delete, user.getName(), shortName);
            }
            flag = true;
        }
        catch (Exception e) {
            log.error((Object)("\u5220\u9664\u56fd\u9645\u5316\u4fe1\u606f\u5931\u8d25\uff01" + e.getMessage()));
        }
        return flag;
    }

    private void initLocales(List array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            Map jsonObj = (Map)array.get(i);
            if (i == 0) {
                sb.append(jsonObj.get("key"));
                continue;
            }
            sb.append("," + jsonObj.get("key"));
        }
        UniqueList<Locale> locales = new UniqueList<Locale>();
        String string = sb.toString();
        if (Strings.isNotBlank(string)) {
            String[] localeStrs;
            for (String l : localeStrs = string.split(",")) {
                Locale locale;
                if (!Strings.isNotBlank(l) || locales.contains(locale = I18nUtil.parseLocale(l))) continue;
                locales.add(locale);
            }
        }
        LocaleContext.intAllLocales(locales);
    }

    @Override
    @AjaxAccess
    public boolean setDefaultLanguage(String resourceKey) {
        boolean flag = false;
        List array = null;
        ArrayList<Map> localeList = new ArrayList<Map>();
        try {
            ConfigItem configItem = this.getConfigManager().getConfigItem("system_locale", "system_locale");
            if (configItem != null) {
                String localesInfo = configItem.getConfigValue();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{localesInfo})) {
                    array = (List)JSONUtil.parseJSONString(localesInfo);
                    String shortName = "";
                    for (int i = 0; i < array.size(); ++i) {
                        Map jsonObj = (Map)array.get(i);
                        if (resourceKey.equals(jsonObj.get("key"))) {
                            jsonObj.put("whetherDefault", true);
                            jsonObj.put("stopped", false);
                            shortName = MapUtils.getString((Map)jsonObj, (Object)"showName");
                        } else {
                            jsonObj.put("whetherDefault", false);
                        }
                        if ("true".equals(MapUtils.getString((Map)jsonObj, (Object)"stopped"))) continue;
                        localeList.add(jsonObj);
                    }
                    configItem.setConfigValue(JSONUtil.toJSONString(array));
                    configItem.setConfigType("1");
                    configItem.setConfigType("system_config");
                    this.getConfigManager().updateConfigItem(configItem);
                    LocaleContext.setSysDefaultLocale(resourceKey);
                    this.initLocales(localeList);
                    User user = AppContext.getCurrentUser();
                    this.appLogManager.insertLog(user, AppLogAction.i18n_lang_default, user.getName(), shortName);
                }
            }
            flag = true;
        }
        catch (Exception e) {
            log.error((Object)("\u8bbe\u7f6e\u9ed8\u8ba4\u8bed\u8a00\u4fe1\u606f\uff01" + e.getMessage()));
        }
        return flag;
    }

    @Override
    @AjaxAccess
    public boolean setStoppedLanguage(String resourceKey) {
        boolean flag = false;
        List array = null;
        ArrayList<Map> localeList = new ArrayList<Map>();
        try {
            ConfigItem configItem = this.getConfigManager().getConfigItem("system_locale", "system_locale");
            if (configItem != null) {
                String localesInfo = configItem.getConfigValue();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{localesInfo})) {
                    array = (List)JSONUtil.parseJSONString(localesInfo);
                    String shortName = "";
                    for (int i = 0; i < array.size(); ++i) {
                        Map jsonObj = (Map)array.get(i);
                        if (resourceKey.equals(jsonObj.get("key"))) {
                            jsonObj.put("stopped", true);
                            shortName = MapUtils.getString((Map)jsonObj, (Object)"showName");
                        }
                        if ("true".equals(MapUtils.getString((Map)jsonObj, (Object)"stopped"))) continue;
                        localeList.add(jsonObj);
                    }
                    configItem.setConfigValue(JSONUtil.toJSONString(array));
                    configItem.setConfigType("system_config");
                    this.getConfigManager().updateConfigItem(configItem);
                    this.initLocales(localeList);
                    User user = AppContext.getCurrentUser();
                    this.appLogManager.insertLog(user, AppLogAction.i18n_lang_stop, user.getName(), shortName);
                }
            }
            flag = true;
        }
        catch (Exception e) {
            log.error((Object)("\u8bbe\u7f6e\u9ed8\u8ba4\u8bed\u8a00\u4fe1\u606f\uff01" + e.getMessage()));
        }
        return flag;
    }

    @Override
    @AjaxAccess
    public FlipInfo getAllPCResource(FlipInfo fi, Map params) {
        LinkedList list = new LinkedList();
        Map<String, Integer> resultMap = I18nResourceCacheHolder.getAllPCResource();
        for (Map.Entry<String, Integer> entry : resultMap.entrySet()) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("type", "PC");
            m.put("resourceName", entry.getKey());
            m.put("resourceNum", entry.getValue());
            if (ResourceUtil.getString("plugin.module2Name.all").equals(entry.getKey())) {
                list.addFirst(m);
                continue;
            }
            list.add(m);
        }
        fi.setData(list);
        return fi;
    }

    @Override
    @AjaxAccess
    public FlipInfo getAllM3Resource(FlipInfo fi, Map params) {
        M3I18nLoaderManager.getInstance().loadM3Resource(false);
        LinkedList list = new LinkedList();
        Map<String, Integer> resultMap = M3I18nResourceCacheHolder.getAllM3Resource();
        HashMap all = new HashMap();
        HashMap undefine = new HashMap();
        for (Map.Entry<String, Integer> entry : resultMap.entrySet()) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("type", "M3");
            m.put("resourceName", entry.getKey());
            m.put("resourceNum", entry.getValue());
            if (ResourceUtil.getString("plugin.module2Name.all").equals(entry.getKey())) {
                all = m;
                continue;
            }
            if (ResourceUtil.getString("plugin.module2Name.undefine").equals(entry.getKey())) {
                undefine = m;
                continue;
            }
            list.add(m);
        }
        list.addFirst(undefine);
        list.addFirst(all);
        fi.setData(list);
        return fi;
    }

    @Override
    public void saveImportLanguage4M3(Map<String, Map<Locale, String>> importDatas, List<Locale> importLocales) throws BusinessException {
        M3CustomI18nManager.getInstance().saveImportLanguage4M3(importDatas, importLocales);
    }

    @Override
    @AjaxAccess
    public Map<String, String> updateM3ZipFile() {
        HashMap<String, String> ret = new HashMap<String, String>();
        M3I18nLoaderManager.getInstance().updataM3ZipFile();
        ret.put("success", "true");
        return ret;
    }

    @Override
    public void updateM3CustomItem(ResourceInfo resourceInfo) throws BusinessException {
        M3CustomI18nManager.getInstance().updateM3CustomItem(resourceInfo.getLocale(), resourceInfo.getKey(), resourceInfo.getValue(), resourceInfo);
    }

    @Override
    @AjaxAccess
    public boolean setEnableLanguage(String resourceKey) {
        boolean flag = false;
        List array = null;
        ArrayList<Map> localeList = new ArrayList<Map>();
        try {
            ConfigItem configItem = this.getConfigManager().getConfigItem("system_locale", "system_locale");
            if (configItem != null) {
                String localesInfo = configItem.getConfigValue();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{localesInfo})) {
                    array = (List)JSONUtil.parseJSONString(localesInfo);
                    String shortName = "";
                    for (int i = 0; i < array.size(); ++i) {
                        Map jsonObj = (Map)array.get(i);
                        if (resourceKey.equals(jsonObj.get("key"))) {
                            jsonObj.put("stopped", false);
                            shortName = MapUtils.getString((Map)jsonObj, (Object)"showName");
                        }
                        if (!"false".equals(MapUtils.getString((Map)jsonObj, (Object)"stopped"))) continue;
                        localeList.add(jsonObj);
                    }
                    configItem.setConfigValue(JSONUtil.toJSONString(array));
                    configItem.setConfigType("system_config");
                    this.getConfigManager().updateConfigItem(configItem);
                    this.initLocales(localeList);
                    User user = AppContext.getCurrentUser();
                    this.appLogManager.insertLog(user, AppLogAction.i18n_lang_open, user.getName(), shortName);
                }
            }
            flag = true;
        }
        catch (Exception e) {
            log.error((Object)("\u8bbe\u7f6e\u9ed8\u8ba4\u8bed\u8a00\u4fe1\u606f\uff01" + e.getMessage()));
        }
        return flag;
    }

    @HandleNotification(type=NotificationType.I18nResourceUpdate)
    public void updateI18nResourceInfo(Object o) {
        ResourceInfo resourceInfo = (ResourceInfo)o;
        ResourceCache.getInstance().put(resourceInfo.getLocale(), resourceInfo.getUniqueKey(), resourceInfo);
    }
}

