/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.m3;

import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.m3.M3I18nLoaderManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class M3I18nResourceCacheHolder {
    private static CacheMap<String, Long> cacheMap = CacheFactory.getInstance(M3I18nResourceCacheHolder.class).createMap("M3I18nResourceCacheHolder");
    private static Map<String, Map<Locale, ResourceInfo>> allM3resInfoMap = new ConcurrentHashMap<String, Map<Locale, ResourceInfo>>(30000);
    private static Map<String, Map<Locale, ResourceInfo>> currUserZipResInfoMap = new ConcurrentHashMap<String, Map<Locale, ResourceInfo>>(30000);
    private static Map<String, List<Map<Locale, ResourceInfo>>> m3ModuleResourceInfo = new HashMap<String, List<Map<Locale, ResourceInfo>>>();
    private static Map<String, String> m3Module2Name = new HashMap<String, String>();

    public static void updateModifTime() {
        cacheMap.put("m3I18nModifTime", DateUtil.currentTimestamp().getTime());
    }

    public static long getModifTime() {
        if (cacheMap.contains("m3I18nModifTime")) {
            return cacheMap.get("m3I18nModifTime");
        }
        return 0L;
    }

    public static boolean containsKey(String i18nKey) {
        Set<String> keys = allM3resInfoMap.keySet();
        return keys.contains(i18nKey);
    }

    public static void saveOrUpdateM3ZipResourceInfo(Locale locale, ResourceInfo info, boolean isSave) {
    }

    public static void saveOrUpdateResourceInfo4M3(Locale locale, ResourceInfo info, boolean isSave) {
        Map<Locale, ResourceInfo> item = allM3resInfoMap.get(info.getUniqueKey());
        if (item == null) {
            item = new ConcurrentHashMap<Locale, ResourceInfo>(3);
        }
        item.put(locale, info);
        allM3resInfoMap.put(info.getUniqueKey(), item);
    }

    public static void saveOrUpdateM3ResourceInfo(Locale locale, ResourceInfo info, boolean isSave) {
        ResourceInfo oldInfo;
        Map<Locale, ResourceInfo> item = allM3resInfoMap.get(info.getUniqueKey());
        if (item == null) {
            item = new ConcurrentHashMap<Locale, ResourceInfo>(3);
        }
        if ((oldInfo = item.get(locale)) != null) {
            info.setModule(oldInfo.getModule());
            info.setModuleName(oldInfo.getModuleName());
            info.setJs(false);
            info.setSrcRelativePath(oldInfo.getSrcRelativePath());
            info.setM3(oldInfo.isM3());
            info.setKey(oldInfo.getKey());
            info.setZipFile(oldInfo.getZipFile());
            info.setAppId(oldInfo.getAppId());
        } else {
            info.setSrcRelativePath(info.getRelativePath());
        }
        if ("custom".equals(info.getLevelType())) {
            Collection<ResourceInfo> items = item.values();
            for (ResourceInfo i : items) {
                i.setLevelType("custom");
            }
        }
        m3Module2Name.put(info.getModule(), info.getModuleName());
        item.put(locale, info);
        allM3resInfoMap.put(info.getUniqueKey(), item);
    }

    public static void removeResourceInfo(Locale locale, ResourceInfo info) {
        Map<Locale, ResourceInfo> item = allM3resInfoMap.get(info.getUniqueKey());
        if (item != null) {
            item.remove(locale);
        }
    }

    public static int getResourceSize() {
        return allM3resInfoMap.size();
    }

    private static String getModuleName(String module) {
        String name = ResourceUtil.getString("plugin.module2Name." + module);
        if (null != name && name.equals("plugin.module2Name." + module)) {
            name = ResourceUtil.getString("plugin.module2Name.custom");
        }
        return name;
    }

    public static Map<String, String> getM3AllModule() {
        return Collections.synchronizedMap(m3Module2Name);
    }

    public static ResourceInfo getResourceInfo(Locale locale, String uniqueKye) {
        Assert.notNull((Object)locale, (String)"locale param is null");
        Assert.notNull((Object)uniqueKye, (String)"key param is null");
        ResourceInfo ret = null;
        Map<Locale, ResourceInfo> localeValues = allM3resInfoMap.get(uniqueKye);
        if (localeValues != null) {
            ret = localeValues.get(locale);
        }
        return ret;
    }

    public static List<ResourceInfo> getResource(Locale locale, boolean m3) {
        ArrayList<ResourceInfo> ret = null;
        ret = new ArrayList<ResourceInfo>(10000);
        Set<String> keys = allM3resInfoMap.keySet();
        for (String key : keys) {
            Map<Locale, ResourceInfo> item = allM3resInfoMap.get(key);
            if (item == null || item.get(locale) == null) continue;
            ResourceInfo i = item.get(locale);
            if (m3 && i.isM3()) {
                ret.add(i);
                continue;
            }
            if (m3 || i.isM3()) continue;
            ret.add(i);
        }
        return ret;
    }

    public static List<ResourceInfo> queryM3ResourceByLevelType(String levelType, Locale locale) {
        ArrayList<ResourceInfo> ret = new ArrayList<ResourceInfo>(1000);
        Set<String> keys = allM3resInfoMap.keySet();
        for (String key : keys) {
            ResourceInfo s;
            Map<Locale, ResourceInfo> item = allM3resInfoMap.get(key);
            if (item == null || (s = item.get(locale)) == null || !s.isM3() || !s.getLevelType().equals(levelType)) continue;
            ret.add(s);
        }
        return ret;
    }

    public static Map<String, List<Map<Locale, ResourceInfo>>> getM3ResourceInfo() {
        return m3ModuleResourceInfo;
    }

    public static Map<String, Integer> getAllM3Resource() {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        Set<String> keys = allM3resInfoMap.keySet();
        m3ModuleResourceInfo.clear();
        ArrayList<Map<Locale, ResourceInfo>> allListMap = new ArrayList<Map<Locale, ResourceInfo>>();
        List<Locale> locales = LocaleContext.getAllLocales();
        int count = 1;
        for (String key : keys) {
            ResourceInfo r;
            boolean isM3;
            Map<Locale, ResourceInfo> item = allM3resInfoMap.get(key);
            if (item == null || !(isM3 = (r = item.values().iterator().next()).isM3())) continue;
            allListMap.add(item);
            m3ModuleResourceInfo.put(ResourceUtil.getString("plugin.module2Name.all"), allListMap);
            resultMap.put(ResourceUtil.getString("plugin.module2Name.all"), count++);
            String appID = r.getAppId();
            M3I18nLoaderManager.M3ZipFileInfo m3ZipFileInfo = M3I18nLoaderManager.getInstance().getM3ZipInfoByAppID(appID);
            String i18nKey = "m3.app." + appID + ".label";
            String appName = ResourceUtil.getString(i18nKey);
            if (m3ZipFileInfo != null) {
                if (i18nKey.equals(appName)) {
                    appName = m3ZipFileInfo.getBundleName();
                }
                appName = m3ZipFileInfo.getZipGroup() + "_" + appName;
            }
            r.setModuleName(appName);
            String keyItem = r.getModuleName();
            List<Map<Locale, ResourceInfo>> listMap = m3ModuleResourceInfo.get(keyItem);
            if (listMap == null) {
                listMap = new ArrayList<Map<Locale, ResourceInfo>>();
            }
            listMap.add(item);
            m3ModuleResourceInfo.put(keyItem, listMap);
            resultMap.put(keyItem, listMap.size());
            String unDefine = ResourceUtil.getString("plugin.module2Name.undefine");
            List<Map<Locale, ResourceInfo>> unDefineListMap = m3ModuleResourceInfo.get(unDefine);
            if (unDefineListMap == null) {
                unDefineListMap = new ArrayList<Map<Locale, ResourceInfo>>();
            }
            for (Locale localeItem : locales) {
                if (item.containsKey(localeItem)) {
                    ResourceInfo rt = item.get(localeItem);
                    if (!Strings.isEmpty(rt.getValue())) continue;
                    unDefineListMap.add(item);
                    break;
                }
                unDefineListMap.add(item);
                break;
            }
            m3ModuleResourceInfo.put(unDefine, unDefineListMap);
            resultMap.put(unDefine, unDefineListMap.size());
        }
        return resultMap;
    }

    public static List<ResourceInfo> getM3ResourceInfo2List(String levelType) {
        ArrayList<ResourceInfo> resultList = new ArrayList<ResourceInfo>();
        if (m3ModuleResourceInfo != null) {
            for (List<Map<Locale, ResourceInfo>> itemList : m3ModuleResourceInfo.values()) {
                for (Map<Locale, ResourceInfo> mapItem : itemList) {
                    for (ResourceInfo rItem : mapItem.values()) {
                        if (Strings.isEmpty(levelType)) {
                            resultList.add(rItem);
                            continue;
                        }
                        if (!levelType.equals(rItem.getLevelType())) continue;
                        resultList.add(rItem);
                    }
                }
            }
        }
        return resultList;
    }

    public static Map<Locale, ResourceInfo> getM3ResourceInfoByUniqueKey(String uniqueKey) {
        Map<Locale, ResourceInfo> map = allM3resInfoMap.get(uniqueKey);
        if (map == null) {
            return null;
        }
        for (ResourceInfo resourceInfo : map.values()) {
            if (!resourceInfo.isM3()) continue;
            return map;
        }
        return null;
    }

    public static void clearM3ResourceInfo() {
        m3ModuleResourceInfo.clear();
        allM3resInfoMap.clear();
        m3Module2Name.clear();
    }
}

