/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.m3;

import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.m3.M3CustomI18nManager;
import com.seeyon.ctp.common.i18n.m3.M3I18nPathUtil;
import com.seeyon.ctp.common.i18n.m3.M3I18nResourceCacheHolder;
import com.seeyon.ctp.common.i18n.m3.M3I18nUtile;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.TypeReference;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class M3I18nLoaderManager {
    private static final Log log = CtpLogFactory.getLog(M3I18nLoaderManager.class);
    private static final String tformat = "_";
    private static final String wechatDir = "m3";
    private static Map<String, String> zipWechart = new ConcurrentHashMap<String, String>();
    private static Map<String, M3ZipFileInfo> appZipPath = new ConcurrentHashMap<String, M3ZipFileInfo>();
    private static M3I18nLoaderManager m3I18nLoader;
    private static long lastLoadTime;

    public static M3I18nLoaderManager getInstance() {
        if (m3I18nLoader == null) {
            m3I18nLoader = new M3I18nLoaderManager();
        }
        return m3I18nLoader;
    }

    public void setFroceReload() {
        lastLoadTime = 0L;
    }

    public M3ZipFileInfo getM3ZipInfoByAppID(String appID) {
        return appZipPath.get(appID);
    }

    public M3ZipFileInfo getM3ZipInfoByGroup(String group, String fileName) {
        if (appZipPath == null) {
            return null;
        }
        for (M3ZipFileInfo m3ZipFileInfo : appZipPath.values()) {
            if (!group.equals(m3ZipFileInfo.getZipGroup()) || !fileName.equals(m3ZipFileInfo.getZipFileName())) continue;
            return m3ZipFileInfo;
        }
        return null;
    }

    public void loadM3Resource(boolean isFroce) {
        boolean update = false;
        long modifTime = M3I18nResourceCacheHolder.getModifTime();
        if (lastLoadTime == 0L) {
            update = true;
        } else if (modifTime != 0L && modifTime > lastLoadTime) {
            update = true;
        }
        if (isFroce) {
            update = true;
        }
        if (!update) {
            return;
        }
        M3I18nResourceCacheHolder.clearM3ResourceInfo();
        this.loadAllAppZipPath();
        this.loadM3AppZipResource();
        List<Locale> allLocales = LocaleContext.getAllLocales();
        for (Locale localeItem : allLocales) {
            M3CustomI18nManager.getInstance().loadM3CustomI18nResources(localeItem, new HashMap<String, String>());
        }
        lastLoadTime = DateUtil.currentTimestamp().getTime();
    }

    public void loadM3AppZipResource() {
        if (appZipPath != null) {
            try {
                for (M3ZipFileInfo zipFileInfo : appZipPath.values()) {
                    String unZipFilePath = zipFileInfo.getUnZipFilePath();
                    File i18nFile = new File(unZipFilePath, "i18n");
                    HashSet<String> i18nFileSet = new HashSet<String>();
                    if (i18nFile.exists() && i18nFile.isDirectory()) {
                        for (File i18nItem : i18nFile.listFiles()) {
                            String fileName = i18nItem.getName();
                            if (!i18nItem.isFile() || !fileName.endsWith(".js")) continue;
                            i18nFileSet.add(fileName.substring(0, fileName.indexOf(tformat)));
                        }
                    }
                    List<Locale> allLocales = LocaleContext.getAllLocales();
                    for (String i18nFileName : i18nFileSet) {
                        for (Locale locale : allLocales) {
                            String i18nJS = M3I18nPathUtil.formatM3In8nFileName(tformat, locale);
                            String fileName = i18nFileName + tformat + i18nJS + ".js";
                            String i18nFilePath = i18nFile.getAbsolutePath() + File.separator + fileName;
                            Map<String, String> items = this.readJSFile(i18nFilePath);
                            if (items.isEmpty()) continue;
                            M3I18nUtile.cacheM3AppI18nResouce(locale, items, i18nFilePath, i18nFileName, zipFileInfo);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"M3 \u56fd\u9645\u5316\uff1a", (Throwable)e);
            }
        }
    }

    public void updataM3ZipFile() {
        Map fileNameI18nMap;
        List<ResourceInfo> infos = M3I18nResourceCacheHolder.getM3ResourceInfo2List("custom");
        HashMap zipI18nMap = new HashMap();
        for (ResourceInfo itemResInfo : infos) {
            HashMap<String, String> in18ItemMap;
            HashMap<Locale, HashMap<String, String>> localeIn18ItemMap;
            String uniqueKey = itemResInfo.getUniqueKey();
            if (Strings.isEmpty(uniqueKey)) {
                log.error((Object)("M3 \u751f\u6210\u5e94\u7528\u5305\uff0cuniqueKey\u4e0d\u5b58\u5728" + itemResInfo.getUniqueKey()));
                continue;
            }
            String[] args = uniqueKey.split("\\|");
            if (args.length != 3) {
                log.error((Object)("M3 \u751f\u6210\u5e94\u7528\u5305\uff0cuniqueKey \u683c\u5f0f\u4e0d\u5bf9" + itemResInfo.getUniqueKey()));
                continue;
            }
            String appID = args[0];
            String fileName = args[1];
            Locale locale = itemResInfo.getLocale();
            fileNameI18nMap = (HashMap)zipI18nMap.get(appID);
            if (fileNameI18nMap == null) {
                fileNameI18nMap = new HashMap();
                zipI18nMap.put(appID, fileNameI18nMap);
            }
            if ((localeIn18ItemMap = (HashMap<Locale, HashMap<String, String>>)fileNameI18nMap.get(fileName)) == null) {
                localeIn18ItemMap = new HashMap<Locale, HashMap<String, String>>();
                fileNameI18nMap.put(fileName, localeIn18ItemMap);
            }
            if ((in18ItemMap = (HashMap<String, String>)localeIn18ItemMap.get(locale)) == null) {
                in18ItemMap = new HashMap<String, String>();
                localeIn18ItemMap.put(itemResInfo.getLocale(), in18ItemMap);
            }
            in18ItemMap.put(itemResInfo.getKey(), itemResInfo.getValue());
        }
        if (!zipI18nMap.isEmpty()) {
            Set appIDS = zipI18nMap.keySet();
            block7: for (String appID : appIDS) {
                File tempI18nFile;
                File tempZipFile;
                M3ZipFileInfo m3ZipFileInfo;
                block22: {
                    if (!appZipPath.containsKey(appID)) continue;
                    m3ZipFileInfo = appZipPath.get(appID);
                    tempZipFile = new File(m3ZipFileInfo.getUnZipFilePath());
                    if (!tempZipFile.exists()) {
                        String zipFilePath = m3ZipFileInfo.getZipFilePath();
                        File zipFile = new File(zipFilePath);
                        if (zipFile.exists()) {
                            String tempRoot = M3I18nPathUtil.getM3I18nTempDirPathAbs();
                            String zipFileName = FileUtil.getFileNameWithoutSuffix(zipFile.getName());
                            File tempFolder = new File(tempRoot + File.separator + (String)zipFileName);
                            FileUtil.makeDir(tempFolder.getAbsolutePath());
                            FileUtil.clearFolder(tempFolder);
                            try {
                                ZipUtil.unzip(zipFile, tempFolder);
                                break block22;
                            }
                            catch (IOException e1) {
                                log.error((Object)("M3 \u56fd\u9645\u5316\uff1a\u89e3\u538b\u5e94\u7528\u5305\u51fa\u9519\uff0c" + zipFilePath), (Throwable)e1);
                                continue;
                            }
                        }
                        log.error((Object)("M3 \u56fd\u9645\u5316\uff1a\u5e94\u7528\u5305\u4e0d\u5b58\u5728" + zipFilePath));
                        continue;
                    }
                }
                if (!(tempI18nFile = new File(tempZipFile, "i18n")).exists()) {
                    log.debug((Object)("M3 \u56fd\u9645\u5316\uff1a\u5e94\u7528\u5305\u4e0d\u5b58\u5728i18n\u6587\u4ef6\u5939 appID=" + appID));
                    continue;
                }
                List<Locale> allLocales = LocaleContext.getAllLocales();
                fileNameI18nMap = (Map)zipI18nMap.get(appID);
                for (String fileName : fileNameI18nMap.keySet()) {
                    Map localeI18nMap = (Map)fileNameI18nMap.get(fileName);
                    for (Locale localeItem : allLocales) {
                        if (!localeI18nMap.containsKey(localeItem)) continue;
                        Map i18nItemMap = (Map)localeI18nMap.get(localeItem);
                        String i18nJS = M3I18nPathUtil.formatM3In8nFileName(tformat, localeItem);
                        String jsFileName = fileName + tformat + i18nJS + ".js";
                        File appI18nItemFile = new File(tempI18nFile, jsFileName);
                        StringBuilder content = new StringBuilder("\r\n//\u4ee5\u4e0b\u5185\u5bb9\u662f\u7531\u540e\u53f0\u56fd\u9645\u5316\u7ba1\u7406\u5de5\u5177\u81ea\u52a8\u751f\u4ea7\u7684\u4fe1\u606f");
                        if (!appI18nItemFile.exists()) {
                            try {
                                appI18nItemFile.createNewFile();
                                content.append("\r\n").append("if(typeof fI18nData == \"undefined\"){").append("\r\n").append("fI18nData = {}").append("\r\n").append("}");
                            }
                            catch (IOException e) {
                                log.error((Object)"M3 \u56fd\u9645\u5316\uff1a", (Throwable)e);
                                continue;
                            }
                        }
                        for (String i18nKey : i18nItemMap.keySet()) {
                            content.append("\r\n").append("fI18nData[\"").append(i18nKey).append("\"]=\"").append(I18nUtil.escapeJavascript((String)i18nItemMap.get(i18nKey))).append("\";");
                        }
                        boolean addRet = FileUtil.addContent(appI18nItemFile, content.toString());
                        if (addRet) continue;
                        continue block7;
                    }
                }
                try {
                    String destDir = M3I18nPathUtil.getM3ZipDestDirAbs(m3ZipFileInfo.getZipGroup());
                    File destZipFile = new File(destDir);
                    if (!destZipFile.exists()) {
                        destZipFile.mkdirs();
                    }
                    File dirZipFile = new File(destDir + File.separator + m3ZipFileInfo.getZipFileName());
                    FileUtil.deleteFile(dirZipFile);
                    log.debug((Object)("M3 \u56fd\u9645\u5316\uff1a\u91cd\u65b0\u751f\u6210\u5e94\u7528\u5305-start-" + m3ZipFileInfo.getZipFileName()));
                    ZipUtil.zip(tempZipFile, dirZipFile, false);
                    log.debug((Object)("M3 \u56fd\u9645\u5316\uff1a\u91cd\u65b0\u751f\u6210\u5e94\u7528\u5305-end-" + m3ZipFileInfo.getZipFileName()));
                }
                catch (Exception e) {
                    log.error((Object)"M3 \u56fd\u9645\u5316\uff1a\u6253\u5305\u5e94\u7528\u5305\u51fa\u9519\uff0c", (Throwable)e);
                }
            }
        }
    }

    private void loadAllAppZipPath() {
        appZipPath.clear();
        ArrayList<String> list = new ArrayList<String>();
        File defFile = new File(M3I18nPathUtil.getM3ZipDirAbs());
        if (!defFile.exists()) {
            log.error((Object)("M3 \u56fd\u9645\u5316\uff1a\u5e94\u7528\u5305\u8def\u5f84\u4e0d\u6b63\u786e\uff01\uff01\uff01" + defFile.getAbsolutePath()));
        }
        for (File fileItem : defFile.listFiles()) {
            if (!fileItem.isDirectory()) continue;
            for (File zipItem : fileItem.listFiles()) {
                String fileName = zipItem.getName();
                if (!fileName.endsWith(".zip") || !zipItem.isFile()) continue;
                String zipAbsPath = zipItem.getAbsolutePath();
                list.add(zipAbsPath);
            }
        }
        if (list != null) {
            try {
                String tempRoot = M3I18nPathUtil.getM3I18nTempDirPathAbs();
                FileUtil.makeDir(tempRoot);
                Map<String, String> zipFileMd5Map = M3I18nLoaderManager.readZipFileMd5Cache();
                for (String zipFilePath : list) {
                    File zipFile = new File(zipFilePath);
                    if (!zipFile.exists()) continue;
                    String tempFolder = tempRoot + File.separator + FileUtil.getFileNameWithoutSuffix(zipFile.getName());
                    FileUtil.makeDir(tempFolder);
                    File outFile = new File(tempFolder);
                    String fileName = zipFile.getName();
                    String m3ZipDir = M3I18nPathUtil.getM3ZipDirAbs();
                    String zipRevPath = zipFilePath.substring(zipFilePath.indexOf(m3ZipDir) + m3ZipDir.length());
                    String group = zipRevPath.substring(1, zipRevPath.indexOf(fileName) - 1);
                    String md5 = M3I18nLoaderManager.getMD5(zipFile);
                    if (!zipFileMd5Map.containsKey(zipRevPath) || !md5.equals(zipFileMd5Map.get(zipRevPath))) {
                        zipFileMd5Map.remove(zipRevPath);
                        log.debug((Object)("M3 \u56fd\u9645\u5316\uff1a\u89e3\u538b\u5e94\u7528\u5305\u5230\u4e34\u65f6\u76ee\u5f55 " + fileName));
                        log.debug((Object)("M3 \u56fd\u9645\u5316\uff1a\u89e3\u538b\u5e94\u7528\u5305---start---" + fileName));
                        try {
                            FileUtil.clearFolder(outFile);
                            ZipUtil.unzip(zipFile, outFile);
                        }
                        catch (Exception e) {
                            log.error((Object)("M3 \u56fd\u9645\u5316\uff1a\u89e3\u538b\u5e94\u7528\u5305\u51fa\u9519\uff0c" + zipFilePath), (Throwable)e);
                            continue;
                        }
                        log.debug((Object)("M3 \u56fd\u9645\u5316\uff1a\u89e3\u538b\u5e94\u7528\u5305---end---" + fileName));
                    }
                    File manifestFile = new File(tempFolder, "manifest.json");
                    if (manifestFile.exists()) {
                        Map<String, Object> manifest = I18nUtil.parseJSONFile(manifestFile);
                        String appName = (String)manifest.get("appName");
                        String appId = (String)manifest.get("appId");
                        String bundleName = (String)manifest.get("bundleName");
                        if (StringUtils.isNotBlank((CharSequence)appName) && StringUtils.isNotBlank((CharSequence)appId)) {
                            M3ZipFileInfo zipFileInfo = new M3ZipFileInfo();
                            zipFileInfo.setAppID(appId);
                            zipFileInfo.setAppName(appName);
                            zipFileInfo.setBundleName(bundleName);
                            zipFileInfo.setZipFileName(fileName);
                            zipFileInfo.setZipFilePath(zipFilePath);
                            zipFileInfo.setZipFileRevPath(zipRevPath);
                            zipFileInfo.setUnZipFilePath(tempFolder);
                            zipFileInfo.setZipGroup(group);
                            zipFileInfo.setMd5(md5);
                            appZipPath.put(appId, zipFileInfo);
                            zipFileMd5Map.put(zipRevPath, md5);
                            continue;
                        }
                        log.error((Object)("M3 \u56fd\u9645\u5316\uff1amanifest\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e,appId:" + appId + ",appName:" + appName));
                        continue;
                    }
                    log.error((Object)"M3 \u56fd\u9645\u5316\uff1amanifest \u6587\u4ef6\u4e0d\u5b58\u5728.");
                }
                M3I18nLoaderManager.saveZipFileMd5Cache(zipFileMd5Map);
            }
            catch (Exception e) {
                log.error((Object)"M3 \u56fd\u9645\u5316\uff1a", (Throwable)e);
            }
        }
    }

    private static Map<String, String> readZipFileMd5Cache() {
        Map<String, String> md5Map = new HashMap<String, String>();
        String tempRoot = M3I18nPathUtil.getM3I18nTempDirPathAbs();
        File cacheFile = new File(tempRoot, "zipFileMd5.json");
        if (!cacheFile.exists() || !cacheFile.isFile()) {
            return md5Map;
        }
        try {
            String cacheJson = FileUtils.readFileToString((File)cacheFile, (String)"UTF-8");
            md5Map = (Map)JSONUtil.parseJSONString(cacheJson, new TypeReference<Map<String, String>>(){}.getType());
            return md5Map;
        }
        catch (Exception e) {
            log.error((Object)"M3 \u56fd\u9645\u5316\uff1a\u52a0\u8f7dzip file Md5 error ", (Throwable)e);
            return md5Map;
        }
    }

    private static void saveZipFileMd5Cache(Map<String, String> md5CacheMap) {
        String tempRoot = M3I18nPathUtil.getM3I18nTempDirPathAbs();
        try {
            File cacheFile = new File(tempRoot, "zipFileMd5.json");
            if (cacheFile.exists()) {
                FileUtil.deleteFile(cacheFile);
            }
            String cacheJson = JSONUtil.toJSONString(md5CacheMap);
            FileUtils.writeStringToFile((File)cacheFile, (String)cacheJson, (String)"UTF-8");
        }
        catch (Exception e) {
            log.error((Object)"M3 \u56fd\u9645\u5316\uff1a\u4fdd\u5b58 zip file Md5 error ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readJSFile(String filePath) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        File jsFile = new File(filePath);
        if (jsFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jsFile), "UTF-8"));
                Pattern i18nPatt = Pattern.compile("^fI18nData[\\s]*\\[[\\s]*([\"'])(.+?)\\1[\\s]*\\][\\s]*=[\\s]*([\"'])(.+?)\\3;?$");
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Matcher m;
                    if ((line = line.trim()).length() <= 0 || !(m = i18nPatt.matcher(line)).find()) continue;
                    String key = m.group(2);
                    String srcValue = m.group(4);
                    StringBuilder value = new StringBuilder();
                    int last = 32;
                    for (int i = 0; i < srcValue.length(); ++i) {
                        char c = srcValue.charAt(i);
                        if (c == '\\') {
                            if (last == 92) {
                                value.append(c);
                                last = 32;
                                continue;
                            }
                        } else {
                            value.append(c);
                        }
                        last = c;
                    }
                    itemMap.put(key, value.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            log.debug((Object)("M3 \u56fd\u9645\u5316\uff1a\u56fd\u9645\u5316\u6587\u4ef6\u4e0d\u5b58\u5728" + filePath));
        }
        return itemMap;
    }

    public static String getMD5(File f) {
        String md5 = null;
        try {
            FileInputStream fis = new FileInputStream(f);
            md5 = DigestUtils.md5Hex(IOUtils.toByteArray((InputStream)fis));
            IOUtils.closeQuietly((InputStream)fis);
        }
        catch (IOException e) {
            log.error((Object)"M3 \u56fd\u9645\u5316\uff1a\u52a0\u8f7dzip Md5", (Throwable)e);
        }
        return md5;
    }

    static {
        lastLoadTime = 0L;
    }

    public class M3ZipFileInfo {
        private String appID;
        private String appName;
        private String bundleName;
        private String md5;
        private String zipFileName;
        private String zipFileRevPath;
        private String zipFilePath;
        private String unZipFilePath;
        private String zipGroup;

        public String getAppID() {
            return this.appID;
        }

        public void setAppID(String appID) {
            this.appID = appID;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        public void setBundleName(String bundleName) {
            this.bundleName = bundleName;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public String getZipFileName() {
            return this.zipFileName;
        }

        public void setZipFileName(String zipFileName) {
            this.zipFileName = zipFileName;
        }

        public String getZipFileRevPath() {
            return this.zipFileRevPath;
        }

        public void setZipFileRevPath(String zipFileRevPath) {
            this.zipFileRevPath = zipFileRevPath;
        }

        public String getZipFilePath() {
            return this.zipFilePath;
        }

        public void setZipFilePath(String zipFilePath) {
            this.zipFilePath = zipFilePath;
        }

        public String getUnZipFilePath() {
            return this.unZipFilePath;
        }

        public void setUnZipFilePath(String unZipFilePath) {
            this.unZipFilePath = unZipFilePath;
        }

        public String getZipGroup() {
            return this.zipGroup;
        }

        public void setZipGroup(String zipGroup) {
            this.zipGroup = zipGroup;
        }
    }
}

