/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.expand;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ProductEditionEnum;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.expand.Loader;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.logging.Log;

public class ProductLoader
extends Loader {
    private static final Log log = CtpLogFactory.getLog(ProductLoader.class);
    private Loader loader;
    private static final String LEVEL_TYPE = "product";

    public ProductLoader(Loader loader) {
        this.loader = loader;
        this.setResourceMap(loader.getResourceMap());
    }

    public void setLoader(Loader loader) {
        this.loader = loader;
    }

    public void process() {
        File levelFile = this.getI18nBase(AppContext.getCfgHome());
        if (levelFile != null && levelFile.exists() && levelFile.isDirectory()) {
            HashMap<String, ResourceInfo> resMap = new HashMap<String, ResourceInfo>();
            this.loadI18nResources(LEVEL_TYPE, AppContext.getCfgHome(), resMap, null);
            if (!resMap.isEmpty()) {
                this.getResourceMap().putAll(resMap);
            }
        }
    }

    @Override
    public void loadResource() {
        this.loader.loadResource();
        this.process();
    }

    @Override
    protected File getI18nBase(File i18nBase) {
        ProductEditionEnum productEditionEnum = ProductEditionEnum.getCurrentProductEditionEnum();
        String version = productEditionEnum.getValue();
        return new File(i18nBase, File.separator + "i18nPoductLine" + File.separator + version);
    }
}

