/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ProductEditionEnum;
import com.seeyon.ctp.common.datai18n.manager.DataI18nManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceLoader;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public final class ResourceUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(ResourceUtil.class);
    private static final String DEFAULT_VALUE = "";
    private static String i18nSuffixUpperCase = "";
    private static String i18nSuffixLowerCase = "";
    private static DataI18nManager dataI18nManager;

    public static DataI18nManager getDataI18nManager() {
        if (dataI18nManager == null) {
            dataI18nManager = (DataI18nManager)AppContext.getBean("dataI18nManager");
        }
        return dataI18nManager;
    }

    public static String getString(String key) {
        return ResourceUtil.getStringByParams(key, new Object[0]);
    }

    public static String getString(Long dataI18nId) throws BusinessException {
        return ResourceUtil.getString(dataI18nId, AppContext.getLocale());
    }

    public static String getString(Long dataI18nId, Locale locale) {
        return ResourceUtil.getDataI18nManager().getDataI18nValueWithCompensate(dataI18nId, locale);
    }

    public static String getDataI18nString(String dataI18n) {
        if (!Strings.isLong(dataI18n)) {
            return dataI18n;
        }
        return ResourceUtil.getDataI18nString(dataI18n, AppContext.getLocale());
    }

    public static String getDataI18nString(String dataI18n, Locale locale) {
        if (!Strings.isLong(dataI18n)) {
            return dataI18n;
        }
        return ResourceUtil.getString(Long.valueOf(dataI18n), locale);
    }

    public static String getString(String key, Object param1) {
        return ResourceUtil.getStringByParams(key, param1);
    }

    public static String getString(String key, Object param1, Object param2) {
        return ResourceUtil.getStringByParams(key, param1, param2);
    }

    public static String getString(String key, Object param1, Object param2, Object param3) {
        return ResourceUtil.getStringByParams(key, param1, param2, param3);
    }

    public static String getString(String key, Object param1, Object param2, Object param3, Object param4) {
        return ResourceUtil.getStringByParams(key, param1, param2, param3, param4);
    }

    public static String getString(String key, Object param1, Object param2, Object param3, Object param4, Object param5) {
        return ResourceUtil.getStringByParams(key, param1, param2, param3, param4, param5);
    }

    public static String getStringByParams(String key, Object ... parameters) {
        return ResourceUtil.getStringByParams(AppContext.getLocale(), key, parameters);
    }

    public static String getStringByParams(Locale locale, String key, Object ... parameters) {
        if (Strings.isBlank(key)) {
            return key;
        }
        String suffixKey = key + i18nSuffixUpperCase;
        String message = ResourceLoader.getResources(locale, suffixKey);
        if (message == null || DEFAULT_VALUE.equals(message.trim())) {
            suffixKey = key + i18nSuffixLowerCase;
            message = ResourceLoader.getResources(locale, suffixKey);
        }
        if (message == null || DEFAULT_VALUE.equals(message.trim())) {
            message = ResourceLoader.getResources(locale, key);
        }
        if (message != null && parameters != null) {
            message = ResourceUtil.format(message, locale, parameters);
        }
        if (message == null) {
            if (key.charAt(0) == '-' && Strings.isLong(key)) {
                return ResourceUtil.getString(Long.valueOf(key), locale);
            }
            return key;
        }
        return message;
    }

    public static String getStringByLocaleAndParams(String key, Locale locale, Object ... parameters) {
        String message;
        if (locale == null) {
            locale = AppContext.getLocale();
        }
        if ((message = ResourceLoader.getResources(locale, key)) != null && parameters != null) {
            message = ResourceUtil.format(message, locale, parameters);
        }
        if (message == null) {
            return key;
        }
        return message;
    }

    private static String format(String message, Locale locale, Object ... parameters) {
        try {
            Object[] p = parameters;
            if (p.length == 1 && p[0] instanceof String[]) {
                p = (Object[])p[0];
            }
            MessageFormat formatter = new MessageFormat(message, locale);
            message = formatter.format(p);
        }
        catch (Exception e) {
            LOGGER.error((Object)(message + "\t" + StringUtils.join((Object[])parameters, (String)", ")), (Throwable)e);
            return DEFAULT_VALUE;
        }
        return message;
    }

    public static boolean compairI18nInfoByName(List<String> nameList, String compairName) throws BusinessException {
        List<String> compairnameList = ResourceUtil.geti18nInfoByName(compairName);
        ArrayList<String> newNameList = new ArrayList<String>();
        newNameList.addAll(nameList);
        newNameList.retainAll(compairnameList);
        return Strings.isNotEmpty(newNameList);
    }

    public static List<String> geti18nInfoByName(String name) throws BusinessException {
        ArrayList<String> resultList = new ArrayList<String>();
        Map<Object, Object> i18nMap = new LinkedHashMap();
        if (Strings.isLong(name)) {
            i18nMap = dataI18nManager.getAllDataI18nValueMap(Long.parseLong(name));
            if (MapUtils.isNotEmpty(i18nMap)) {
                for (String string : i18nMap.keySet()) {
                    resultList.add((String)i18nMap.get(string));
                }
            } else {
                resultList.add(ResourceUtil.getString(name));
            }
        } else {
            resultList.add(ResourceUtil.getString(name));
        }
        return resultList;
    }

    static {
        String i18nSuffix = DEFAULT_VALUE;
        if (!SystemEnvironment.isRemoteMode()) {
            i18nSuffix = ProductEditionEnum.getCurrentProductEditionEnum().getI18nSuffix();
        }
        i18nSuffixUpperCase = i18nSuffix.toUpperCase();
        i18nSuffixLowerCase = i18nSuffix.toLowerCase();
    }
}

