/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.XMLCoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.taglibs.standard.tag.common.fmt.BundleSupport;

public class ResourceBundleUtil {
    private static Log log = CtpLogFactory.getLog(ResourceBundleUtil.class);
    private static final String DEFAULT_VALUE = "";

    public static String getString(String resource, String key, Object ... parameters) {
        if (resource == null || DEFAULT_VALUE.equals(resource)) {
            return key;
        }
        Locale locale = AppContext.getLocale();
        String result = ResourceBundleUtil.getString(resource, locale, key, parameters);
        if (key.equals(result)) {
            result = ResourceBundleUtil.getString(resource, Locale.getDefault(), key, parameters);
        }
        return result;
    }

    public static String getStringOfParameterXML(String resource, String key, String paramXML) {
        Object[] params = null;
        if (Strings.isNotBlank(paramXML)) {
            params = (Object[])XMLCoder.decoder(paramXML);
        }
        return ResourceBundleUtil.getString(resource, key, params);
    }

    public static String getString(String resource, Locale locale, String key, Object ... parameters) {
        ResourceBundle bundle;
        if (Strings.isNotBlank(key) && !key.contains(".") & !key.contains("_")) {
            return key;
        }
        String value = ResourceUtil.getStringByParams(key, parameters);
        if (value != null && value.length() > 0 && key.compareTo(value) != 0) {
            return value;
        }
        if (Strings.isBlank(resource)) {
            return key;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((bundle = ResourceBundleUtil.getResourceBundle(resource, locale)) == null) {
            return key;
        }
        String message = null;
        try {
            message = bundle.getString(key);
        }
        catch (Exception e) {
            return key;
        }
        if (message != null && parameters != null) {
            return ResourceBundleUtil.format(message, locale, parameters);
        }
        return message;
    }

    public static String getString(PageContext pageContext, String key, Object ... parameters) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return DEFAULT_VALUE;
        }
        if (!Strings.isI18NKey(key)) {
            return key;
        }
        String message = null;
        LocalizationContext locCtxt = null;
        locCtxt = BundleSupport.getLocalizationContext((PageContext)pageContext);
        message = ResourceBundleUtil.getString(locCtxt, key, parameters);
        if (message == null) {
            locCtxt = (LocalizationContext)pageContext.getAttribute("v3xCommonI18N");
            message = ResourceBundleUtil.getString(locCtxt, key, new Object[0]);
        }
        return message != null ? message : key;
    }

    public static String getString(LocalizationContext locCtxt, String key, Object ... parameters) {
        if (!Strings.isI18NKey(key)) {
            return key;
        }
        String value = ResourceUtil.getStringByParams(key, parameters);
        if (value != null && value.length() > 0 && key.compareTo(value) != 0) {
            return value;
        }
        if (locCtxt == null) {
            return null;
        }
        ResourceBundle bundle = locCtxt.getResourceBundle();
        if (bundle != null) {
            try {
                String message = bundle.getString(key);
                return ResourceBundleUtil.format(message, locCtxt.getLocale(), parameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getString(ResourceBundle resourceBundle, String key, Object ... parameters) {
        if (!Strings.isI18NKey(key)) {
            return key;
        }
        String value = ResourceUtil.getStringByParams(resourceBundle.getLocale(), key, parameters);
        if (value != null && value.length() > 0 && key.compareTo(value) != 0) {
            return value;
        }
        if (resourceBundle == null) {
            return key;
        }
        String message = null;
        try {
            message = resourceBundle.getString(key);
        }
        catch (Exception e) {
            return key;
        }
        return ResourceBundleUtil.format(message, resourceBundle.getLocale(), parameters);
    }

    private static String format(String message, Locale locale, Object ... parameters) {
        if (message != null && parameters != null) {
            try {
                MessageFormat formatter = new MessageFormat(message, locale);
                message = formatter.format(parameters);
            }
            catch (Exception e) {
                log.error((Object)(message + "\t" + StringUtils.join((Object[])parameters, (String)", ")), (Throwable)e);
                return DEFAULT_VALUE;
            }
        }
        return message;
    }

    public static Set<String> getKeys(String resource, String value) {
        HashSet<String> result = new HashSet<String>();
        if (value == null) {
            return result;
        }
        List<Locale> locales = LocaleContext.getAllLocales();
        for (Locale locale : locales) {
            result.addAll(ResourceBundleUtil.getKeys(resource, locale, value));
        }
        return result;
    }

    public static Set<String> getKeys(String baseName, Locale locale, String value) {
        HashSet<String> result = new HashSet<String>();
        ResourceBundle bundle = ResourceBundleUtil.getResourceBundle(baseName, locale);
        if (bundle == null) {
            return result;
        }
        Enumeration<String> keys = bundle.getKeys();
        while (keys != null && keys.hasMoreElements()) {
            String key = String.valueOf(keys.nextElement());
            String v = ResourceUtil.getString(key);
            v = v == null || v.length() == 0 || v.compareTo(key) == 0 ? bundle.getString(key) : v;
            if (!value.equals(v)) continue;
            result.add(key);
        }
        return result;
    }

    public static ResourceBundle getResourceBundle(String baseName, final Locale locale) {
        ResourceBundle bundle = ResourceBundleUtil.findMatch(baseName, locale);
        if (bundle == null) {
            Locale loc;
            List<Locale> locales = LocaleContext.getAllLocales();
            if (locales == null) {
                return null;
            }
            Iterator<Locale> iterator = locales.iterator();
            while (iterator.hasNext() && (bundle = ResourceBundleUtil.findMatch(baseName, loc = iterator.next())) == null) {
            }
        }
        if (bundle == null) {
            bundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String key) {
                    return ResourceUtil.getString(key);
                }

                @Override
                public Enumeration<String> getKeys() {
                    return null;
                }

                @Override
                public Locale getLocale() {
                    return locale;
                }
            };
        }
        return bundle;
    }

    private static ResourceBundle findMatch(String baseName, Locale pref) {
        try {
            return ResourceBundle.getBundle(baseName, pref, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

