/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Cookies;
import com.seeyon.ctp.util.Strings;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

public final class LocaleContext {
    private static final Log log = CtpLogFactory.getLog(LocaleContext.class);
    public static String sysDefaultLocale;
    private static List<Locale> locales;

    public static Locale getLocale(ServletRequest request) {
        return AppContext.getLocale();
    }

    public static String getSysDefaultLocale() {
        return sysDefaultLocale;
    }

    public static Locale getSysSetDefaultLocale() {
        Locale defaultLocal = new Locale("en");
        for (Locale l : locales) {
            String key = I18nUtil.getLocalAsString(l);
            if (!key.equals(sysDefaultLocale)) continue;
            defaultLocal = l;
        }
        return defaultLocal;
    }

    public static void setSysDefaultLocale(String sysDefaultLocale) {
        LocaleContext.sysDefaultLocale = sysDefaultLocale;
    }

    private static Locale getOrginalLocale(ServletRequest request) {
        Object obj;
        Locale loc = null;
        HttpSession session = ((HttpServletRequest)request).getSession();
        if (session != null && (obj = session.getAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME)) != null) {
            loc = (Locale)obj;
        }
        return loc;
    }

    public static String getLanguage(ServletRequest request) {
        Locale locale = LocaleContext.getLocale(request);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        boolean l = language.length() != 0;
        boolean c = country.length() != 0;
        boolean v = variant.length() != 0;
        StringBuilder result = new StringBuilder(language);
        if (c || l && v) {
            result.append('-').append(country);
        }
        if (v && (l || c)) {
            result.append('-').append(variant);
        }
        return result.toString().toLowerCase();
    }

    public static void setLocale(HttpSession session, Locale locale) {
        locale = LocaleContext.merge(locale);
        session.setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, (Object)locale);
    }

    public static void setLocale(ServletRequest _request, Locale locale) {
        HttpServletRequest request = (HttpServletRequest)_request;
        LocaleContext.setLocale(request.getSession(), locale);
    }

    public static Locale parseLocale(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return null;
        }
        String[] localeArray = language.split("[-|_]");
        String country = "";
        String variant = "";
        for (int i = 0; i < localeArray.length; ++i) {
            if (i == 0) {
                language = localeArray[i];
                continue;
            }
            if (i == 1) {
                country = localeArray[i];
                continue;
            }
            if (i != 2) continue;
            variant = localeArray[i];
        }
        return new Locale(language, country, variant);
    }

    public static void intAllLocales(List<Locale> locs) {
        locales = locs;
    }

    public static List<Locale> getAllLocales() {
        return locales;
    }

    public static Locale merge(Locale locale) {
        if (locale == null || !LocaleContext.getAllLocales().contains(locale)) {
            locale = LocaleContext.getAllLocales().get(0);
        }
        return locale;
    }

    public static Locale make4Frontpage(HttpServletRequest request) {
        String cookiewLocale;
        Locale currentLocale = LocaleContext.parseLocale(request.getParameter("login_locale"));
        if (currentLocale == null) {
            currentLocale = LocaleContext.getOrginalLocale((ServletRequest)request);
        }
        if (currentLocale == null && Strings.isNotBlank(cookiewLocale = Cookies.get(request, "login_locale"))) {
            currentLocale = LocaleContext.parseLocale(cookiewLocale);
        }
        if (currentLocale == null) {
            currentLocale = LocaleContext.parseLocale(LocaleContext.getSysDefaultLocale());
        }
        if (null == currentLocale) {
            currentLocale = request.getLocale();
        }
        currentLocale = LocaleContext.merge(currentLocale);
        LocaleContext.setLocale((ServletRequest)request, currentLocale);
        return currentLocale;
    }

    static {
        locales = null;
    }
}

