/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.formula.enums;

import com.seeyon.ctp.common.code.EnumsCode;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import java.util.Date;

public enum VariableDataType implements EnumsCode
{
    String(1, "ctp.formulas.dataType.string"),
    Numberic(2, "ctp.formulas.dataType.numberic"),
    DateTime(3, "ctp.formulas.dataType.datetime"),
    Bool(4, "ctp.formulas.dataType.bool");

    private int value;
    private String text;

    private VariableDataType(int value, String text) {
        this.value = value;
        this.text = text;
    }

    public int getKey() {
        return this.value;
    }

    @Override
    public String getText() {
        return ResourceUtil.getString(this.text);
    }

    @Override
    public String getValue() {
        return java.lang.String.valueOf(this.value);
    }

    public static String getText(int key) {
        VariableDataType[] enums;
        for (VariableDataType a : enums = VariableDataType.values()) {
            if (a.getKey() != key) continue;
            return a.getText();
        }
        return null;
    }

    public static VariableDataType valueOf(Class clazz) {
        if (clazz.isAssignableFrom(Number.class)) {
            return Numberic;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return String;
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            return Bool;
        }
        if (clazz.isAssignableFrom(Date.class)) {
            return DateTime;
        }
        throw new UnsupportedOperationException("\u4e0d\u517c\u5bb9\u7684\u6570\u636e\u7c7b\u578b\uff1a" + clazz.getCanonicalName());
    }
}

