/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.formula.enums;

import com.seeyon.ctp.common.code.EnumsCode;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import java.util.Date;
import org.apache.commons.lang3.ClassUtils;

public enum DataType implements EnumsCode
{
    String(1, "ctp.formulas.dataType.string"),
    Numberic(2, "ctp.formulas.dataType.numberic"),
    Date(18, "ctp.formulas.dataType.date"),
    DateTime(3, "ctp.formulas.dataType.datetime"),
    Bool(4, "ctp.formulas.dataType.bool"),
    Object(17, "ctp.formulas.dataType.object");

    private int value;
    private String text;

    private DataType(int value, String text) {
        this.value = value;
        this.text = text;
    }

    public int getKey() {
        return this.value;
    }

    public static DataType getEnum(int key) {
        DataType[] enums;
        for (DataType a : enums = DataType.values()) {
            if (a.getKey() != key) continue;
            return a;
        }
        return null;
    }

    @Override
    public String getText() {
        return ResourceUtil.getString(this.text);
    }

    @Override
    public String getValue() {
        return java.lang.String.valueOf(this.value);
    }

    public static String getText(int key) {
        DataType[] enums;
        for (DataType a : enums = DataType.values()) {
            if (a.getKey() != key) continue;
            return a.getText();
        }
        return null;
    }

    public static DataType valueOf(Class clazz) {
        Class c = ClassUtils.primitiveToWrapper((Class)clazz);
        if (Number.class.isAssignableFrom(c)) {
            return Numberic;
        }
        if (String.class.isAssignableFrom(c)) {
            return String;
        }
        if (Boolean.class.isAssignableFrom(c)) {
            return Bool;
        }
        if (Date.class.isAssignableFrom(c)) {
            return DateTime;
        }
        throw new UnsupportedOperationException("\u4e0d\u517c\u5bb9\u7684\u6570\u636e\u7c7b\u578b\uff1a" + clazz.getCanonicalName());
    }
}

