/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.fileupload.manager;

import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.fileupload.manager.ImagecutManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ImageUtil;
import com.seeyon.ctp.util.UUIDLong;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;

@ProcessInDataSource(name=DataSourceName.BASE)
public class ImagecutManagerImpl
implements ImagecutManager {
    private static final Log logger = CtpLogFactory.getLog(ImagecutManagerImpl.class);
    private FileManager fileManager = null;

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String imgCuttingAndSave(Map<String, Object> cuttingParam) throws BusinessException {
        String processedHeadImgId = null;
        if (cuttingParam != null && cuttingParam.size() > 0) {
            long originalImgFileId = Long.valueOf(cuttingParam.get("originalImgFileId").toString());
            int originalWidth = Integer.valueOf(cuttingParam.get("originalWidth").toString());
            int originalHeight = Integer.valueOf(cuttingParam.get("originalHeight").toString());
            int x = Integer.valueOf(cuttingParam.get("x").toString());
            int y = Integer.valueOf(cuttingParam.get("y").toString());
            int w = Integer.valueOf(cuttingParam.get("w").toString());
            int h = Integer.valueOf(cuttingParam.get("h").toString());
            String formatName = cuttingParam.get("formatName").toString();
            Date now = DateUtil.currentDate();
            File originalImg = this.fileManager.getFile(originalImgFileId, now);
            ByteArrayInputStream input = null;
            try {
                byte[] bytes = ImageUtil.cutAndCompress(originalImg, formatName, originalWidth, originalHeight, x, y, w, h);
                input = new ByteArrayInputStream(bytes);
                V3XFile targetFile = this.fileManager.save(input, ApplicationCategoryEnum.organization, UUIDLong.longUUID() + "." + formatName, now, (Boolean)true);
                this.fileManager.deleteFile(originalImgFileId, true);
                processedHeadImgId = targetFile.getId().toString();
            }
            catch (IOException ioe) {
                logger.error((Object)"\u526a\u5207\u56fe\u7247\u51fa\u9519", (Throwable)ioe);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"\u526a\u5207\u56fe\u7247\uff0c\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519", (Throwable)e);
                    }
                }
            }
        }
        return processedHeadImgId;
    }

    @Override
    public int[] getSrcWidthAndHeight(Long fileId) throws BusinessException {
        Date now = DateUtil.currentDate();
        File file = this.fileManager.getFile(fileId, now);
        BufferedImage originalBi = null;
        int[] widthAndHeight = null;
        try {
            originalBi = ImageIO.read(file);
            int srcWidth = originalBi.getWidth();
            int srcHeight = originalBi.getHeight();
            widthAndHeight = new int[]{srcWidth, srcHeight};
        }
        catch (IOException e) {
            logger.error((Object)"\u83b7\u53d6\u56fe\u7247\u5b9e\u9645\u5c3a\u5bf8\u51fa\u9519", (Throwable)e);
        }
        return widthAndHeight;
    }
}

