/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.fileupload;

import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.config.PerformanceConfig;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.util.Strings;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;

public class FileuploadManagerImpl
extends CommonsMultipartResolver {
    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        try {
            User user = (User)request.getSession().getAttribute("com.seeyon.current_user");
            String ucFlag = request.getParameter("ucFlag");
            if (Constants.login_sign.ucpc.name().equals(user.getUserAgentFrom()) || "yes".equals(ucFlag)) {
                super.setMaxUploadSize(Long.parseLong(PerformanceConfig.getInstance().getConfig("zx.set.file.maxSize")) * 1024L * 1024L);
            } else {
                super.setMaxUploadSize(Long.parseLong(PerformanceConfig.getInstance().getConfig("fileUpload.maxSize")) * 1024L * 1024L);
            }
            return super.resolveMultipart(request);
        }
        catch (MaxUploadSizeExceededException e) {
            DefaultMultipartHttpServletRequest mr = new DefaultMultipartHttpServletRequest(request, (MultiValueMap)new LinkedMultiValueMap(), new HashMap(), new HashMap());
            mr.setAttribute("MaxUploadSizeExceeded", (Object)FileuploadManagerImpl.getMaxSizeStr());
            return mr;
        }
        catch (Exception e) {
            DefaultMultipartHttpServletRequest mr = new DefaultMultipartHttpServletRequest(request, (MultiValueMap)new LinkedMultiValueMap(), new HashMap(), new HashMap());
            mr.setAttribute("unknownException", (Object)e.getMessage());
            return mr;
        }
    }

    public void setMaxUploadSize(long maxUploadSize) {
        long m = maxUploadSize + 3072L;
        super.setMaxUploadSize(m);
    }

    public static String getMaxSizeStr() {
        String fileUpload_maxSize = PerformanceConfig.getInstance().getConfig("fileUpload.maxSize");
        if (fileUpload_maxSize != null && !"".equals(fileUpload_maxSize)) {
            long maxSize = Long.parseLong(fileUpload_maxSize) * 1024L * 1024L;
            return Strings.formatFileSize(maxSize, false);
        }
        return "";
    }
}

