/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.filemanager.manager;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.filemanager.NoSuchPartitionException;
import com.seeyon.ctp.common.filemanager.dao.PartitionDAO;
import com.seeyon.ctp.common.filemanager.manager.PartitionManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.Partition;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;

@ProcessInDataSource(name=DataSourceName.BASE)
public class PartitionManagerImpl
implements PartitionManager {
    private static Log log = CtpLogFactory.getLog(PartitionManagerImpl.class);
    private static final CacheAccessable cacheFactory = CacheFactory.getInstance(PartitionManagerImpl.class);
    private CacheMap<Long, Partition> allPartitions;
    private CacheMap<Long, String> allPartitionPaths;
    private PartitionDAO partitionDAO;

    public int getSortOrder() {
        return -990;
    }

    public void initialize() {
        this.init();
    }

    public void setPartitionDAO(PartitionDAO partitionDAO) {
        this.partitionDAO = partitionDAO;
    }

    public void initCache() {
        String cacheName = "AllPartitions";
        this.allPartitions = cacheFactory.isExist(cacheName) ? cacheFactory.getMap(cacheName) : cacheFactory.createLinkedMap(cacheName);
        cacheName = "AllPartitionPaths";
        this.allPartitionPaths = cacheFactory.isExist(cacheName) ? cacheFactory.getMap(cacheName) : cacheFactory.createMap(cacheName);
    }

    public void init() {
        long startTime = System.currentTimeMillis();
        this.initCache();
        List<Partition> partitations = this.partitionDAO.findAll();
        HashMap<Long, Partition> map = new HashMap<Long, Partition>();
        for (Partition p : partitations) {
            String path = p.getPath();
            path = PartitionManagerImpl.toCanonicalPath(path);
            if (p.getState().equals(Constants.PARTITION_STATE.used.ordinal()) && !new File(path).exists()) {
                log.error((Object)(path + " \u5206\u533a\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5206\u533a\u914d\u7f6e\u5e76\u786e\u5b9a\u5bf9\u5e94\u78c1\u76d8\u4f4d\u7f6e\u6709\u6548\uff01"));
            }
            this.allPartitionPaths.put(p.getId(), path);
            map.put(p.getId(), p);
        }
        this.allPartitions.replaceAll(map);
        this.putPartitionsToSysProps();
        log.info((Object)("\u52a0\u8f7d\u6240\u6709\u5206\u533a\u4fe1\u606f. \u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + " MS"));
    }

    private void putPartitionsToSysProps() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Partition partition : this.allPartitions.values()) {
            String startDate = Datetimes.formatDatetime(partition.getStartDate());
            String endDate = Datetimes.formatDatetime(partition.getEndDate());
            stringBuffer.append(";");
            stringBuffer.append(startDate);
            stringBuffer.append("_");
            stringBuffer.append(endDate);
            stringBuffer.append(",");
            stringBuffer.append(partition.getPath());
        }
        System.setProperty("all_partition_str", stringBuffer.substring(1));
    }

    @Override
    public List<Partition> getAllPartitions() {
        return new ArrayList<Partition>(this.allPartitions.values());
    }

    @Override
    public Partition getPartition(Long id) {
        return this.allPartitions.get(id);
    }

    @Override
    public Partition getPartition(Date createDate, boolean isOnlyEnable) {
        Date cd = PartitionManagerImpl.clearTime(createDate);
        for (Partition partition : this.allPartitions.values()) {
            Date startDate = partition.getStartDate();
            Date endDate = partition.getEndDate();
            if ((!startDate.before(cd) || !endDate.after(cd)) && !cd.equals(startDate) && !cd.equals(endDate)) continue;
            if (!isOnlyEnable) {
                return partition;
            }
            if (!partition.getState().equals(Constants.PARTITION_STATE.used.ordinal())) continue;
            return partition;
        }
        return null;
    }

    @Override
    public void create(Partition partition) {
        partition.setIdIfNew();
        this.partitionDAO.save(partition);
        this.init();
    }

    @Override
    public void delete(long id) {
        this.partitionDAO.delete(id);
        this.init();
    }

    @Override
    public void update(Partition partition) throws BusinessException {
        List<Partition> partitions = this.getPartition(partition.getStartDate(), partition.getEndDate(), true);
        if (partitions.size() > 1) {
            partitions.remove(partition);
            throw new BusinessException("\u65f6\u95f4\u6bb5\u4e0e" + partitions + "\u91cd\u53e0.");
        }
        if (partitions.size() == 1 && !partitions.get(0).equals(partition)) {
            throw new BusinessException("\u65f6\u95f4\u6bb5\u4e0e" + partitions + "\u91cd\u53e0.");
        }
        Partition originPartition = this.getPartition(partition.getId());
        String originPath = originPartition.getPath();
        String newPath = partition.getPath();
        this.partitionDAO.update(partition);
        this.init();
        this.moveFile(partition.getStartDate(), partition.getEndDate(), originPath, newPath);
    }

    @Override
    public void splitPartition(Long originPartitionId, String newPartitionName, String newPartitionPath, Date splitDate, String newPartitionDescription) throws BusinessException {
        Partition originPartition = this.getPartition(originPartitionId);
        if (originPartition == null) {
            throw new BusinessException("\u5206\u533aid\u4e3a[" + originPartitionId + "]\u7684\u5206\u533a\u4e0d\u5b58\u5728.");
        }
        GregorianCalendar splitCalendar = new GregorianCalendar();
        splitCalendar.setTime(splitDate);
        splitCalendar.set(11, 0);
        splitCalendar.set(12, 0);
        splitCalendar.set(13, 0);
        splitCalendar.set(14, 0);
        splitCalendar.add(6, -1);
        Date sd = splitCalendar.getTime();
        Date endDate = originPartition.getEndDate();
        if (!Datetimes.between(sd, originPartition.getStartDate(), endDate, true)) {
            throw new BusinessException("\u62c6\u5206\u65f6\u95f4\u70b9" + DateFormatUtils.ISO_DATE_FORMAT.format(sd) + "\u4e0d\u5728\u539f\u5206\u533a\u7684\u8d77\u6b62\u65f6\u95f4\u4e4b\u5185\u3002");
        }
        originPartition.setEndDate(sd);
        this.partitionDAO.update(originPartition);
        this.allPartitions.notifyUpdate(originPartition.getId());
        splitCalendar.add(6, 1);
        Partition newPartition = new Partition();
        newPartition.setIdIfNew();
        newPartition.setName(newPartitionName);
        newPartition.setPath(newPartitionPath);
        newPartition.setCreateTime(new Date());
        newPartition.setStartDate(splitCalendar.getTime());
        newPartition.setEndDate(endDate);
        newPartition.setState(Constants.PARTITION_STATE.used.ordinal());
        newPartition.setDescription(newPartitionDescription);
        this.create(newPartition);
        Date today = Datetimes.getTodayFirstTime();
        if (!sd.after(today)) {
            this.moveFile(newPartition.getStartDate(), today, originPartition.getPath(), newPartitionPath);
        }
    }

    @Override
    public List<Partition> getPartition(Date startDate, Date endDate, boolean isOnlyEnable) {
        Date sd = PartitionManagerImpl.clearTime(startDate);
        Date ed = PartitionManagerImpl.clearTime(endDate);
        ArrayList<Partition> result = new ArrayList<Partition>();
        for (Partition partition : this.allPartitions.values()) {
            if (!Datetimes.checkOverup(sd, ed, partition.getStartDate(), partition.getEndDate(), false)) continue;
            if (!isOnlyEnable) {
                result.add(partition);
                continue;
            }
            if (!partition.getState().equals(Constants.PARTITION_STATE.used.ordinal())) continue;
            result.add(partition);
        }
        return result;
    }

    private static Date clearTime(Date date) {
        GregorianCalendar startCalendar = new GregorianCalendar();
        startCalendar.setTime(date == null ? new Date() : date);
        startCalendar.set(11, 0);
        startCalendar.set(12, 0);
        startCalendar.set(13, 0);
        startCalendar.set(14, 0);
        return startCalendar.getTime();
    }

    @Override
    public String getFolder(Date createDate, boolean createWhenNoExist) throws BusinessException {
        File file;
        String partitionPath = this.getPartitionPath(createDate, true);
        if (partitionPath == null) {
            throw new NoSuchPartitionException(createDate);
        }
        if (createDate == null) {
            log.error((Object)"create date is null");
            return null;
        }
        if (File.separator.equals(partitionPath.substring(partitionPath.length() - 1))) {
            partitionPath = partitionPath.substring(0, partitionPath.length() - 1);
        }
        String folder = DateFormatUtils.format((Date)createDate, (String)Constants.DATE_TO_FOLDER_STYLE);
        folder = partitionPath + File.separator + folder;
        if (createWhenNoExist && !(file = new File(folder)).exists()) {
            file.mkdirs();
        }
        return folder;
    }

    private static String toCanonicalPath(String path) {
        String p = path;
        p = SystemProperties.interpolateHelper(p, SystemProperties.getInstance().getAllProperties());
        p = Strings.getCanonicalPath(p);
        return p;
    }

    @Override
    public boolean validatePath(String path) {
        String p = path;
        if (Strings.isBlank(p)) {
            return false;
        }
        File file = new File(p = PartitionManagerImpl.toCanonicalPath(p));
        return file.isDirectory() && file.exists();
    }

    @Override
    public String getPartitionPath(Date createDate, boolean isOnlyEnable) {
        Partition partition = this.getPartition(createDate, isOnlyEnable);
        if (partition != null) {
            return this.allPartitionPaths.get(partition.getId());
        }
        return null;
    }

    private void moveFile(Date from, Date to, String originPath, String newPath) {
    }

    @Override
    public boolean isPartitionNameDuple(String name) {
        if (this.allPartitions != null) {
            for (Partition element : this.allPartitions.values()) {
                if (!element.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getFolderForUC(Date createDate, boolean createWhenNoExist) throws BusinessException {
        File file;
        String partitionPath = this.getPartitionPath(createDate, true);
        if (partitionPath == null) {
            throw new NoSuchPartitionException(createDate);
        }
        if (createDate == null) {
            log.error((Object)"create date is null");
            return null;
        }
        if (File.separator.equals(partitionPath.substring(partitionPath.length() - 1))) {
            partitionPath = partitionPath.substring(0, partitionPath.length() - 1);
        }
        String folder = DateFormatUtils.format((Date)createDate, (String)Constants.DATE_TO_FOLDER_STYLE);
        folder = partitionPath + File.separator + "zx" + File.separator + folder;
        if (createWhenNoExist && !(file = new File(folder)).exists()) {
            file.mkdirs();
        }
        return folder;
    }
}

