/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.filemanager.manager;

import com.seeyon.ctp.common.filemanager.event.FileItem;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.springframework.web.multipart.MultipartFile;

class FileItemImpl
implements FileItem {
    private static final Log log = CtpLogFactory.getLog(FileItemImpl.class);
    private final MultipartFile fileItem;
    private InputStream in = null;
    private List<String> messages = new ArrayList<String>();

    public FileItemImpl(MultipartFile fileItem) {
        this.fileItem = fileItem;
    }

    @Override
    public String getName() {
        return this.fileItem.getName();
    }

    @Override
    public String getOriginalFilename() {
        return this.fileItem.getOriginalFilename();
    }

    @Override
    public String getContentType() {
        return this.fileItem.getContentType();
    }

    @Override
    public long getSize() {
        return this.fileItem.getSize();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    @Override
    public void appendMessage(String message) {
        this.messages.add(message);
    }

    @Override
    public void setInputStream(InputStream stream) throws IOException {
        this.in = stream;
    }

    @Override
    public Collection<String> getMessages() {
        return this.messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAs(File file) throws IOException, IllegalStateException {
        if (this.in == null) {
            this.fileItem.transferTo(file);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                IOUtils.copy((InputStream)this.in, (OutputStream)fileOutputStream);
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                fileOutputStream.close();
            }
        }
    }
}

