/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.datai18n.manager.impl;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.datai18n.DataI18nInitializer;
import com.seeyon.ctp.common.datai18n.dao.DataI18nDao;
import com.seeyon.ctp.common.datai18n.manager.DataI18nManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.i18n.expand.ResourceConsts;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.dataI18n.DataI18n;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;

@ProcessInDataSource(name=DataSourceName.BASE)
public class DataI18nManagerImpl
extends AbstractSystemInitializer
implements DataI18nManager {
    private AppLogManager appLogManager;
    private static Log logger = CtpLogFactory.getLog(DataI18nManagerImpl.class);
    private DataI18nDao dataI18nDao;
    private static int i18nMaXLength = 500;
    private static int maxCacheSize = 50000;
    private CacheMap<Long, ArrayList<DataI18n>> cache;

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    @Override
    public int getSortOrder() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CacheMap<Long, ArrayList<DataI18n>> getCache() {
        if (this.cache != null) return this.cache;
        Class<DataI18nManagerImpl> clazz = DataI18nManagerImpl.class;
        synchronized (DataI18nManagerImpl.class) {
            if (this.cache != null) return this.cache;
            CacheAccessable factory = CacheFactory.getInstance(DataI18nManagerImpl.class);
            this.cache = factory.createLRUMap("DataI18nCache");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cache;
        }
    }

    @Override
    public void initialize() {
        this.initDataI18n();
    }

    private void initDataI18n() {
        logger.info((Object)"Start load data i18n ......");
        Date startTime = new Date();
        int currentPage = 1;
        int pageSize = 500;
        int pages = 0;
        int totalNum = 0;
        int loadMaxPage = 20;
        do {
            try {
                logger.info((Object)("Load data i18n, currentPage\uff1a" + currentPage));
                FlipInfo fi = new FlipInfo(currentPage, pageSize);
                fi.setNeedTotal(true);
                logger.info((Object)("Load data i18n, query\uff1a" + Datetimes.format(new Date(), "yyyy-MM-dd HH:mm:ss")));
                List<DataI18n> pageData = this.dataI18nDao.getDataI18n(fi);
                logger.info((Object)("Load data i18n, put cache start\uff1a" + Datetimes.format(new Date(), "yyyy-MM-dd HH:mm:ss") + ". data number\uff1a" + pageData.size()));
                this.putPageData2Cache(pageData);
                logger.info((Object)("Load data i18n, put cache end\uff1a" + Datetimes.format(new Date(), "yyyy-MM-dd HH:mm:ss") + ". data number\uff1a" + pageData.size()));
                if (currentPage != 1) continue;
                pages = fi.getPages();
                totalNum = fi.getTotal();
            }
            catch (Exception e) {
                logger.error((Object)("Load data i18n exception, currentPage\uff1a" + currentPage), (Throwable)e);
            }
        } while (++currentPage <= pages && currentPage <= loadMaxPage);
        Date endTime = new Date();
        logger.info((Object)("Load data i18n end, Load total pages\uff1a" + (currentPage - 1) + ", Load total number\uff1a" + totalNum + "\uff0cTotal time-consuming\uff1a" + (endTime.getTime() - startTime.getTime()) + " MS"));
    }

    private void putPageData2Cache(List<DataI18n> pageData) {
        if (Strings.isEmpty(pageData)) {
            return;
        }
        for (DataI18n dataI18n : pageData) {
            ArrayList<DataI18n> cacheList = this.getCache().get(dataI18n.getId());
            if (null == cacheList) {
                cacheList = new ArrayList<DataI18n>();
            }
            cacheList.add(dataI18n);
            this.getCache().put(dataI18n.getId(), cacheList);
        }
    }

    private List<DataI18n> getFromCache(Long id) {
        if (id > -999999999L && id < 999999999L) {
            return Collections.emptyList();
        }
        List<DataI18n> result = (List<DataI18n>)this.getCache().get(id);
        if (result == null && Strings.isNotEmpty(result = this.getDataI18nDao().getAllDataI18nList(id))) {
            this.getCache().put(id, (ArrayList)result);
        }
        return new ArrayList<DataI18n>(result);
    }

    private void removeFromCache(Long id) {
        this.getCache().remove(id);
    }

    private void removeAllFromCache(Collection ids) {
        this.getCache().removeAll(ids);
    }

    @Override
    public DataI18n getDataI18n(Long id, Locale locale) throws BusinessException {
        List<DataI18n> data = this.getFromCache(id);
        if (data != null) {
            String lang = I18nUtil.getLocalAsString(locale);
            for (DataI18n dataI18n : data) {
                if (!lang.equals(dataI18n.getLanguage())) continue;
                return dataI18n;
            }
        }
        return null;
    }

    @Override
    public DataI18n getDataI18nWithCompensate(Long id, Locale locale) throws BusinessException {
        List<DataI18n> dataI18ns = this.getAllDataI18nList(id);
        if (Strings.isNotEmpty(dataI18ns)) {
            if (locale == null) {
                locale = LocaleContext.getSysSetDefaultLocale();
            }
            String currentLocaleName = I18nUtil.getLocalAsString(locale);
            for (DataI18n dataI18n : dataI18ns) {
                if (!currentLocaleName.equals(dataI18n.getLanguage()) || !Strings.isNotBlank(dataI18n.getI18nValue())) continue;
                return dataI18n;
            }
            locale = LocaleContext.getSysSetDefaultLocale();
            String sysLocaleName = I18nUtil.getLocalAsString(locale);
            if (!sysLocaleName.equals(currentLocaleName)) {
                for (DataI18n data : dataI18ns) {
                    if (!sysLocaleName.equals(data.getLanguage()) || !Strings.isNotBlank(data.getI18nValue())) continue;
                    return data;
                }
            }
            List<Locale> list = LocaleContext.getAllLocales();
            for (Locale l : list) {
                String localeName = I18nUtil.getLocalAsString(l);
                if (currentLocaleName.equals(localeName) || sysLocaleName.equals(localeName)) continue;
                for (DataI18n data : dataI18ns) {
                    if (!localeName.equals(data.getLanguage()) || !Strings.isNotBlank(data.getI18nValue())) continue;
                    return data;
                }
            }
        }
        return null;
    }

    @Override
    public String getDataI18nValueWithCompensate(Long id, Locale locale) {
        if (id == null) {
            return "";
        }
        String i18n = null;
        try {
            DataI18n dataI18n = this.getDataI18nWithCompensate(id, locale);
            i18n = dataI18n != null ? dataI18n.getI18nValue() : id.toString();
        }
        catch (BusinessException e) {
            logger.error((Object)("No i18n data:" + id));
        }
        catch (Exception e) {
            logger.error((Object)"No i18n data:", (Throwable)e);
        }
        return i18n;
    }

    @Override
    public DataI18n getDataI18nCurrentLocal(Long id) throws BusinessException {
        return this.getDataI18n(id, AppContext.getLocale());
    }

    @Override
    public Map<String, Object> getDataI18nInfo(String i18nValue) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("dataI18nSwitch", SystemEnvironment.functionSwitch("dataI18n"));
        result.put("internationalized", false);
        if (!Strings.isLong(i18nValue)) {
            result.put("showText", ResourceUtil.getString(i18nValue));
            return result;
        }
        Long id = Long.parseLong(i18nValue);
        Map<String, String> i18nMap = this.getAllDataI18nValueMap(id);
        if (MapUtils.isEmpty(i18nMap)) {
            result.put("showText", i18nValue);
        } else {
            result.put("internationalized", true);
            String currentLanguage = I18nUtil.getLocalAsString(AppContext.getLocale());
            result.put("currentLanguage", currentLanguage);
            result.put("showText", ResourceUtil.getString(id));
            result.put("allLanguageValue", i18nMap);
        }
        return result;
    }

    @Override
    public List<DataI18n> getAllDataI18nList(Long id) throws BusinessException {
        return this.getFromCache(id);
    }

    @Override
    public List<String> getAllDataI18nValues(String id) {
        ArrayList<String> ret = null;
        boolean returnDefault = true;
        if (Strings.isLong(id)) {
            List<DataI18n> datas;
            try {
                datas = this.getAllDataI18nList(Long.valueOf(id));
            }
            catch (BusinessException e) {
                throw new RuntimeException("\u83b7\u53d6\u5b57\u6bb5\u56fd\u9645\u8bdd\u6570\u636e\u5f02\u5e38", e);
            }
            if (Strings.isNotEmpty(datas)) {
                returnDefault = false;
                ret = new ArrayList(datas.size());
                for (DataI18n data : datas) {
                    if (!Strings.isNotBlank(data.getI18nValue())) continue;
                    ret.add(data.getI18nValue());
                }
            }
        }
        if (returnDefault) {
            ret = new ArrayList<String>(1);
            ret.add(id);
        }
        return ret;
    }

    @Override
    public Map<String, DataI18n> getAllDataI18nMap(Long id) throws BusinessException {
        Map<String, DataI18n> resultMap;
        List<DataI18n> result = this.getAllDataI18nList(id);
        if (CollectionUtils.isNotEmpty(result)) {
            resultMap = new HashMap<String, DataI18n>(result.size());
            for (DataI18n dataI18n : result) {
                resultMap.put(dataI18n.getLanguage(), dataI18n);
            }
        } else {
            resultMap = Collections.emptyMap();
        }
        return resultMap;
    }

    @Override
    public Map<String, String> getAllDataI18nValueMap(Long id) throws BusinessException {
        Map<String, String> resultMap;
        List<DataI18n> result = this.getAllDataI18nList(id);
        if (CollectionUtils.isNotEmpty(result)) {
            HashMap<String, String> dataI18nMap = new HashMap<String, String>(result.size());
            for (DataI18n dataI18n : result) {
                dataI18nMap.put(dataI18n.getLanguage(), dataI18n.getI18nValue());
            }
            List<Locale> allLocales = LocaleContext.getAllLocales();
            resultMap = new LinkedHashMap<String, String>(result.size());
            for (int i = 0; i < allLocales.size(); ++i) {
                String locale = I18nUtil.getLocalAsString(allLocales.get(i));
                if (!dataI18nMap.containsKey(locale)) continue;
                resultMap.put(locale, (String)dataI18nMap.get(locale));
            }
        } else {
            resultMap = Collections.emptyMap();
        }
        return resultMap;
    }

    @Override
    public void save(DataI18n dataI18n) throws BusinessException {
        Date d = new Date();
        dataI18n.setCreateDate(d);
        dataI18n.setUpdateDate(d);
        DataI18nInitializer.removeOrphanByValue(dataI18n.getCategory(), dataI18n.getLanguage(), dataI18n.getI18nValue());
        this.getDataI18nDao().save(dataI18n);
        this.removeFromCache(dataI18n.getId());
    }

    @Override
    public void saveAll(List<DataI18n> dataI18nList) throws BusinessException {
        if (CollectionUtils.isNotEmpty(dataI18nList)) {
            Date d = new Date();
            StringBuilder newi18n = new StringBuilder(20);
            String category = "";
            HashSet<Long> ids = new HashSet<Long>();
            for (int i = 0; i < dataI18nList.size(); ++i) {
                DataI18n dataI18n = dataI18nList.get(i);
                if (null == dataI18n) continue;
                dataI18n.setCreateDate(d);
                dataI18n.setUpdateDate(d);
                newi18n.append(dataI18n.getLanguage()).append(":").append(dataI18n.getI18nValue()).append(",");
                if ("".equals(category)) {
                    category = dataI18n.getCategory();
                }
                ids.add(dataI18n.getId());
                DataI18nInitializer.removeOrphanByValue(dataI18n.getCategory(), dataI18n.getLanguage(), dataI18n.getI18nValue());
            }
            this.getDataI18nDao().saveAll(dataI18nList);
            this.removeAllFromCache(ids);
            User user = AppContext.getCurrentUser();
            this.appLogManager.insertLog(user, AppLogAction.DataI18n_new, user.getName(), category, newi18n.substring(0, newi18n.length() - 1));
        }
    }

    @Override
    public void update(DataI18n dataI18n) throws BusinessException {
        dataI18n.setUpdateDate(new Date());
        DataI18nInitializer.removeOrphanByValue(dataI18n.getCategory(), dataI18n.getLanguage(), dataI18n.getI18nValue());
        this.getDataI18nDao().update(dataI18n);
        this.removeFromCache(dataI18n.getId());
    }

    @Override
    public void updateAll(List<DataI18n> dataI18nList) throws BusinessException {
        HashSet<Long> ids = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(dataI18nList)) {
            Date d = new Date();
            for (DataI18n dataI18n : dataI18nList) {
                if (null == dataI18n) continue;
                dataI18n.setUpdateDate(d);
                ids.add(dataI18n.getId());
                DataI18nInitializer.removeOrphanByValue(dataI18n.getCategory(), dataI18n.getLanguage(), dataI18n.getI18nValue());
            }
            this.getDataI18nDao().updateAll(dataI18nList);
            this.removeAllFromCache(ids);
        }
    }

    @Override
    public void delete(Long id) throws BusinessException {
        List<DataI18n> dataI18ns = this.getAllDataI18nList(id);
        this.getDataI18nDao().delete(id);
        this.removeFromCache(id);
        if (CollectionUtils.isNotEmpty(dataI18ns)) {
            StringBuilder i18nLog = new StringBuilder(10);
            String category = "";
            for (DataI18n i18n : dataI18ns) {
                if ("".equals(category)) {
                    category = i18n.getCategory();
                }
                i18nLog.append(i18n.getLanguage()).append(":").append(i18n.getI18nValue()).append(",");
            }
            User user = AppContext.getCurrentUser();
            this.appLogManager.insertLog(user, AppLogAction.DataI18n_delete, user.getName(), category, i18nLog.substring(0, i18nLog.length() - 1));
        }
    }

    @Override
    public void delete(String id) throws BusinessException {
        if (Strings.isBlank(id) || !Strings.isLong(id)) {
            return;
        }
        this.delete(Long.parseLong(id));
    }

    @Override
    public void delete(Collection<Long> ids) throws BusinessException {
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : ids) {
                this.delete(id);
            }
        }
    }

    @Override
    public void deleteByIds(Collection<String> ids) throws BusinessException {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>(ids.size());
        for (String id : ids) {
            if (!Strings.isLong(id)) continue;
            idSet.add(Long.parseLong(id));
        }
        this.delete(idSet);
    }

    @Override
    public Map<String, String> getAllLocales() throws BusinessException {
        List<Locale> allLocales = LocaleContext.getAllLocales();
        HashMap<String, String> locales = new HashMap<String, String>(allLocales.size());
        for (Locale l : allLocales) {
            String strLocale = I18nUtil.getLocalAsString(l);
            locales.put(strLocale, ResourceConsts.getLanguageName(strLocale));
        }
        return locales;
    }

    @Override
    @AjaxAccess
    public FlipInfo getEditList(FlipInfo fi, Map params) throws BusinessException {
        String data;
        ArrayList rellist = new ArrayList();
        List<Locale> allLocales = LocaleContext.getAllLocales();
        User user = AppContext.getCurrentUser();
        String userLocal = I18nUtil.getLocalAsString(user.getLocale());
        if (params.get("params") != null && Strings.isNotBlank(data = params.get("params").toString())) {
            Map map = (Map)JSONUtil.parseJSONString(data);
            List list = (List)JSONUtil.parseJSONString(map.get("jsonData").toString());
            for (Map item : list) {
                int i;
                String key = "";
                HashMap<String, Object> m = new HashMap<String, Object>();
                if (item.get("text") == null || Strings.isBlank(item.get("text").toString())) continue;
                if (item.get("key") != null && Strings.isNotBlank(item.get("key").toString()) && Strings.isLong(item.get("key").toString())) {
                    key = item.get("key").toString();
                    for (i = 0; i < allLocales.size(); ++i) {
                        DataI18n dataI18n = this.getDataI18n(Long.valueOf(key), allLocales.get(i));
                        if (dataI18n != null) {
                            m.put(I18nUtil.getLocalAsString(allLocales.get(i)), dataI18n.getI18nValue());
                            continue;
                        }
                        m.put(I18nUtil.getLocalAsString(allLocales.get(i)), "");
                    }
                } else {
                    key = String.valueOf(UUIDLong.negativeLongUUID());
                    for (i = 0; i < allLocales.size(); ++i) {
                        String local = I18nUtil.getLocalAsString(allLocales.get(i));
                        if (userLocal.equals(local)) {
                            m.put(local, item.get("text"));
                            continue;
                        }
                        m.put(local, "");
                    }
                }
                m.put("text", item.get("text"));
                int maxLength = i18nMaXLength;
                if (item.get("maxLength") != null) {
                    maxLength = Integer.valueOf(item.get("maxLength").toString());
                }
                if (item.get("title") == null || Strings.isBlank(item.get("title").toString())) {
                    m.put("title", item.get("text"));
                } else {
                    m.put("title", item.get("title"));
                }
                m.put("id", key);
                m.put("name", item.get("name"));
                m.put("category", item.get("category"));
                m.put("maxLength", maxLength);
                rellist.add(m);
            }
        }
        fi.setData(rellist);
        return fi;
    }

    @Override
    @AjaxAccess
    public String batchSave(String content) throws BusinessException {
        ArrayList result = new ArrayList();
        if (Strings.isNotBlank(content)) {
            List<Locale> allLocales = LocaleContext.getAllLocales();
            ArrayList<DataI18n> saveResourse = new ArrayList<DataI18n>();
            ArrayList<DataI18n> updateResourse = new ArrayList<DataI18n>();
            Locale locale = AppContext.getLocale();
            String currentLanauage = I18nUtil.getLocalAsString(locale);
            List list = (List)JSONUtil.parseJSONString(content);
            StringBuilder oldi18n = new StringBuilder(10);
            StringBuilder newi18n = new StringBuilder(10);
            String category = "";
            for (Map item : list) {
                Long id = Long.valueOf(item.get("id").toString());
                String name = item.get("name").toString();
                category = item.get("category").toString();
                String text = item.get("text").toString();
                for (Locale local : allLocales) {
                    DataI18n dataI18n;
                    String lanauage = I18nUtil.getLocalAsString(local);
                    String value = item.get(lanauage).toString();
                    if (value.length() > i18nMaXLength) {
                        value = value.substring(0, i18nMaXLength);
                    }
                    if ((dataI18n = this.getDataI18n(id, local)) != null) {
                        oldi18n.append(dataI18n.getLanguage()).append(":").append(dataI18n.getI18nValue()).append(",");
                        newi18n.append(dataI18n.getLanguage()).append(":").append(value).append(",");
                        dataI18n.setUpdateDate(new Date());
                        dataI18n.setI18nValue(value);
                        updateResourse.add(dataI18n);
                    } else {
                        dataI18n = new DataI18n();
                        dataI18n.setId(id);
                        dataI18n.setCategory(category);
                        dataI18n.setLanguage(lanauage);
                        dataI18n.setI18nValue(value);
                        dataI18n.setCreateDate(new Date());
                        saveResourse.add(dataI18n);
                    }
                    if (!currentLanauage.equals(lanauage)) continue;
                    text = value;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", name);
                map.put("text", text);
                map.put("key", id.toString());
                result.add(map);
            }
            this.saveAll(saveResourse);
            this.updateAll(updateResourse);
            if (CollectionUtils.isNotEmpty(updateResourse)) {
                this.insertUpdateAppLog(category, oldi18n, newi18n);
            }
        }
        return JSONUtil.toJSONString(result);
    }

    @Override
    public Map<String, Object> saveSingleI18n(String content) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        Map submitMap = this.checkSubmitInfo(content);
        Long id = Long.parseLong(submitMap.get("id").toString());
        String category = submitMap.get("category").toString();
        String[] locales = DataI18nManagerImpl.getLocals();
        List<Locale> allLocales = LocaleContext.getAllLocales();
        ArrayList<DataI18n> addList = new ArrayList<DataI18n>(locales.length);
        ArrayList<DataI18n> updateList = new ArrayList<DataI18n>(locales.length);
        HashMap<String, String> allLanguageValue = new HashMap<String, String>(allLocales.size());
        StringBuilder oldi18n = new StringBuilder(10);
        StringBuilder newi18n = new StringBuilder(10);
        for (Locale local : allLocales) {
            String language = I18nUtil.getLocalAsString(local);
            Object i18nObj = submitMap.get(language);
            String i18nStr = i18nObj == null ? null : i18nObj.toString();
            DataI18n dataI18n = this.getDataI18n(id, local);
            if (null == dataI18n) {
                if (Strings.isBlank(i18nStr)) continue;
                dataI18n = new DataI18n();
                dataI18n.setId(id);
                dataI18n.setLanguage(language);
                dataI18n.setCategory(category);
                dataI18n.setI18nValue(i18nStr);
                addList.add(dataI18n);
            } else {
                oldi18n.append(dataI18n.getLanguage()).append(":").append(dataI18n.getI18nValue()).append(",");
                newi18n.append(dataI18n.getLanguage()).append(":").append(i18nStr).append(",");
                dataI18n.setI18nValue(i18nStr);
                updateList.add(dataI18n);
            }
            allLanguageValue.put(language, i18nStr);
        }
        this.saveAll(addList);
        this.updateAll(updateList);
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.insertUpdateAppLog(category, oldi18n, newi18n);
        }
        String currentLanguage = I18nUtil.getLocalAsString(AppContext.getLocale());
        resultMap.put("currentLanguage", currentLanguage);
        resultMap.put("allLanguageValue", allLanguageValue);
        return resultMap;
    }

    private void insertUpdateAppLog(String category, StringBuilder oldi18n, StringBuilder newi18n) {
        User user = AppContext.getCurrentUser();
        this.appLogManager.insertLog(user, AppLogAction.DataI18n_edit, user.getName(), category, oldi18n.substring(0, oldi18n.length() - 1), newi18n.substring(0, newi18n.length() - 1));
    }

    @Override
    public Map<String, Object> updateSingleLanguage(Map<String, Object> content) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        Long id = MapUtils.getLong(content, (Object)"id", null);
        if (id == null) {
            return resultMap;
        }
        String language = MapUtils.getString(content, (Object)"language");
        String languageValue = MapUtils.getString(content, (Object)"languageValue");
        if (language == null || languageValue == null) {
            return resultMap;
        }
        DataI18n dataI18n = this.getDataI18n(id, I18nUtil.parseLocale(language));
        String oldi18n = "";
        String newI18n = "";
        if (null == dataI18n) {
            return resultMap;
        }
        oldi18n = oldi18n + dataI18n.getLanguage() + ":" + dataI18n.getI18nValue();
        newI18n = newI18n + dataI18n.getLanguage() + ":" + languageValue;
        dataI18n.setI18nValue(languageValue);
        this.update(dataI18n);
        User user = AppContext.getCurrentUser();
        this.appLogManager.insertLog(user, AppLogAction.DataI18n_edit, user.getName(), oldi18n, newI18n);
        return resultMap;
    }

    private Map checkSubmitInfo(String content) throws BusinessException {
        Map submitMap = JSONUtil.parseJSONString(content, Map.class);
        Object idObj = submitMap.get("id");
        Object categoryObj = submitMap.get("category");
        if (null == submitMap || null == idObj || null == categoryObj) {
            logger.info((Object)("dataI18n\uff1a" + content));
            throw new BusinessException(ResourceUtil.getString("data.i18n.error.param"));
        }
        return submitMap;
    }

    @Override
    public Map<String, Object> copyById(String id) throws BusinessException {
        if (!Strings.isLong(id)) {
            return null;
        }
        if (id == null) {
            return Collections.emptyMap();
        }
        List<DataI18n> origList = this.getAllDataI18nList(Long.valueOf(id));
        if (Strings.isEmpty(origList)) {
            return Collections.emptyMap();
        }
        Long newId = UUIDLong.longUUID();
        ArrayList<DataI18n> addList = new ArrayList<DataI18n>(origList.size());
        for (DataI18n dataI18n : origList) {
            DataI18n temp = new DataI18n();
            temp.setId(newId);
            temp.setLanguage(dataI18n.getLanguage());
            temp.setCategory(dataI18n.getCategory());
            temp.setI18nValue(dataI18n.getI18nValue());
            temp.setCategory(dataI18n.getCategory());
            addList.add(temp);
        }
        this.saveAll(addList);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("newId", newId);
        resultMap.put("newI18nList", addList);
        return resultMap;
    }

    @Override
    public String copyAndSaveById(String id) {
        if (!Strings.isLong(id)) {
            return id;
        }
        try {
            Map<String, Object> ret = this.copyById(id);
            if (ret != null) {
                return ret.get("newId").toString();
            }
        }
        catch (BusinessException e) {
            logger.error((Object)"\u62f7\u8d1d\u56fd\u9645\u5316\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
        return id;
    }

    @Override
    public Map<String, StringBuilder> getAlli18nValueCategory(Long id, String category) throws BusinessException {
        List<DataI18n> i18nData = this.dataI18nDao.getAlli18nValueCategory(category);
        LinkedHashMap<String, StringBuilder> i18nMap = new LinkedHashMap<String, StringBuilder>();
        for (DataI18n dataI18n : i18nData) {
            if (dataI18n.getId().longValue() == id.longValue()) continue;
            StringBuilder sb = (StringBuilder)i18nMap.get(dataI18n.getLanguage());
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(dataI18n.getI18nValue());
            sb.append(",");
            i18nMap.put(dataI18n.getLanguage(), sb);
        }
        return i18nMap;
    }

    private static String[] getLocals() {
        List<Locale> allLocales = LocaleContext.getAllLocales();
        int localSize = allLocales.size();
        String[] locales = new String[localSize];
        for (int i = 0; i < allLocales.size(); ++i) {
            locales[i] = I18nUtil.getLocalAsString(allLocales.get(i));
        }
        return locales;
    }

    public DataI18nDao getDataI18nDao() {
        return this.dataI18nDao;
    }

    public void setDataI18nDao(DataI18nDao dataI18nDao) {
        this.dataI18nDao = dataI18nDao;
    }
}

