/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.datai18n;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.datai18n.CategoryDefinition;
import java.util.HashMap;
import java.util.Map;

public class DataI18nInitializer
extends AbstractSystemInitializer {
    private static final Map<String, CategoryDefinition> categoryDefinitions = new HashMap<String, CategoryDefinition>();

    @Override
    public void initialize() {
        Map<String, CategoryDefinition> beans = AppContext.getBeansOfType(CategoryDefinition.class);
        for (CategoryDefinition definition : beans.values()) {
            String category = definition.getCategory();
            if (categoryDefinitions.containsKey(category)) {
                throw new UnsupportedOperationException("category is existed:" + category + categoryDefinitions.get(category).getClass().getCanonicalName() + " " + definition.getClass().getCanonicalName());
            }
            categoryDefinitions.put(category, definition);
        }
    }

    public static void removeOrphanByValue(String category, String language, String value) {
        CategoryDefinition definition = categoryDefinitions.get(category);
        if (definition != null) {
            definition.removeOrphanByValue(language, value);
        }
    }
}

