/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.dao;

import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.dao.CTPBaseDao;
import com.seeyon.ctp.common.dao.paginate.Pagination;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.GenericsUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.DetachedCriteriaConversion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.hibernate3.CTPHibernateTemplate;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateSystemException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;

public abstract class BaseDao<T>
extends DaoSupport
implements CTPBaseDao<T> {
    private static final Log log = CtpLogFactory.getLog(BaseDao.class);
    private HibernateTemplate hibernateTemplate;
    protected Class<T> entityClass = GenericsUtils.getGenericClass(this.getClass());
    private static int batch_size = 1000;

    @Override
    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.hibernateTemplate = this.createHibernateTemplate(sessionFactory);
    }

    protected HibernateTemplate createHibernateTemplate(SessionFactory sessionFactory) {
        return new CTPHibernateTemplate(sessionFactory);
    }

    @Override
    public final SessionFactory getSessionFactory() {
        return this.hibernateTemplate != null ? this.hibernateTemplate.getSessionFactory() : null;
    }

    @Override
    public final void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    @Override
    public final HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    protected final void checkDaoConfig() {
        if (this.hibernateTemplate == null) {
            throw new IllegalArgumentException("sessionFactory or hibernateTemplate is required");
        }
    }

    protected final DataAccessException convertHibernateAccessException(HibernateException ex) {
        return this.hibernateTemplate.convertHibernateAccessException(ex);
    }

    protected Class getEntityClass() {
        return this.entityClass;
    }

    protected int getBatchSize() {
        if (batch_size < 0) {
            try {
                batch_size = Integer.parseInt(SystemProperties.getInstance().getProperty("db.jdbc.batch_size"));
            }
            catch (Exception e) {
                batch_size = 1000;
            }
        }
        return batch_size;
    }

    @Override
    public void save(Object o) {
        this.getHibernateTemplate().save(o);
    }

    @Override
    public void savePatchAll(final Collection<? extends Object> os) {
        if (os == null || os.isEmpty()) {
            return;
        }
        this.getBatchSize();
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                int i = 0;
                try {
                    for (Object object : os) {
                        session.save(object);
                        if (++i % batch_size != 0 && i != os.size()) continue;
                        session.flush();
                        session.clear();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"\u6279\u91cf\u63d2\u5165\u5f02\u5e38", (Throwable)e);
                }
                return null;
            }
        });
    }

    @Override
    public void updatePatchAll(final Collection<? extends Object> os) {
        if (os == null || os.isEmpty()) {
            return;
        }
        this.getBatchSize();
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                int i = 0;
                try {
                    for (Object object : os) {
                        if (object != null) {
                            session.merge(object);
                        }
                        if (++i % batch_size != 0 && i != os.size()) continue;
                        session.flush();
                        session.clear();
                    }
                }
                catch (Exception e) {
                    BaseDao.this.logger.error((Object)"\u6279\u91cf\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
                }
                return null;
            }
        });
    }

    @Override
    public void update(Object o) {
        try {
            this.getHibernateTemplate().update(o);
        }
        catch (HibernateSystemException e) {
            this.getHibernateTemplate().merge(o);
        }
    }

    @Override
    public T get(Long id) {
        return (T)this.getHibernateTemplate().get(this.getEntityClass(), (Serializable)id);
    }

    @Override
    public List<T> getAll() {
        return this.getHibernateTemplate().loadAll(this.getEntityClass());
    }

    @Override
    public List findVarargs(String hsql, Object ... values) {
        if (values == null || values.length == 0) {
            return this.getHibernateTemplate().find(hsql);
        }
        return this.getHibernateTemplate().find(hsql, values);
    }

    @Override
    public T findUniqueBy(String name, Object value) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)name, (Object)value));
        List list = this.getHibernateTemplate().findByCriteria(criteria, 0, 1);
        return list == null || list.isEmpty() ? null : (T)list.get(0);
    }

    @Override
    public List<T> findBy(String name, Object value) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)name, (Object)value));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<T> findByLike(String name, String value) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getEntityClass());
        criteria.add((Criterion)Restrictions.like((String)name, (String)value, (MatchMode)MatchMode.ANYWHERE));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    protected void sortCriteria(Criteria criteria, Map sortMap, Object entity) {
        if (!sortMap.isEmpty()) {
            for (Object o : sortMap.keySet()) {
                String fieldName = o.toString();
                String orderType = sortMap.get(fieldName).toString();
                if (fieldName.indexOf(46) != -1) {
                    String alias;
                    String aliasType = alias = StringUtils.substringBefore((String)fieldName, (String)".");
                    try {
                        aliasType = PropertyUtils.getProperty((Object)entity, (String)alias).getClass().getSimpleName();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Get property" + alias + " error"));
                    }
                    criteria.createAlias(aliasType, alias);
                }
                if ("asc".equalsIgnoreCase(orderType)) {
                    criteria.addOrder(Order.asc((String)fieldName));
                    continue;
                }
                criteria.addOrder(Order.desc((String)fieldName));
            }
        }
    }

    @Override
    public void delete(long id) {
        this.bulkUpdate("DELETE FROM " + this.getEntityClass().getCanonicalName() + " WHERE id=?", null, id);
    }

    @Override
    public void delete(Object entity) {
        if (entity instanceof Long) {
            this.delete((Long)entity);
        } else {
            this.getHibernateTemplate().delete(entity);
        }
    }

    @Override
    public List executeCriteria(DetachedCriteria detachedCriteria) {
        int firstResult = Pagination.getFirstResult();
        int maxResults = Pagination.getMaxResults();
        List list = this.executeCriteria(detachedCriteria, firstResult, maxResults);
        if (Pagination.isNeedCount().booleanValue()) {
            int rowCount = this.getCountByCriteria(detachedCriteria);
            Pagination.setRowCount(rowCount);
        }
        return list;
    }

    @Override
    public List executeCriteria(final DetachedCriteria detachedCriteria, final int firstResult, final int maxResults) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = detachedCriteria.getExecutableCriteria(session);
                if (firstResult > -1) {
                    criteria.setFirstResult(firstResult);
                }
                if (maxResults > -1) {
                    criteria.setMaxResults(maxResults);
                }
                List items = criteria.list();
                return items;
            }
        });
    }

    @Override
    public Object executeUniqueCriteria(final DetachedCriteria detachedCriteria) {
        return this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = detachedCriteria.getExecutableCriteria(session);
                List totalCount = criteria.list();
                if (totalCount != null && totalCount.size() > 1) {
                    log.warn((Object)("\u5f53\u524d\u67e5\u8be2\u5230[" + totalCount.size() + "]\u6761\u8bb0\u5f55\uff0c\u800c\u4f60\u53ea\u53d6\u4e86\u4e00\u6761 " + detachedCriteria));
                }
                return totalCount == null || totalCount.isEmpty() ? null : totalCount.get(0);
            }
        });
    }

    @Override
    public int getCountByCriteria(final DetachedCriteria detachedCriteria) {
        Integer count = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                DetachedCriteriaConversion.conversion(detachedCriteria);
                Criteria criteria = detachedCriteria.getExecutableCriteria(session);
                criteria.setProjection(Projections.rowCount());
                criteria.setFirstResult(0);
                criteria.setMaxResults(1);
                List totalCount = criteria.list();
                if (totalCount != null && totalCount.size() > 1) {
                    log.warn((Object)("\u5f53\u524d\u67e5\u8be2\u5230[" + totalCount.size() + "]\u6761\u8bb0\u5f55\uff0c\u800c\u4f60\u53ea\u53d6\u4e86\u4e00\u6761 " + detachedCriteria));
                }
                return totalCount == null || totalCount.isEmpty() ? Integer.valueOf(0) : totalCount.get(0);
            }
        });
        return count;
    }

    @Override
    public T getSimpleObject(long id, String ... propertyNames) {
        if (propertyNames == null || propertyNames.length == 0) {
            return null;
        }
        ProjectionList projections = Projections.projectionList();
        for (String propertyName : propertyNames) {
            projections.add((Projection)Projections.property((String)propertyName));
        }
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getEntityClass()).setProjection((Projection)projections).add(Expression.idEq((Object)id));
        try {
            if (propertyNames.length == 1) {
                Object result = this.executeUniqueCriteria(criteria);
                if (result == null) {
                    return null;
                }
                T bean = this.entityClass.newInstance();
                PropertyUtils.setProperty(bean, (String)propertyNames[0], (Object)result);
                PropertyUtils.setProperty(bean, (String)"id", (Object)id);
                return bean;
            }
            Object[] result = (Object[])this.executeUniqueCriteria(criteria);
            if (result == null) {
                return null;
            }
            T bean = this.entityClass.newInstance();
            for (int i = 0; i < result.length; ++i) {
                PropertyUtils.setProperty(bean, (String)propertyNames[i], (Object)result[i]);
            }
            PropertyUtils.setProperty(bean, (String)"id", (Object)id);
            return bean;
        }
        catch (Exception e) {
            log.error((Object)criteria, (Throwable)e);
            return null;
        }
    }

    @Override
    public List<T> findSimpleObjects(List<Criterion> criterions, List<Order> orders, String ... propertyNames) {
        DetachedCriteria criteria = BaseDao.getSimpleObjectDetachedCriteria(this.getEntityClass(), criterions, orders, propertyNames);
        int firstResult = Pagination.getFirstResult();
        int maxResults = Pagination.getMaxResults();
        ArrayList<T> result = new ArrayList<T>();
        try {
            List list;
            if (propertyNames.length == 1) {
                list = this.executeCriteria(criteria, firstResult, maxResults);
                for (Object object : list) {
                    T bean = this.entityClass.newInstance();
                    PropertyUtils.setProperty(bean, (String)propertyNames[0], object);
                    result.add(bean);
                }
            } else {
                list = this.executeCriteria(criteria, firstResult, maxResults);
                for (Object[] objects : list) {
                    T bean = this.entityClass.newInstance();
                    for (int i = 0; i < objects.length; ++i) {
                        PropertyUtils.setProperty(bean, (String)propertyNames[i], (Object)objects[i]);
                    }
                    result.add(bean);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        if (Pagination.isNeedCount().booleanValue()) {
            int rowCount = this.getCountByCriteria(criteria);
            Pagination.setRowCount(rowCount);
        }
        return result;
    }

    @Override
    public List<T> findSimpleObjects(List<Criterion> criterions, List<Order> orders, int firstResult, int maxResult, String ... propertyNames) {
        DetachedCriteria criteria = BaseDao.getSimpleObjectDetachedCriteria(this.getEntityClass(), criterions, orders, propertyNames);
        Assert.notNull((Object)propertyNames, (String)"propertyNames is null");
        ArrayList<T> result = new ArrayList<T>();
        try {
            if (propertyNames.length == 1) {
                List list = this.executeCriteria(criteria, firstResult, maxResult);
                for (Object object : list) {
                    T bean = this.entityClass.newInstance();
                    PropertyUtils.setProperty(bean, (String)propertyNames[0], object);
                    result.add(bean);
                }
            } else {
                List list = this.executeCriteria(criteria, firstResult, maxResult);
                for (Object[] objects : list) {
                    T bean = this.entityClass.newInstance();
                    for (int i = 0; i < objects.length; ++i) {
                        PropertyUtils.setProperty(bean, (String)propertyNames[i], (Object)objects[i]);
                    }
                    result.add(bean);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return result;
    }

    private static DetachedCriteria getSimpleObjectDetachedCriteria(Class clazz, List<Criterion> criterions, List<Order> orders, String ... propertyNames) {
        if (propertyNames == null || propertyNames.length == 0) {
            return null;
        }
        ProjectionList projections = Projections.projectionList();
        for (String propertyName : propertyNames) {
            projections.add((Projection)Projections.property((String)propertyName));
        }
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)clazz).setProjection((Projection)projections);
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                criteria.add(criterion);
            }
        }
        if (orders != null) {
            for (Order order : orders) {
                criteria.addOrder(order);
            }
        }
        return criteria;
    }

    @Override
    public int count(String hqlStr, Map<String, Object> namedParameterMap, List<Object> indexParameter) {
        Object[] indexParameterC = null;
        if (indexParameter != null) {
            indexParameterC = indexParameter.toArray();
        }
        return this.count(hqlStr, "*", false, namedParameterMap, indexParameterC);
    }

    @Override
    public int count(String hqlStr, Map<String, Object> namedParameterMap, Object ... indexParameter) {
        return this.count(hqlStr, "*", false, namedParameterMap, indexParameter);
    }

    @Override
    public int count(final String hqlStr, final String countPropertiesName, final boolean isDistinct, final Map<String, Object> namedParameterMap, final Object ... indexParameter) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                String tempCountSql = hqlStr.toLowerCase();
                int fromIndex = tempCountSql.indexOf("from ");
                if (fromIndex > -1) {
                    int orderByIndex = tempCountSql.indexOf("order by");
                    String countSql = null;
                    countSql = orderByIndex > 0 ? hqlStr.substring(fromIndex, orderByIndex) : hqlStr.substring(fromIndex);
                    countSql = "select COUNT(" + (isDistinct ? "distinct " : "") + countPropertiesName + ") " + countSql;
                    Query query0 = session.createQuery(countSql);
                    BaseDao.this.setParameters(query0, namedParameterMap, indexParameter);
                    List objects = query0.list();
                    if (objects != null && objects.size() > 1) {
                        log.warn((Object)("\u5f53\u524d\u67e5\u8be2\u5230[" + objects.size() + "]\u6761\u8bb0\u5f55\uff0c\u800c\u4f60\u53ea\u53d6\u4e86\u4e00\u6761 " + hqlStr));
                    }
                    int totalCount = objects == null || objects.isEmpty() ? 0 : ((Number)objects.get(0)).intValue();
                    return totalCount;
                }
                return 0;
            }
        });
    }

    @Override
    public List find(String hqlStr, int firstResult, int maxResults, Map<String, Object> namedParameterMap, List<Object> indexParameter) {
        Object[] indexParameterC = null;
        if (indexParameter != null) {
            indexParameterC = indexParameter.toArray();
        }
        return this.find(hqlStr, firstResult, maxResults, namedParameterMap, indexParameterC);
    }

    @Override
    public List find(final String hqlStr, final int firstResult, final int maxResults, final Map<String, Object> namedParameterMap, final Object ... indexParameter) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hqlStr);
                BaseDao.this.setParameters(query, namedParameterMap, indexParameter);
                if (firstResult > -1) {
                    query.setFirstResult(firstResult);
                }
                if (maxResults > -1) {
                    query.setMaxResults(maxResults);
                }
                return query.list();
            }
        });
    }

    @Override
    public List find(String hqlStr, String countPropertiesName, boolean isDistinct, Map<String, Object> namedParameterMap, List<Object> indexParameter) {
        Object[] indexParameterC = null;
        if (indexParameter != null) {
            indexParameterC = indexParameter.toArray();
        }
        return this.find(hqlStr, countPropertiesName, isDistinct, namedParameterMap, indexParameterC);
    }

    @Override
    public List find(String hqlStr, String countPropertiesName, boolean isDistinct, Map<String, Object> namedParameterMap, Object ... indexParameter) {
        return this.find(false, null, hqlStr, countPropertiesName, isDistinct, namedParameterMap, indexParameter);
    }

    private List findNativeSQL(String hqlStr, Class entityClass, String countPropertiesName, boolean isDistinct, Map<String, Object> namedParameterMap, Object ... indexParameter) {
        return this.find(true, entityClass, hqlStr, countPropertiesName, isDistinct, namedParameterMap, indexParameter);
    }

    private List find(final boolean isNativeSQL, final Class entityClass, final String hqlStr, final String countPropertiesName, final boolean isDistinct, final Map<String, Object> namedParameterMap, final Object ... indexParameter) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                int maxResults;
                String tempCountSql;
                int fromIndex;
                if (Pagination.isNeedCount().booleanValue() && (fromIndex = (tempCountSql = hqlStr.toLowerCase()).indexOf("from ")) > -1) {
                    int orderByIndex = tempCountSql.indexOf("order by");
                    String countSql = null;
                    countSql = orderByIndex > 0 ? hqlStr.substring(fromIndex, orderByIndex) : hqlStr.substring(fromIndex);
                    countSql = "select COUNT(" + (isDistinct ? "distinct " : "") + countPropertiesName + ") " + countSql;
                    SQLQuery query0 = isNativeSQL ? session.createSQLQuery(countSql) : session.createQuery(countSql);
                    BaseDao.this.setParameters((Query)query0, namedParameterMap, indexParameter);
                    List objects = query0.list();
                    if (objects != null && objects.size() > 1) {
                        log.warn((Object)("\u5f53\u524d\u67e5\u8be2\u5230[" + objects.size() + "]\u6761\u8bb0\u5f55\uff0c\u800c\u4f60\u53ea\u53d6\u4e86\u4e00\u6761 " + hqlStr));
                    }
                    int totalCount = objects == null || objects.isEmpty() ? 0 : ((Number)objects.get(0)).intValue();
                    Pagination.setRowCount(totalCount);
                    if (totalCount == 0) {
                        Pagination.getFirstResult();
                        Pagination.getMaxResults();
                        return new ArrayList(0);
                    }
                }
                SQLQuery query = null;
                if (isNativeSQL) {
                    query = session.createSQLQuery(hqlStr);
                    query.addEntity("a", entityClass);
                } else {
                    query = session.createQuery(hqlStr);
                }
                BaseDao.this.setParameters((Query)query, namedParameterMap, indexParameter);
                int firstResult = Pagination.getFirstResult();
                if (firstResult != -1) {
                    query.setFirstResult(firstResult);
                }
                if ((maxResults = Pagination.getMaxResults()) != -1) {
                    query.setMaxResults(maxResults);
                }
                return query.list();
            }
        });
    }

    @Override
    public List find(String hqlStr, Map<String, Object> namedParameterMap, List<Object> indexParameter) {
        Object[] indexParameterC = null;
        if (indexParameter != null) {
            indexParameterC = indexParameter.toArray();
        }
        return this.find(hqlStr, namedParameterMap, indexParameterC);
    }

    @Override
    public List find(String hqlStr, Map<String, Object> namedParameterMap, Object ... indexParameter) {
        return this.find(hqlStr, "*", false, namedParameterMap, indexParameter);
    }

    @Override
    public List findNativeSQL(String nativeSQL, Class entityClass, Map<String, Object> namedParameterMap, Object ... indexParameter) {
        return this.findNativeSQL(nativeSQL, entityClass, "*", false, namedParameterMap, indexParameter);
    }

    @Override
    public Object findUnique(String hqlStr, Map<String, Object> namedParameterMap, List<Object> indexParameter) {
        Object[] indexParameterC = null;
        if (indexParameter != null) {
            indexParameterC = indexParameter.toArray();
        }
        return this.findUnique(hqlStr, namedParameterMap, indexParameterC);
    }

    @Override
    public Object findUnique(final String hqlStr, final Map<String, Object> namedParameterMap, final Object ... indexParameter) {
        return this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hqlStr);
                BaseDao.this.setParameters(query, namedParameterMap, indexParameter);
                query.setFirstResult(0);
                query.setMaxResults(1);
                List objects = query.list();
                return objects == null || objects.isEmpty() ? null : objects.get(0);
            }
        });
    }

    protected void setParameters(Query query, Map<String, Object> namedParameterMap, Object ... indexParameter) {
        if (namedParameterMap != null) {
            Set<Map.Entry<String, Object>> entries = namedParameterMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    query.setParameterList(name, (Collection)value);
                    continue;
                }
                if (value instanceof Object[]) {
                    query.setParameterList(name, (Object[])value);
                    continue;
                }
                query.setParameter(name, value);
            }
        }
        if (indexParameter != null) {
            for (int i = 0; i < indexParameter.length; ++i) {
                query.setParameter(i, indexParameter[i]);
            }
        }
    }

    @Override
    public int bulkUpdate(String hql, Map<String, Object> nameParameters, List<Object> indexParameter) {
        Object[] indexParameterC = null;
        if (indexParameter != null) {
            indexParameterC = indexParameter.toArray();
        }
        return this.bulkUpdate(hql, nameParameters, indexParameterC);
    }

    @Override
    public int bulkUpdate(final String hql, final Map<String, Object> nameParameters, final Object ... indexParameter) {
        Integer updateCount = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(hql);
                BaseDao.this.setParameters(queryObject, nameParameters, indexParameter);
                return queryObject.executeUpdate();
            }
        });
        return updateCount;
    }

    @Override
    public List findWithCount(final String hqlStr, final String countSql, final Map<String, Object> namedParameterMap, final Object ... indexParameter) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                if (countSql != null) {
                    Query query0 = session.createQuery(countSql);
                    BaseDao.this.setParameters(query0, namedParameterMap, indexParameter);
                    List objects = query0.list();
                    if (objects != null && objects.size() > 1) {
                        log.warn((Object)("\u5f53\u524d\u67e5\u8be2\u5230[" + objects.size() + "]\u6761\u8bb0\u5f55\uff0c\u800c\u4f60\u53ea\u53d6\u4e86\u4e00\u6761 " + hqlStr));
                    }
                    int totalCount = objects == null || objects.isEmpty() ? 0 : ((Number)objects.get(0)).intValue();
                    Pagination.setRowCount(totalCount);
                    if (totalCount == 0) {
                        Pagination.getFirstResult();
                        Pagination.getMaxResults();
                        return new ArrayList(0);
                    }
                }
                Query query = session.createQuery(hqlStr);
                BaseDao.this.setParameters(query, namedParameterMap, indexParameter);
                query.setFirstResult(Pagination.getFirstResult());
                query.setMaxResults(Pagination.getMaxResults());
                return query.list();
            }
        });
    }

    @Override
    public List findWithCount(String hqlStr, String countSql, Map<String, Object> namedParameterMap, List<Object> indexParameter) {
        Object[] indexParameterC = null;
        if (indexParameter != null) {
            indexParameterC = indexParameter.toArray();
        }
        return this.findWithCount(hqlStr, countSql, namedParameterMap, indexParameterC);
    }
}

