/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.customize.manager;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.customize.dao.CustomizeDao;
import com.seeyon.ctp.common.customize.manager.CustomizeManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileSecurityManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.customize.CtpCustomize;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;

@ProcessInDataSource(name=DataSourceName.BASE)
public class CustomizeManagerImpl
implements CustomizeManager {
    private CustomizeDao customizeDao;
    private FileSecurityManager fileSecurityManager;
    private static final Log log = CtpLogFactory.getLog(CustomizeManagerImpl.class);
    private CustomizeCache cache;
    private Map<String, String> defaultValue = new HashMap<String, String>();

    public FileSecurityManager getFileSecurityManager() {
        return this.fileSecurityManager;
    }

    public void setFileSecurityManager(FileSecurityManager fileSecurityManager) {
        this.fileSecurityManager = fileSecurityManager;
    }

    public void setDefaultValue(Map<String, String> defaultValue) {
        this.defaultValue.putAll(defaultValue);
    }

    public void setCustomizeDao(CustomizeDao customizeDao) {
        this.customizeDao = customizeDao;
    }

    @Override
    public List<CtpCustomize> getCustomizeInfo(List<Long> memberIds, String key) throws BusinessException {
        return this.cache.get(memberIds, key);
    }

    @Override
    public void saveAllCustomizeInfo(List<CtpCustomize> customizes) throws BusinessException {
        if (!org.springframework.util.CollectionUtils.isEmpty(customizes)) {
            DBAgent.saveAll(customizes);
            this.cache.update(customizes);
        }
    }

    @Override
    public void updateAllCustomizeInfo(List<CtpCustomize> customizes) throws BusinessException {
        if (!org.springframework.util.CollectionUtils.isEmpty(customizes)) {
            DBAgent.mergeAll(customizes);
            this.cache.update(customizes);
        }
    }

    @Override
    public CtpCustomize getCustomizeById(Long id) {
        return this.cache.find(id);
    }

    @Override
    public List<CtpCustomize> getCustomizeByKey(String key) {
        return this.cache.get(key);
    }

    @Override
    public List<CtpCustomize> getCustomizeInfo(Long memberId) {
        Map<String, CtpCustomize> map = this.cache.get(memberId);
        if (map == null) {
            return Collections.emptyList();
        }
        return this.cache.map2List(map);
    }

    private void loadAll() {
        List<CtpCustomize> customizes = this.customizeDao.getAll();
        ArrayList<CtpCustomize> defaultCustomizes = new ArrayList<CtpCustomize>();
        for (CtpCustomize cc : customizes) {
            if (this.isDefaultValue(cc.getCkey(), cc.getCvalue())) {
                defaultCustomizes.add(cc);
                continue;
            }
            this.cache.update(cc);
        }
        if (CollectionUtils.isNotEmpty(defaultCustomizes)) {
            DBAgent.deleteAll(defaultCustomizes);
        }
        log.info((Object)"\u5f00\u59cb\u52a0\u8f7d\u4e2a\u6027\u5316\u4fe1\u606f\u6dfb\u52a0\u5230\u6587\u4ef6\u767d\u540d\u5355");
        this.writePersonalPhotoToFileSecurity(customizes);
    }

    private void writePersonalPhotoToFileSecurity(List<CtpCustomize> customizeList) {
        String customizePhoteKey = "avatar";
        for (CtpCustomize custiomize : customizeList) {
            String fileIdStrAll;
            String[] fileIdStrArray;
            String[] cvalueArray;
            String cvalue;
            String ckey = custiomize.getCkey();
            if (!customizePhoteKey.equals(ckey.trim().toLowerCase()) || (cvalue = custiomize.getCvalue()) == null || (cvalueArray = cvalue.split("&")).length <= 0 || (fileIdStrArray = (fileIdStrAll = cvalueArray[0]).split("=")).length <= 1) continue;
            String fileIdStr = fileIdStrArray[1];
            log.debug((Object)("\u4e2a\u6027\u5316\u56fe\u50cf\u4fe1\u606f\u6dfb\u52a0\u5230\u767d\u540d\u5355\u4e2d:" + fileIdStr));
            this.fileSecurityManager.addNeedlessLogin(fileIdStr);
        }
    }

    @Override
    public void deleteCustomizeById(Long id) throws BusinessException {
        CtpCustomize customize = this.getCustomizeById(id);
        if (customize == null) {
            customize = new CtpCustomize();
            customize.setId(id);
        } else {
            this.cache.remove(customize);
        }
        DBAgent.delete(customize);
    }

    @Override
    public void deleteAllCustomize(List<CtpCustomize> customizes) throws BusinessException {
        if (!org.springframework.util.CollectionUtils.isEmpty(customizes)) {
            DBAgent.deleteAll(customizes);
            this.cache.removeAll(customizes);
        }
    }

    @Override
    public CtpCustomize saveCustomize(CtpCustomize customize) {
        if (customize == null) {
            return null;
        }
        customize.setIdIfNew();
        DBAgent.save(customize);
        this.cache.update(customize);
        return customize;
    }

    @Override
    public CtpCustomize updateCustomize(CtpCustomize customize) {
        if (customize == null) {
            return null;
        }
        DBAgent.update(customize);
        this.cache.update(customize);
        return customize;
    }

    @Override
    public CtpCustomize getCustomizeInfo(Long memberId, String key) {
        return this.cache.get(memberId, key);
    }

    @Override
    public CtpCustomize getCustomizeInfoWithCache(Long memberId, String key) throws BusinessException {
        return this.getCustomizeInfo(memberId, key);
    }

    public void init() {
        this.cache = new CustomizeCache();
        this.loadAll();
    }

    private boolean isDefaultValue(String key, String value) {
        return Strings.isBlank(value) || Strings.equals(this.defaultValue.get(key), value);
    }

    @Override
    public Map<String, String> getCustomizeMap(Long memberId) {
        HashMap<String, String> result0 = new HashMap<String, String>(this.defaultValue);
        List<CtpCustomize> db = this.getCustomizeInfo(memberId);
        for (CtpCustomize c : db) {
            result0.put(c.getCkey(), c.getCvalue());
        }
        return result0;
    }

    @Override
    public String getCustomizeValue(long memberId, String key) {
        CtpCustomize customizeInfo = this.getCustomizeInfo(memberId, key);
        if (customizeInfo == null) {
            return this.defaultValue.get(key);
        }
        return Strings.escapeNULL(customizeInfo.getCvalue(), this.defaultValue.get(key));
    }

    @Override
    public void saveOrUpdateCustomize(long memberId, String key, String value) {
        if (this.isDefaultValue(key, value)) {
            DBAgent.bulkUpdate("DELETE from CtpCustomize cc where cc.userId=? AND cc.ckey=?", memberId, key);
            Map<String, CtpCustomize> map = this.cache.get(memberId);
            if (map != null) {
                CtpCustomize c = map.get(key);
                this.cache.remove(c);
            }
            return;
        }
        CtpCustomize customize = this.getCustomizeInfo(memberId, key);
        if (customize == null) {
            customize = new CtpCustomize();
            customize.setIdIfNew();
            customize.setCreateDate(new Date());
            customize.setUserId(memberId);
            customize.setCkey(key);
            customize.setCvalue(value);
            DBAgent.save(customize);
        } else {
            DBAgent.bulkUpdate("UPDATE CtpCustomize cc set cc.cvalue=?,updateDate=? where cc.userId=? AND cc.ckey=?", value, new Date(), memberId, key);
            customize.setCvalue(value);
        }
        this.cache.update(customize);
        ArrayList<CtpCustomize> customizeList = new ArrayList<CtpCustomize>(1);
        customizeList.add(customize);
        this.writePersonalPhotoToFileSecurity(customizeList);
    }

    @Override
    public List<CtpCustomize> getCustomizeStartWithKey(String key) {
        return this.cache.find(key, true);
    }

    class CustomizeCache {
        private CacheMap<Long, ConcurrentHashMap<String, CtpCustomize>> originCache;

        public CustomizeCache() {
            CacheAccessable factory = CacheFactory.getInstance(CustomizeManager.class);
            this.originCache = factory.createMap("cache");
        }

        public void update(Collection<CtpCustomize> customizes) {
            if (customizes == null) {
                return;
            }
            for (CtpCustomize c : customizes) {
                this.update(c);
            }
        }

        public void update(CtpCustomize c) {
            if (c == null) {
                return;
            }
            ConcurrentHashMap<String, CtpCustomize> cacheEntry = this.originCache.get(c.getUserId());
            if (cacheEntry == null) {
                cacheEntry = new ConcurrentHashMap();
                cacheEntry.put(c.getCkey(), c);
                this.originCache.put(c.getUserId(), cacheEntry);
            } else {
                cacheEntry.put(c.getCkey(), c);
                this.originCache.notifyUpdate(c.getUserId(), (Serializable)((Object)c.getCkey()), CacheNotification.Action.Put, c);
            }
        }

        public Map<String, CtpCustomize> get(Long memberId) {
            return this.originCache.get(memberId);
        }

        public List<CtpCustomize> map2List(Map<String, CtpCustomize> map) {
            if (map == null) {
                return null;
            }
            ArrayList<CtpCustomize> result = new ArrayList<CtpCustomize>();
            for (CtpCustomize c : map.values()) {
                result.add(c);
            }
            return result;
        }

        public void remove(CtpCustomize c) {
            if (c == null) {
                return;
            }
            Long userId = c.getUserId();
            Map map = this.originCache.get(userId);
            if (map != null) {
                map.remove(c.getCkey());
            }
            this.originCache.notifyUpdate(userId);
        }

        public void removeAll(Collection<CtpCustomize> customizes) {
            if (customizes == null) {
                return;
            }
            for (CtpCustomize c : customizes) {
                this.remove(c);
            }
        }

        public List<CtpCustomize> get(String key) {
            if (key == null) {
                return Collections.emptyList();
            }
            ArrayList<CtpCustomize> list = new ArrayList<CtpCustomize>();
            for (Map map : this.originCache.values()) {
                for (CtpCustomize c : map.values()) {
                    if (!key.equals(c.getCkey())) continue;
                    list.add(c);
                }
            }
            return list;
        }

        public List<CtpCustomize> get(List<Long> memberIds, String key) {
            if (key == null) {
                return Collections.emptyList();
            }
            ArrayList<CtpCustomize> list = new ArrayList<CtpCustomize>();
            for (Long id : memberIds) {
                CtpCustomize value = this.get(id, key);
                if (value == null) continue;
                list.add(value);
            }
            return list;
        }

        public CtpCustomize get(Long memberId, String key) {
            if (key == null) {
                return null;
            }
            Map<String, CtpCustomize> map = this.get(memberId);
            if (map == null) {
                return null;
            }
            return map.get(key);
        }

        public CtpCustomize find(Long id) {
            if (id == null) {
                return null;
            }
            for (Map map : this.originCache.values()) {
                for (CtpCustomize c : map.values()) {
                    if (!id.equals(c.getId())) continue;
                    return c;
                }
            }
            return null;
        }

        public List<CtpCustomize> find(String key, boolean isLike) {
            if (key == null) {
                return Collections.emptyList();
            }
            ArrayList<CtpCustomize> list = new ArrayList<CtpCustomize>();
            for (Map map : this.originCache.values()) {
                for (CtpCustomize c : map.values()) {
                    String ckey = c.getCkey();
                    if (key.equals(ckey)) {
                        list.add(c);
                        continue;
                    }
                    if (!isLike || !ckey.startsWith(key)) continue;
                    list.add(c);
                }
            }
            return list;
        }
    }
}

