/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.constants;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.spring.SortOrderable;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public final class SystemProperties {
    private static Log LOGGER = CtpLogFactory.getLog(SystemProperties.class);
    public static String CONFIG_APPLICATION_ROOT_KEY = "ApplicationRoot";
    public static String CONFIG_PAGINATE_PAGE_SIZE = "paginate.page.size";
    public static String CONFIG_LOCALES = "ctp.locales";
    public static String CONFIG_SYSTEM_NAME = "ctp.systemName";
    public static String CONFIG_RUNNING_MODE = "ctp.runningMode";
    public static String CONFIG_INITIALIZER = "ctp.init.initializer";
    public static String CONFIG_LOGIN_INTERCEPTER = "ctp.login.intercepters.intercepter";
    public static String CONFIG_LOGIN_AUTHENTICATION = "ctp.login.authentications.authentication";
    public static String CONFIG_LOGIN_ACTIVEX = "ctp.login.activexes.activex";
    public static String CONFIG_ENUM_EXPORT = "ctp.enum.export";
    private Map<Object, Object> props = new ConcurrentHashMap<Object, Object>();
    private Map<Object, Object> responseHeader = new HashMap<Object, Object>();
    private static SystemProperties instance = new SystemProperties();
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";

    private SystemProperties() {
    }

    public static SystemProperties getInstance() {
        return instance;
    }

    public Properties getAllProperties() {
        Properties p = new Properties();
        p.putAll(this.props);
        return p;
    }

    public String getProperty(String key) {
        return (String)this.props.get(key);
    }

    public Integer getIntegerProperty(String key) {
        String t = this.getProperty(key);
        if (t != null) {
            return Integer.parseInt(t);
        }
        return null;
    }

    public Integer getIntegerProperty(String key, int defaultValue) {
        String t = this.getProperty(key);
        if (t != null) {
            return Integer.parseInt(t);
        }
        return defaultValue;
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    public void init(Properties props) {
        this.props.putAll(props);
        Set<Map.Entry<Object, Object>> enities = props.entrySet();
        for (Map.Entry<Object, Object> entry : enities) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            value = SystemProperties.interpolateHelper(value, props);
            this.props.put(key, value);
        }
    }

    public void put(String key, String value) {
        if (value == null) {
            return;
        }
        if (value.equals(this.props.get(key))) {
            return;
        }
        this.props.put(key, value);
    }

    public void putAll(Properties props) {
        this.props.putAll(props);
        this.interpolateAll();
    }

    public void printAll(Properties properties) {
        if (LOGGER.isDebugEnabled()) {
            TreeMap<Object, Object> tmap = new TreeMap<Object, Object>();
            tmap.putAll(properties);
            for (String key : tmap.keySet()) {
                String val = (String)tmap.get(key);
                LOGGER.debug((Object)("Loaded property: " + key + "=" + val));
            }
        }
    }

    public void save(String key, String object) {
        throw new UnsupportedOperationException();
    }

    private void interpolateAll() {
        Set<Object> enus = this.props.keySet();
        for (Object k : enus) {
            String key = (String)k;
            String val = (String)this.props.get(key);
            this.props.put(key, SystemProperties.interpolateHelper(val, null, this.props));
        }
    }

    public static String interpolateHelper(String base, Properties config) {
        return SystemProperties.interpolateHelper(base, null, config);
    }

    private static String interpolateHelper(String base, List<String> priorVariables, Map config) {
        if (base == null) {
            return null;
        }
        if (priorVariables == null) {
            priorVariables = new ArrayList<String>();
            priorVariables.add(base);
        }
        int begin = -1;
        int end = -1;
        int prec = 0 - END_TOKEN.length();
        StringBuilder result = new StringBuilder();
        while ((begin = base.indexOf(START_TOKEN, prec + END_TOKEN.length())) > -1 && (end = base.indexOf(END_TOKEN, begin)) > -1) {
            result.append(base.substring(prec + END_TOKEN.length(), begin));
            String variable = base.substring(begin + START_TOKEN.length(), end);
            if (priorVariables.contains(variable)) {
                String initialBase = priorVariables.remove(0).toString();
                priorVariables.add(variable);
                StringBuilder priorVariableSb = new StringBuilder();
                Iterator<String> it = priorVariables.iterator();
                while (it.hasNext()) {
                    priorVariableSb.append((Object)it.next());
                    if (!it.hasNext()) continue;
                    priorVariableSb.append("->");
                }
                throw new IllegalStateException("infinite loop in property interpolation of " + initialBase + ": " + priorVariableSb.toString());
            }
            priorVariables.add(variable);
            Object value = config.get(variable);
            if (value != null) {
                result.append(SystemProperties.interpolateHelper(value.toString(), priorVariables, config));
                priorVariables.remove(priorVariables.size() - 1);
            } else {
                result.append(START_TOKEN);
                result.append(variable);
                result.append(END_TOKEN);
            }
            prec = end;
        }
        result.append(base.substring(prec + END_TOKEN.length(), base.length()));
        return result.toString();
    }

    public static <T> Map<String, T> getBeansOfTypeAndSysConfig(Class<T> type, String configKey) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String sysConfig = AppContext.getSystemProperty(configKey);
        HashSet<String> classNames = new HashSet<String>();
        if (sysConfig != null) {
            String[] inits;
            for (String c : inits = sysConfig.split("\\|")) {
                if (!Strings.isNotBlank(c)) continue;
                try {
                    Object instance = Class.forName(c).newInstance();
                    if (type.isAssignableFrom(instance.getClass())) {
                        result.put(c, instance);
                    } else {
                        LOGGER.error((Object)("Bean [" + c + "] doesn't implement " + type));
                    }
                    classNames.add(c);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Bean initilize failed: " + c), (Throwable)e);
                }
            }
        }
        final Map<String, T> initsMap = AppContext.getBeansOfType(type);
        HashSet<String> keySet = new HashSet<String>(initsMap.keySet());
        for (String beanName : keySet) {
            T bean = initsMap.get(beanName);
            String name = bean.getClass().getCanonicalName();
            if (classNames.contains(name)) {
                LOGGER.warn((Object)("getBeansOfTypeAndSysConfig: " + beanName + "'s class " + name + " is existed.please remove spring bean definition from xml."));
                initsMap.remove(beanName);
                continue;
            }
            classNames.add(name);
        }
        Comparator<String> comp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                boolean ob1 = false;
                boolean ob2 = false;
                Object obj1 = initsMap.get(o1);
                Object obj2 = initsMap.get(o2);
                if (obj1 instanceof SortOrderable) {
                    ob1 = true;
                }
                if (obj2 instanceof SortOrderable) {
                    ob2 = true;
                }
                if (ob1 && !ob2) {
                    return -1;
                }
                if (ob1 && ob2) {
                    SortOrderable s1 = (SortOrderable)obj1;
                    SortOrderable s2 = (SortOrderable)obj2;
                    if (s1.getSortOrder() < s2.getSortOrder()) {
                        return -1;
                    }
                }
                return 1;
            }
        };
        TreeMap<String, T> sortedMap = new TreeMap<String, T>(comp);
        sortedMap.putAll(initsMap);
        result.putAll(sortedMap);
        return result;
    }

    public void putResponseHeader(Properties props) {
        this.responseHeader.putAll(props);
    }

    public Map<Object, Object> getResponseHeader() {
        return this.responseHeader;
    }

    public void setResponseHeader(Map<Object, Object> responseHeader) {
        this.responseHeader = responseHeader;
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
    }
}

