/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.config.manager;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.config.dao.ConfigDAO;
import com.seeyon.ctp.common.config.manager.ConfigManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.flag.SysFlag;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.config.ConfigItem;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.json.JSONUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

@ProcessInDataSource(name=DataSourceName.BASE)
public class ConfigManagerImpl
implements ConfigManager {
    private static Log log = CtpLogFactory.getLog(ConfigManagerImpl.class);
    private ConfigDAO configDao;
    private CacheMap<Long, ConfigItem> fConfigMap;
    private CacheMap<String, HashSet<Long>> category2Config;
    private CacheMap<String, Long> categoryAndItem2Config;

    public void setConfigDao(ConfigDAO configDao) {
        this.configDao = configDao;
    }

    public void init() {
        long startTime = System.currentTimeMillis();
        String cacheName = "fConfigMap";
        CacheAccessable c = CacheFactory.getInstance(ConfigManagerImpl.class);
        this.fConfigMap = c.isExist(cacheName) ? c.getMap(cacheName) : c.createMap(cacheName);
        this.category2Config = c.isExist("category2Config") ? c.getMap("category2Config") : c.createMap("category2Config");
        this.categoryAndItem2Config = c.isExist("categoryAndItem2Config") ? c.getMap("categoryAndItem2Config") : c.createMap("categoryAndItem2Config");
        DetachedCriteria criteria = DetachedCriteria.forClass(ConfigItem.class);
        List list = this.configDao.searchByCriteria(criteria);
        for (ConfigItem item : list) {
            this.fConfigMap.put(item.getId(), item);
            String key = item.getConfigCategory() + item.getOrgAccountId();
            HashSet<Long> tempItems = this.category2Config.get(key);
            if (tempItems == null) {
                tempItems = new HashSet();
            }
            tempItems.add(item.getId());
            this.category2Config.put(key, tempItems);
            String key1 = item.getConfigCategory() + item.getConfigItem() + item.getOrgAccountId();
            this.categoryAndItem2Config.put(key1, item.getId());
        }
        log.info((Object)("\u52a0\u8f7d\u6240\u6709CONFIG\u6570\u636e. \u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + " MS"));
    }

    @Override
    public ConfigItem addConfigItem(String configCategory, String item, String configValue) {
        return this.addConfigItem(configCategory, item, configValue, 1L);
    }

    @Override
    public ConfigItem addConfigItem(String configCategory, String item, String configValue, String configDesp, String configType) {
        return this.addConfigItem(configCategory, item, configValue, configDesp, configType, 1L);
    }

    @Override
    public void deleteByConfigCategory(String configCategory) {
        this.deleteByConfigCategory(configCategory, 1L);
    }

    @Override
    public void deleteConfigItem(String configCategory, String configItem) {
        this.deleteConfigItem(configCategory, configItem, 1L);
    }

    @Override
    public ConfigItem getConfigItem(String configCategory, String configItem) {
        return this.getConfigItem(configCategory, configItem, 1L);
    }

    @Override
    public List<ConfigItem> listAllConfigByCategory(String configCategory) {
        return this.listAllConfigByCategory(configCategory, 1L);
    }

    @Override
    public List<ConfigItem> listAllAccountConfigByCategory(String configCategory) {
        Collection<ConfigItem> templst = this.fConfigMap.values();
        ArrayList<ConfigItem> returnlst = new ArrayList<ConfigItem>();
        for (ConfigItem cfi : templst) {
            if (!configCategory.equals(cfi.getConfigCategory())) continue;
            returnlst.add(cfi);
        }
        return returnlst;
    }

    @Override
    public void updateConfigItem(ConfigItem item) {
        Date date = new Date();
        Timestamp stamp = new Timestamp(date.getTime());
        item.setModifyDate(stamp);
        this.configDao.update(item);
        this.updataCatchConfig(item);
    }

    private void updataCatchConfig(ConfigItem item) {
        this.fConfigMap.put(item.getId(), item);
        String key0 = item.getConfigCategory() + item.getOrgAccountId();
        HashSet<Long> list = this.category2Config.get(key0);
        if (null == list) {
            list = new HashSet();
        }
        list.add(item.getId());
        this.category2Config.put(key0, list);
        String key = item.getConfigCategory() + item.getConfigItem() + item.getOrgAccountId();
        this.categoryAndItem2Config.put(key, item.getId());
    }

    @Override
    public void updateConfigItemOnlyInDB(ConfigItem item) {
        Date date = new Date();
        Timestamp stamp = new Timestamp(date.getTime());
        item.setModifyDate(stamp);
        this.configDao.update(item);
        this.updataCatchConfig(item);
    }

    @Override
    public void updateConfigItemOnlyInMemory(ConfigItem item) {
        Date date = new Date();
        Timestamp stamp = new Timestamp(date.getTime());
        item.setModifyDate(stamp);
        this.fConfigMap.put(item.getId(), item);
    }

    @Override
    public void deleteConfigItemOnlyInMemory(long id) {
        ConfigItem item = this.fConfigMap.get(id);
        this.fConfigMap.remove(id);
        HashSet<Long> list = this.category2Config.get(item.getConfigCategory() + item.getOrgAccountId());
        if (null != list && list.remove(id)) {
            this.category2Config.put(item.getConfigCategory() + item.getOrgAccountId(), list);
        }
        String key = item.getConfigCategory() + item.getConfigItem() + item.getOrgAccountId();
        this.categoryAndItem2Config.remove(key);
    }

    @Override
    public void addConfigItem(ConfigItem item) {
        this.configDao.save(item);
        this.updataCatchConfig(item);
    }

    @Override
    public void addConfigItemOnlyInDB(ConfigItem item) {
        this.configDao.save(item);
    }

    @Override
    public ConfigItem getConfigItem(Long id) {
        return this.fConfigMap.get(id);
    }

    @Override
    public ConfigItem getConfigItemByCriteria(Long id) {
        return this.fConfigMap.get(id);
    }

    @Override
    public void deleteCriteria(Long id) {
        ConfigItem item = this.fConfigMap.get(id);
        this.configDao.removeById(id);
        this.fConfigMap.remove(id);
        HashSet<Long> list = this.category2Config.get(item.getConfigCategory() + item.getOrgAccountId());
        if (CollectionUtils.isNotEmpty(list) && list.remove(id)) {
            this.category2Config.put(item.getConfigCategory() + item.getOrgAccountId(), list);
        }
        this.categoryAndItem2Config.remove(item.getConfigCategory() + item.getConfigItem() + item.getOrgAccountId());
    }

    @Override
    public ConfigItem addConfigItem(String configCategory, String item, String configValue, Long accountId) {
        ConfigItem configItem = new ConfigItem();
        configItem.setIdIfNew();
        configItem.setConfigCategory(configCategory);
        configItem.setConfigItem(item);
        configItem.setConfigValue(configValue);
        Timestamp stamp = new Timestamp(System.currentTimeMillis());
        configItem.setCreateDate(stamp);
        configItem.setOrgAccountId(accountId);
        this.addConfigItem(configItem);
        return configItem;
    }

    @Override
    public ConfigItem addConfigItem(String configCategory, String item, String configValue, String configDesp, String configType, Long accountId) {
        ConfigItem configItem = new ConfigItem();
        configItem.setConfigCategory(configCategory);
        configItem.setConfigItem(item);
        configItem.setConfigValue(configValue);
        configItem.setConfigDescription(configDesp);
        configItem.setConfigType(configType);
        Date date = new Date();
        Timestamp stamp = new Timestamp(date.getTime());
        configItem.setCreateDate(stamp);
        configItem.setIdIfNew();
        configItem.setOrgAccountId(accountId);
        this.addConfigItem(configItem);
        return configItem;
    }

    @Override
    public void deleteByConfigCategory(String configCategory, Long accountId) {
        this.configDao.delete(new Object[][]{{"configCategory", configCategory}, {"orgAccountId", accountId}});
        HashSet<Long> removeIds = new HashSet<Long>();
        HashSet<String> type2Remove = new HashSet<String>();
        Collection<ConfigItem> clt = this.fConfigMap.values();
        for (ConfigItem cfi : clt) {
            if (cfi.getOrgAccountId().longValue() != accountId.longValue() || !configCategory.equals(cfi.getConfigCategory())) continue;
            this.fConfigMap.remove(cfi.getId());
            removeIds.add(cfi.getId());
            type2Remove.add(configCategory + cfi.getConfigItem() + accountId);
        }
        HashSet<Long> list = this.category2Config.get(configCategory + accountId);
        if (null != list && list.removeAll(removeIds)) {
            this.category2Config.put(configCategory + accountId, list);
        }
        this.categoryAndItem2Config.removeAll(type2Remove);
    }

    @Override
    public void deleteConfigItem(String configCategory, String configItem, Long accountId) {
        ConfigItem config = this.getConfigItem(configCategory, configItem, accountId);
        if (config == null) {
            return;
        }
        this.configDao.removeObject(config);
        this.fConfigMap.remove(config.getId());
        HashSet<Long> list = this.category2Config.get(configCategory + accountId);
        if (CollectionUtils.isNotEmpty(list) && list.remove(config.getId())) {
            this.category2Config.put(configCategory + accountId, list);
        }
        this.categoryAndItem2Config.remove(configCategory + configItem + accountId);
    }

    @Override
    public ConfigItem getConfigItem(String configCategory, String configItem, Long accountId) {
        Long itemId = this.categoryAndItem2Config.get(configCategory + configItem + accountId);
        return this.fConfigMap.get(itemId);
    }

    @Override
    public ConfigItem getConfigItemFromDB(String configCategory, String configItem, Long accountId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ConfigItem.class).add((Criterion)Restrictions.eq((String)"configCategory", (Object)configCategory)).add((Criterion)Restrictions.eq((String)"configItem", (Object)configItem)).add((Criterion)Restrictions.eq((String)"orgAccountId", (Object)accountId));
        List templst = this.configDao.searchByCriteria(criteria);
        Iterator iterator = templst.iterator();
        if (iterator.hasNext()) {
            ConfigItem cfi = (ConfigItem)iterator.next();
            return cfi;
        }
        return null;
    }

    @Override
    public List<ConfigItem> listAllConfigByCategory(String configCategory, Long accountId) {
        ArrayList<ConfigItem> returnList = new ArrayList<ConfigItem>();
        HashSet<Long> itemIds = this.category2Config.get(configCategory + accountId);
        if (null != itemIds) {
            for (Long id : itemIds) {
                ConfigItem item = this.fConfigMap.get(id);
                if (item == null) continue;
                returnList.add(item);
            }
        }
        return returnList;
    }

    @Override
    public void saveInitCmpConfigData(String configCategory, Long accountId) {
        List<ConfigItem> configItems = this.listAllConfigByCategory(configCategory, accountId);
        if (configItems != null && configItems.size() > 0) {
            return;
        }
        Long groupAccountId = 1L;
        configItems = this.listAllConfigByCategory(configCategory, groupAccountId);
        HashMap<Long, ConfigItem> temp = new HashMap<Long, ConfigItem>();
        for (ConfigItem cf : configItems) {
            ConfigItem ncf = new ConfigItem();
            ncf.setIdIfNew();
            ncf.setConfigCategory(cf.getConfigCategory());
            ncf.setConfigCategoryName(cf.getConfigCategoryName());
            ncf.setConfigDescription(cf.getConfigDescription());
            ncf.setConfigItem(cf.getConfigItem());
            ncf.setConfigType(cf.getConfigType());
            ncf.setConfigValue(cf.getConfigValue());
            ncf.setCreateDate(cf.getCreateDate());
            ncf.setExtConfigValue(cf.getExtConfigValue());
            ncf.setModifyDate(cf.getModifyDate());
            ncf.setOrgAccountId(accountId);
            ncf.setSort(cf.getSort());
            this.configDao.save(ncf);
            temp.put(ncf.getId(), ncf);
            String key0 = configCategory + accountId;
            HashSet<Long> list = this.category2Config.get(key0);
            if (null == list) {
                list = new HashSet();
            }
            list.add(ncf.getId());
            this.category2Config.put(key0, list);
            String key = configCategory + ncf.getConfigItem() + accountId;
            this.categoryAndItem2Config.put(key, ncf.getId());
        }
        this.fConfigMap.putAll(temp);
    }

    @Override
    public String getConfigValue(String configCategory, String configItem) {
        ConfigItem item = this.getConfigItem(configCategory, configItem, 1L);
        if (item != null) {
            return item.getConfigValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSystemLocales() {
        StringBuilder sb = new StringBuilder();
        JDBCAgent agent = null;
        try {
            agent = new JDBCAgent(true);
            agent.execute("select config_value,config_type from ctp_config where 1=1 and config_category = 'system_locale' and config_item ='system_locale'");
            Map map = agent.resultSetToMap();
            boolean isInternationalVersion = AppContext.hasPlugin("international");
            if (map != null && map.size() > 0) {
                String configValue = (String)map.get("config_value");
                String configType = (String)map.get("config_type");
                List array = (List)JSONUtil.parseJSONString(configValue);
                if (array != null) {
                    for (int i = 0; i < array.size(); ++i) {
                        Map jsonObj = (Map)array.get(i);
                        if (null != jsonObj.get("stopped") && ((Boolean)jsonObj.get("stopped")).booleanValue()) continue;
                        Boolean isGov = (Boolean)SysFlag.sys_isGovVer.getFlag();
                        if ("0".equals(configType) && isInternationalVersion && !isGov.booleanValue()) {
                            LocaleContext.setSysDefaultLocale("en");
                        } else if (null != jsonObj.get("whetherDefault") && ((Boolean)jsonObj.get("whetherDefault")).booleanValue()) {
                            LocaleContext.setSysDefaultLocale(jsonObj.get("key").toString());
                        } else {
                            LocaleContext.setSysDefaultLocale("zh_CN");
                        }
                        if (i == 0) {
                            sb.append(jsonObj.get("key"));
                            continue;
                        }
                        sb.append("," + jsonObj.get("key"));
                    }
                }
            }
        }
        catch (BusinessException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            agent.close();
        }
        return sb.toString();
    }
}

