/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.config;

import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.config.PlatformConfigUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.data.redis.core.RedisTemplate;

public class PlatformDubboUtil {
    private static Log logger = CtpLogFactory.getLog(PlatformConfigUtil.class);
    private static RedisTemplate redisTemplate = RedisHandler.getDubboRedisTemplate();
    private static final long DUBBO_EXPIRE_TIME = 1800000L;

    public static void clearExpiredDubboService() {
        long currentTimeMillis = System.currentTimeMillis();
        try {
            Set endpointKey = redisTemplate.keys((Object)"/dubbo/com.seeyon.*");
            for (String mapKey : endpointKey) {
                Map keyValue = redisTemplate.opsForHash().entries((Object)mapKey);
                for (Map.Entry entry : keyValue.entrySet()) {
                    if (Long.parseLong((String)entry.getValue()) >= currentTimeMillis - 1800000L) continue;
                    redisTemplate.opsForHash().delete((Object)mapKey, new Object[]{entry.getKey()});
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u6e05\u7406Dubbo\u8fc7\u671f\u670d\u52a1\u6d88\u8d39\u65b9\u53ca\u63d0\u4f9b\u65b9\u6ce8\u518c\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

