/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.config;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.config.MessageChannel;
import com.seeyon.ctp.common.config.MessageListener;
import com.seeyon.ctp.common.config.PlatformAppEnum;
import com.seeyon.ctp.common.config.PlatformConfigItem;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.Path;
import org.apache.commons.logging.Log;
import org.springframework.data.redis.core.RedisTemplate;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class PlatformConfigUtil {
    private static Log logger = CtpLogFactory.getLog(PlatformConfigUtil.class);
    private static RedisTemplate redisTemplate = RedisHandler.getConfigRedisTemplate();
    private static RedisTemplate messageRedisTemplate = RedisHandler.getMessageRedisTemplate();
    private static Jedis messagePubJedis = null;
    private static Jedis messageSubJedis = null;
    private static JedisPubSub messagePubSub = null;
    private static ExecutorService messageSubExecutor = Executors.newSingleThreadExecutor();
    private static Map<MessageChannel, Set<MessageListener>> messagehandlers = new ConcurrentHashMap<MessageChannel, Set<MessageListener>>();
    private static String CONFIG_PREFIX = "Platform:Config";
    private static String APP_CONFIG_KEY = CONFIG_PREFIX + ":" + RedisHandler.APP_ID;
    private static String BASE_CONFIG_KEY = CONFIG_PREFIX + ":1";
    private static String CONFIG_DATA_KEY = "Data";
    private static String CONFIG_MODIFY_TIME_KEY = "ModifyTime";
    private static Set<Class<?>> restResourceClasses = new HashSet();
    private static final Map<String, String> url2ServiceNameMap = new ConcurrentHashMap<String, String>();

    public static void saveConfig(Map<String, List<PlatformConfigItem>> configItemMap) {
        if (configItemMap == null || configItemMap.size() == 0) {
            logger.error((Object)"\u53c2\u6570\u4e0d\u5408\u6cd5(configItemMap\u4e3a\u7a7a)");
            return;
        }
        for (Map.Entry<String, List<PlatformConfigItem>> entry : configItemMap.entrySet()) {
            redisTemplate.opsForHash().put((Object)(CONFIG_PREFIX + ":" + entry.getKey()), (Object)CONFIG_DATA_KEY, entry.getValue());
            redisTemplate.opsForHash().put((Object)(CONFIG_PREFIX + ":" + entry.getKey()), (Object)CONFIG_MODIFY_TIME_KEY, (Object)System.currentTimeMillis());
        }
    }

    public static boolean isNeedPublishConfig() {
        if (!SystemEnvironment.isDistributedMode()) {
            return false;
        }
        if (SystemEnvironment.isBaseService()) {
            return redisTemplate.opsForHash().get((Object)BASE_CONFIG_KEY, (Object)CONFIG_MODIFY_TIME_KEY) == null;
        }
        return redisTemplate.opsForHash().get((Object)APP_CONFIG_KEY, (Object)CONFIG_MODIFY_TIME_KEY) == null;
    }

    public static void publishConfig() {
        if (SystemEnvironment.isBaseService()) {
            logger.info((Object)"\u5f53\u524d\u662fBase\u670d\u52a1, \u63a8\u9001Base\u76f8\u5173\u7684\u7f3a\u7701\u914d\u7f6e");
        } else {
            logger.info((Object)("\u5f53\u524d\u662f[" + SystemEnvironment.getAppId() + "]\u670d\u52a1, \u63a8\u9001\u76f8\u5173\u7684\u7f3a\u7701\u914d\u7f6e"));
        }
        PlatformConfigUtil.reportLocalConfig();
    }

    public static Properties getAllProperties() {
        List configItems = (List)redisTemplate.opsForHash().get((Object)BASE_CONFIG_KEY, (Object)CONFIG_DATA_KEY);
        if (!SystemEnvironment.isBaseService()) {
            if ((Long)redisTemplate.opsForHash().get((Object)APP_CONFIG_KEY, (Object)CONFIG_MODIFY_TIME_KEY) < 0L) {
                logger.warn((Object)" ***** \u7ba1\u7406\u5458\u672a\u5bf9\u8be5\u5e94\u7528\u7684\u53c2\u6570\u8fdb\u884c\u76f8\u5e94\u914d\u7f6e\uff0c\u4f7f\u7528\u521d\u59cb\u9ed8\u8ba4\u914d\u7f6e ...");
            }
            configItems.addAll((List)redisTemplate.opsForHash().get((Object)APP_CONFIG_KEY, (Object)CONFIG_DATA_KEY));
        }
        return PlatformConfigUtil.convertToProperties(configItems);
    }

    public static List<PlatformConfigItem> getBaseConfig() {
        return (List)redisTemplate.opsForHash().get((Object)BASE_CONFIG_KEY, (Object)CONFIG_DATA_KEY);
    }

    public static List<PlatformConfigItem> getAppConfig() {
        if (SystemEnvironment.isBaseService()) {
            return null;
        }
        return (List)redisTemplate.opsForHash().get((Object)APP_CONFIG_KEY, (Object)CONFIG_DATA_KEY);
    }

    public static Map<String, List<PlatformConfigItem>> getAllPlatformConfig() {
        HashMap<String, List<PlatformConfigItem>> map = new HashMap<String, List<PlatformConfigItem>>();
        Set configKeys = redisTemplate.keys((Object)(CONFIG_PREFIX + ":*"));
        for (Object configKey : configKeys) {
            map.put(((String)configKey).replace(CONFIG_PREFIX + ":", ""), (List)redisTemplate.opsForHash().get(configKey, (Object)CONFIG_DATA_KEY));
        }
        return map;
    }

    public static String getServiceName() {
        return PlatformConfigUtil.getServiceName(Integer.parseInt(SystemEnvironment.getAppId()));
    }

    public static String getServiceName(int appId) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PlatformAppEnum appEnum : PlatformAppEnum.values()) {
            if ((appId & appEnum.getType()) <= 0) continue;
            stringBuilder.append("|");
            stringBuilder.append(appEnum.getServiceName());
        }
        return stringBuilder.substring(1);
    }

    public static void clearUrl2ServiceNameMap() {
        url2ServiceNameMap.clear();
    }

    public static void addUrlToServiceName(String url, String serviceName) {
        url2ServiceNameMap.put(url, serviceName);
    }

    public static String getServiceNameFromUrl(String url) {
        return url2ServiceNameMap.get(url);
    }

    public static String getSimpleServiceName(String appIdStr) {
        Integer appId = Integer.parseInt(appIdStr);
        if ((appId & PlatformAppEnum.Other.getType()) > 0) {
            return "\u5e94\u7528\u670d\u52a1(other)";
        }
        for (PlatformAppEnum appEnum : (PlatformAppEnum[])PlatformAppEnum.class.getEnumConstants()) {
            if ((appId & appEnum.getType()) <= 0) continue;
            return appEnum.getServiceName();
        }
        return "\u5e94\u7528\u670d\u52a1(other)";
    }

    public static Map<String, Set<String>> getServiceAddressInfo() {
        HashMap<String, Set<String>> addressMap = new HashMap<String, Set<String>>();
        try {
            Set addressKeySet = RedisHandler.getConfigRedisTemplate().keys((Object)"Platform:Address:*");
            for (String adressKey : addressKeySet) {
                addressMap.put(adressKey.replaceAll("Platform:Address:", ""), RedisHandler.getConfigRedisTemplate().opsForSet().members((Object)adressKey));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u670d\u52a1\u76d1\u542c\u5730\u5740\u914d\u7f6e\u53d1\u751f\u5f02\u5e38 ", (Throwable)e);
        }
        return addressMap;
    }

    public static Map<String, Set<String>> getUrlRoutingConfig() {
        HashMap<String, Set<String>> urlMap = new HashMap<String, Set<String>>();
        try {
            Set appUrlKeySet = RedisHandler.getConfigRedisTemplate().keys((Object)"Platform:Url:*");
            for (String urlKey : appUrlKeySet) {
                urlMap.put(urlKey.replaceAll("Platform:Url:", ""), RedisHandler.getConfigRedisTemplate().opsForSet().members((Object)urlKey));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6Url\u8def\u7531\u914d\u7f6e\u53d1\u751f\u5f02\u5e38 ", (Throwable)e);
        }
        return urlMap;
    }

    public static Map<String, Set<String>> getAjaxManagerNamesMap(String typePrefix) {
        HashMap<String, Set<String>> managerNameMap = new HashMap<String, Set<String>>();
        try {
            Set appUrlKeySet = RedisHandler.getConfigRedisTemplate().keys((Object)(typePrefix + "*"));
            for (String urlKey : appUrlKeySet) {
                managerNameMap.put(urlKey.replaceAll(typePrefix, ""), RedisHandler.getConfigRedisTemplate().opsForSet().members((Object)urlKey));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6Url\u8def\u7531\u914d\u7f6e\u53d1\u751f\u5f02\u5e38 ", (Throwable)e);
        }
        return managerNameMap;
    }

    public static void putRestResourceClasses(Set<Class<?>> resourceClasses) {
        restResourceClasses.addAll(resourceClasses);
    }

    public static Set<String> getRestResourceUrlSet() {
        HashSet<String> restUrlSet = new HashSet<String>();
        for (Class<?> clazz : restResourceClasses) {
            Path pathAnnotation = clazz.getAnnotation(Path.class);
            if (pathAnnotation == null) {
                logger.debug((Object)(clazz.getCanonicalName() + "\u6ca1\u6709Path\u6ce8\u89e3\uff0c\u81ea\u52a8\u8df3\u8fc7"));
                continue;
            }
            String restPath = pathAnnotation.value();
            restPath = restPath.replaceAll("\\\\?\\{\\S+", "").trim();
            restUrlSet.add("/rest" + (restPath.startsWith("/") ? "" : "/") + restPath);
        }
        return restUrlSet;
    }

    public static boolean isBaseService(String appId) {
        return (Integer.parseInt(appId) & PlatformAppEnum.Base.getType()) > 0;
    }

    public static boolean isReportService(String appId) {
        return (Integer.parseInt(appId) & PlatformAppEnum.Report.getType()) > 0;
    }

    public static boolean isCAPService(String appId) {
        return (Integer.parseInt(appId) & PlatformAppEnum.Cap.getType()) > 0;
    }

    public static boolean isOtherService(String appId) {
        return (Integer.parseInt(appId) & PlatformAppEnum.Other.getType()) > 0;
    }

    public static synchronized void sendMessage(MessageChannel channel, String message) {
        if (channel == null) {
            logger.warn((Object)"\u53c2\u6570\u9519\u8bef\uff0c channel\u4e0d\u5e94\u8be5\u4e3a\u7a7a\uff01");
            return;
        }
        if (messagePubJedis == null) {
            messagePubJedis = (Jedis)messageRedisTemplate.getConnectionFactory().getConnection().getNativeConnection();
        }
        messagePubJedis.publish(channel.name(), message);
    }

    public static synchronized void addMessageListener(MessageChannel channel, MessageListener listener) {
        if (messagehandlers.containsKey((Object)channel) && messagehandlers.get((Object)channel).contains(listener)) {
            logger.warn((Object)("\u901a\u9053[" + channel.name() + "]\u7684\u76d1\u542c\u5668[" + listener + "]\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u672c\u5730\u6ce8\u518c\uff01"));
            return;
        }
        Set<MessageListener> listeners = messagehandlers.get((Object)channel);
        if (listeners == null) {
            listeners = new HashSet<MessageListener>();
            messagehandlers.put(channel, listeners);
        }
        listeners.add(listener);
        if (messagePubSub != null) {
            messagePubSub.unsubscribe();
        } else {
            messagePubSub = new JedisPubSub(){

                public void onMessage(String channel, String message) {
                    try {
                        Set lsnSet;
                        MessageChannel mChannel = MessageChannel.valueOf(channel);
                        if (mChannel != null && (lsnSet = (Set)messagehandlers.get((Object)mChannel)) != null) {
                            for (MessageListener lsn : lsnSet) {
                                lsn.onMessage(message);
                            }
                        }
                    }
                    catch (Throwable t) {
                        logger.error((Object)"\u5904\u7406\u6d88\u606f\u51fa\u9519", t);
                    }
                }
            };
        }
        if (messageSubJedis == null) {
            messageSubJedis = (Jedis)messageRedisTemplate.getConnectionFactory().getConnection().getNativeConnection();
        }
        messageSubExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String[] channels = new String[messagehandlers.size()];
                int i = 0;
                for (MessageChannel messageChannel : messagehandlers.keySet()) {
                    channels[i++] = messageChannel.name();
                }
                messageSubJedis.subscribe(messagePubSub, channels);
            }
        });
    }

    private static void reportLocalConfig() {
        List<PlatformConfigItem> configItems = PlatformConfigUtil.generateConfigItems();
        if (SystemEnvironment.isBaseService()) {
            redisTemplate.opsForHash().put((Object)BASE_CONFIG_KEY, (Object)CONFIG_DATA_KEY, configItems);
            redisTemplate.opsForHash().put((Object)BASE_CONFIG_KEY, (Object)CONFIG_MODIFY_TIME_KEY, (Object)-1L);
        } else {
            redisTemplate.opsForHash().put((Object)APP_CONFIG_KEY, (Object)CONFIG_DATA_KEY, configItems);
            redisTemplate.opsForHash().put((Object)APP_CONFIG_KEY, (Object)CONFIG_MODIFY_TIME_KEY, (Object)-1L);
        }
    }

    private static List<PlatformConfigItem> generateConfigItems() {
        boolean isBase = SystemEnvironment.isBaseService();
        Properties allProperties = SystemProperties.getInstance().getAllProperties();
        Properties tmpProps = new Properties();
        tmpProps.putAll((Map<?, ?>)allProperties);
        if (!SystemEnvironment.isBaseService()) {
            List<PlatformConfigItem> baseConfigItems = PlatformConfigUtil.getBaseConfig();
            for (PlatformConfigItem configItem : baseConfigItems) {
                tmpProps.remove(configItem.getKey());
                tmpProps.remove(configItem.getKey() + ".mark");
                tmpProps.remove(configItem.getKey() + ".desc");
            }
        }
        ArrayList<PlatformConfigItem> configItems = new ArrayList<PlatformConfigItem>();
        for (Object key : tmpProps.keySet()) {
            String propKey;
            String keyStr = (String)key;
            if (!keyStr.endsWith(".mark") || !tmpProps.containsKey((propKey = keyStr.substring(0, keyStr.length() - 5)) + ".desc")) continue;
            PlatformConfigItem item = new PlatformConfigItem();
            item.setKey(propKey);
            item.setDefaultValue(tmpProps.getProperty(propKey));
            item.setMark(tmpProps.getProperty(keyStr));
            item.setDescription(tmpProps.getProperty(propKey + ".desc"));
            if (isBase) {
                item.setValue(item.getDefaultValue());
            }
            configItems.add(item);
        }
        return configItems;
    }

    private static Properties convertToProperties(List<PlatformConfigItem> configItems) {
        Properties p = new Properties();
        for (PlatformConfigItem configItem : configItems) {
            p.setProperty(configItem.getKey(), Strings.isEmpty(configItem.getValue()) ? configItem.getDefaultValue() : configItem.getValue());
        }
        return p;
    }
}

