/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.config;

import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.config.AppUrlReport;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.Set;
import org.apache.commons.logging.Log;

public class AppUrlReportImpl
implements AppUrlReport {
    private static final Log logger = CtpLogFactory.getLog(AppUrlReportImpl.class);

    @Override
    public boolean reportAppUrls(String appId, Set<String> urlSetting) {
        if (urlSetting == null || urlSetting.size() == 0) {
            return true;
        }
        try {
            if ((Integer.parseInt(appId) & 1) == 0) {
                String baseAppId = this.getBaseAppId();
                Set baseUrlSet = RedisHandler.getConfigRedisTemplate().opsForSet().members((Object)("Platform:Url:" + baseAppId));
                urlSetting.removeAll(baseUrlSet);
                if (urlSetting.size() == 0) {
                    return true;
                }
            }
            RedisHandler.getConfigRedisTemplate().opsForSet().add((Object)("Platform:Url:" + appId), urlSetting.toArray());
        }
        catch (Exception e) {
            logger.error((Object)("\u8bbe\u7f6e\u5e94\u7528[" + appId + "] urlMapping\u4fe1\u606f\u53d1\u751f\u5f02\u5e38 "), (Throwable)e);
            return false;
        }
        return true;
    }

    private String getBaseAppId() {
        String baseAppId = "1";
        Set keys = RedisHandler.getConfigRedisTemplate().keys((Object)"Platform:Url:*");
        for (String key : keys) {
            String appId = key.substring(key.lastIndexOf(":") + 1);
            if ((Integer.parseInt(appId) & 1) <= 0) continue;
            return appId;
        }
        return baseAppId;
    }

    @Override
    public boolean reportAjaxDoManagerNamess(String appId, Set<String> managerNames) {
        if (managerNames == null || managerNames.size() == 0) {
            return true;
        }
        try {
            if ((Integer.parseInt(appId) & 1) == 0) {
                Set baseManagerNames = RedisHandler.getConfigRedisTemplate().opsForSet().members((Object)("Platform:Ajax:Do:Manager:" + this.getBaseAppId()));
                managerNames.removeAll(baseManagerNames);
                if (managerNames.size() == 0) {
                    return true;
                }
            }
            RedisHandler.getConfigRedisTemplate().opsForSet().add((Object)("Platform:Ajax:Do:Manager:" + appId), managerNames.toArray());
        }
        catch (Exception e) {
            logger.error((Object)("\u8bbe\u7f6e\u5e94\u7528[" + appId + "] urlMapping\u4fe1\u606f\u53d1\u751f\u5f02\u5e38 "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean reportAjaxServletManagerNamess(String appId, Set<String> managerNames) {
        if (managerNames == null || managerNames.size() == 0) {
            return true;
        }
        try {
            if ((Integer.parseInt(appId) & 1) == 0) {
                Set baseManagerNames = RedisHandler.getConfigRedisTemplate().opsForSet().members((Object)("Platform:Ajax:Servlet:Manager:" + this.getBaseAppId()));
                managerNames.removeAll(baseManagerNames);
                if (managerNames.size() == 0) {
                    return true;
                }
            }
            RedisHandler.getConfigRedisTemplate().opsForSet().add((Object)("Platform:Ajax:Servlet:Manager:" + appId), managerNames.toArray());
        }
        catch (Exception e) {
            logger.error((Object)("\u8bbe\u7f6e\u5e94\u7528[" + appId + "] urlMapping\u4fe1\u606f\u53d1\u751f\u5f02\u5e38 "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean reportServiceAddress(String appId, String host, int port) {
        try {
            RedisHandler.getConfigRedisTemplate().opsForSet().add((Object)("Platform:Address:" + appId), new Object[]{host + ":" + port});
        }
        catch (Exception e) {
            logger.error((Object)("\u8bbe\u7f6e\u5e94\u7528[" + appId + "] \u670d\u52a1\u5730\u5740\u4fe1\u606f\u53d1\u751f\u5f02\u5e38 "), (Throwable)e);
            return false;
        }
        return true;
    }
}

