/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.code;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.code.KeyEnum;
import com.seeyon.ctp.common.code.KeyEnumForString;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class EnumsConfigLoader {
    private static Log LOGGER = CtpLogFactory.getLog(EnumsConfigLoader.class);
    private static final Map enumCachMap = new HashMap();
    private static String enumJSON;

    public static void init() {
        String sysConfig = AppContext.getSystemProperty(SystemProperties.CONFIG_ENUM_EXPORT);
        if (sysConfig != null) {
            String[] inits;
            for (String c : inits = sysConfig.split("\\|")) {
                if (!Strings.isNotBlank(c)) continue;
                try {
                    Enum[] enums;
                    Class<?> clz = Class.forName(c);
                    if (!clz.isEnum() || !KeyEnum.class.isAssignableFrom(clz) && !KeyEnumForString.class.isAssignableFrom(clz)) continue;
                    HashMap<String, Object> eMap = new HashMap<String, Object>();
                    String nm = clz.getName();
                    enumCachMap.put(nm.substring(nm.lastIndexOf(46) + 1), eMap);
                    for (Enum em : enums = (Enum[])clz.getEnumConstants()) {
                        Object keyEnum;
                        if (KeyEnum.class.isAssignableFrom(clz)) {
                            keyEnum = (KeyEnum)((Object)em);
                            eMap.put(em.name(), keyEnum.getKey());
                            continue;
                        }
                        if (!KeyEnumForString.class.isAssignableFrom(clz)) continue;
                        keyEnum = (KeyEnumForString)((Object)em);
                        eMap.put(em.name(), keyEnum.getKeyString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        enumJSON = JSONUtil.toJSONString(enumCachMap);
    }

    public static Map getEnumCachMap() {
        return enumCachMap;
    }

    public static String getEnumJSON() {
        return enumJSON;
    }
}

