/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.redis;

import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.cache.CacheStatistics;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import java.io.Serializable;

public class RedisCacheObject<E extends Serializable>
implements CacheObject<E> {
    private CacheObject<E> origin = null;
    private boolean distributed;

    public RedisCacheObject(CacheObject<E> origin, CacheConfiguration.CacheScope scope) {
        this.origin = origin;
        RedisHandler.initializeIfNecessary();
        this.distributed = CacheConfiguration.CacheScope.Global.equals((Object)scope);
        this.initDataIfNeed();
    }

    private void initDataIfNeed() {
        if (RedisHandler.isRedisEnabled() && RedisHandler.isReadOnly(this.getGroup())) {
            RedisHandler.initCacheFromRedis(this);
        }
    }

    @Override
    public void set(E o) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.origin.set(o);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.setObject(this.origin.getGroup(), this.origin.getName(), o);
        }
    }

    @Override
    public E get() {
        return this.origin.get();
    }

    @Override
    public void notifyUpdate() {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.set(this.get());
    }

    @Override
    public String getGroup() {
        return this.origin.getGroup();
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public int size() {
        return this.origin.size();
    }

    @Override
    public boolean isEmpty() {
        return this.origin.isEmpty();
    }

    @Override
    public void clear() {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.origin.clear();
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.clearObject(this.origin.getGroup(), this.origin.getName());
        }
    }

    @Override
    public CacheStatistics getStatistics() {
        return this.origin.getStatistics();
    }

    @Override
    public void loadFromCacheCenter() {
        RedisHandler.initCacheFromRedis(this);
    }
}

