/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.geode;

import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.MapIndex;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.cache.geode.AbstractGeodeCache;
import com.seeyon.ctp.common.cache.geode.GeodeService;
import com.seeyon.ctp.common.cache.geode.LinkedCacheMapChange;
import com.seeyon.ctp.common.cache.loader.DataLoader;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinkedCacheMap<K extends Serializable, V extends Serializable>
extends AbstractGeodeCache
implements CacheMap<K, V> {
    private static final Log log = LogFactory.getLog(LinkedCacheMap.class);
    private String group;
    private String cacheName;
    private LinkedHashMap<K, V> originMap;
    private boolean needNotify;
    private DataLoader<K> loader;

    public LinkedCacheMap(String group, String cacheName, LinkedHashMap<K, V> originMap) {
        this.group = group;
        this.cacheName = cacheName;
        this.originMap = originMap;
        this.needNotify = true;
    }

    public void setNeedNotify(boolean needNotify) {
        this.needNotify = needNotify;
    }

    @Override
    public void put(K key, V value) {
        this.statistics.write();
        this.originMap.put(key, value);
        if (this.needNotify) {
            GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, (Serializable)key, CacheNotification.Action.Put, value));
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.statistics.write();
        this.originMap.putAll(map);
        if (this.needNotify) {
            GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, null, CacheNotification.Action.PutAll, map));
        }
    }

    @Override
    public void replaceAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return;
        }
        this.statistics.write();
        this.originMap.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.originMap.put((Serializable)entry.getKey(), (Serializable)entry.getValue());
        }
        if (this.needNotify) {
            GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, null, CacheNotification.Action.ReplaceAll, map));
        }
    }

    @Override
    public void notifyUpdate(K key) {
        if (key == null) {
            return;
        }
        this.statistics.write();
        GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, (Serializable)key, CacheNotification.Action.Put, this.originMap.get(key)));
    }

    @Override
    public void notifyUpdate(K[] keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        this.statistics.write();
        HashMap<K, V> map = new HashMap<K, V>();
        for (K key : keys) {
            map.put(key, this.originMap.get(key));
        }
        GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, null, CacheNotification.Action.PutAll, map));
    }

    @Override
    public void notifyUpdate(Collection<K> keys) {
        if (keys == null || keys.size() == 0) {
            return;
        }
        this.statistics.write();
        HashMap<Serializable, V> map = new HashMap<Serializable, V>();
        for (Serializable key : keys) {
            map.put(key, this.originMap.get(key));
        }
        GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, null, CacheNotification.Action.PutAll, map));
    }

    @Override
    public void notifyUpdate(K key, Serializable mapKey, CacheNotification.Action operation, Serializable content) {
        if (key == null) {
            return;
        }
        this.statistics.write();
        GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, mapKey, operation, content));
    }

    @Override
    public V get(K key) {
        if (key == null) {
            return null;
        }
        this.statistics.read();
        Serializable r = (Serializable)this.originMap.get(key);
        if (r == null) {
            this.statistics.misses();
        }
        return (V)r;
    }

    @Override
    public V remove(K key) {
        if (key == null) {
            return null;
        }
        this.statistics.delete();
        Serializable rtn = (Serializable)this.originMap.remove(key);
        if (this.needNotify) {
            GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, (Serializable)key, CacheNotification.Action.Remove, null));
        }
        return (V)rtn;
    }

    @Override
    public boolean removeAll(Collection<K> keys) {
        for (Serializable key : keys) {
            this.originMap.remove(key);
        }
        this.statistics.delete();
        if (this.needNotify) {
            GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, null, CacheNotification.Action.RemoveAll, keys));
        }
        return true;
    }

    @Override
    public boolean contains(K key) {
        this.statistics.read();
        return this.originMap.containsKey(key);
    }

    @Override
    public Map<K, V> toMap() {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : this.originMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Set<K> keySet() {
        this.statistics.read();
        return this.originMap.keySet();
    }

    @Override
    public Collection<V> values() {
        this.statistics.read();
        return this.originMap.values();
    }

    @Override
    public void setDataLoader(DataLoader<K> loader) {
        this.loader = loader;
    }

    @Override
    public DataLoader<K> getDataLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (this.loader != null) {
            LinkedCacheMap linkedCacheMap = this;
            synchronized (linkedCacheMap) {
                this.loader.load();
            }
        } else {
            log.error((Object)"\u7f13\u5b58\u6ca1\u6709\u8bbe\u7f6eDataLoader\uff0c\u4e0d\u80fdreload\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u4ee3\u7801\u3002");
        }
    }

    @Override
    public void reload(K k) {
        if (this.loader != null) {
            this.loader.load(k);
        } else {
            log.error((Object)"\u7f13\u5b58\u6ca1\u6709\u8bbe\u7f6eDataLoader\uff0c\u4e0d\u80fdload\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u4ee3\u7801\u3002");
        }
    }

    @Override
    public void index(MapIndex<V> idx) {
    }

    @Override
    public Collection<V> values(String indexName, Object o) {
        return Collections.emptyList();
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public int size() {
        return this.originMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.originMap.isEmpty();
    }

    @Override
    public void clear() {
        this.originMap.clear();
        this.statistics.clear();
        if (this.needNotify) {
            GeodeService.getLinkedCacheMapRegion().put((Object)this.group, (Object)new LinkedCacheMapChange(this.cacheName, null, CacheNotification.Action.Clear, null));
        }
    }
}

