/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.geode;

import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheMapChange;
import com.seeyon.ctp.common.cache.MapIndex;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.cache.geode.AbstractGeodeCache;
import com.seeyon.ctp.common.cache.geode.GeodeEventHandler;
import com.seeyon.ctp.common.cache.geode.GeodeService;
import com.seeyon.ctp.common.cache.loader.DataLoader;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.Region;

public class GeodeCacheMap<K extends Serializable, V extends Serializable>
extends AbstractGeodeCache
implements CacheMap<K, V> {
    private static final Log log = LogFactory.getLog(GeodeCacheMap.class);
    private Region<K, V> region;
    private DataLoader<K> loader;

    public GeodeCacheMap(Region<K, V> region) {
        this.region = region;
    }

    public void setRegion(Region<K, V> region) {
        this.region = region;
    }

    @Override
    public void put(K key, V value) {
        if (value != null) {
            this.region.put(key, value);
            this.statistics.write();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.region.putAll(map);
        this.statistics.write();
    }

    @Override
    public void replaceAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.region.replace(entry.getKey(), entry.getValue());
        }
        this.statistics.write();
    }

    @Override
    public void notifyUpdate(K key) {
        this.region.put(key, this.region.get(key));
        this.statistics.write();
    }

    @Override
    public void notifyUpdate(K[] keys) {
        HashMap<K, Object> map = new HashMap<K, Object>();
        for (K key : keys) {
            map.put(key, this.region.get(key));
        }
        this.region.putAll(map);
        this.statistics.write();
    }

    @Override
    public void notifyUpdate(Collection<K> keys) {
        HashMap<Serializable, Object> map = new HashMap<Serializable, Object>();
        for (Serializable key : keys) {
            map.put(key, this.region.get((Object)key));
        }
        this.region.putAll(map);
        this.statistics.write();
    }

    @Override
    public void notifyUpdate(Serializable key, Serializable updateKey, CacheNotification.Action operation, Serializable content) {
        if (key == null || updateKey == null) {
            return;
        }
        Object dataCache = this.region.get((Object)key);
        if (dataCache instanceof Map) {
            CacheMapChange mapChange = new CacheMapChange(this.getName(), key, updateKey, operation, content);
            GeodeService.getCacheNotifyRegion().put((Object)this.getGroup(), (Object)mapChange);
            this.statistics.write();
        }
    }

    @Override
    public V get(K key) {
        Serializable result;
        this.statistics.read();
        if (key == null) {
            return null;
        }
        Region.Entry entry = this.region.getEntry(key);
        Serializable serializable = result = entry == null ? null : (Serializable)entry.getValue();
        if (result == null) {
            this.statistics.misses();
        }
        return (V)result;
    }

    @Override
    public V remove(K key) {
        if (key == null) {
            return null;
        }
        this.statistics.delete();
        return (V)((Serializable)this.region.remove(key));
    }

    @Override
    public boolean removeAll(Collection<K> keys) {
        try {
            this.region.removeAll(keys);
        }
        catch (Exception e) {
            return false;
        }
        this.statistics.delete();
        return true;
    }

    @Override
    public boolean contains(K key) {
        return this.region.containsKey(key);
    }

    @Override
    public Map<K, V> toMap() {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : this.region.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Set<K> keySet() {
        return this.region.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.region.values();
    }

    @Override
    public void setDataLoader(DataLoader<K> loader) {
        this.loader = loader;
    }

    @Override
    public DataLoader<K> getDataLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (this.loader != null) {
            GeodeCacheMap geodeCacheMap = this;
            synchronized (geodeCacheMap) {
                this.loader.load();
                if (GeodeEventHandler.canDispatch()) {
                    CacheMapChange mapChange = new CacheMapChange(this.getName(), null, null, CacheNotification.Action.Reload, null);
                    GeodeService.getCacheNotifyRegion().put((Object)this.getGroup(), (Object)mapChange);
                }
            }
        } else {
            log.error((Object)"\u7f13\u5b58\u6ca1\u6709\u8bbe\u7f6eDataLoader\uff0c\u4e0d\u80fdreload\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u4ee3\u7801\u3002");
        }
    }

    @Override
    public void reload(K k) {
        if (this.loader != null) {
            this.loader.load(k);
            if (GeodeEventHandler.canDispatch()) {
                CacheMapChange mapChange = new CacheMapChange(this.getName(), (Serializable)k, null, CacheNotification.Action.Reload, null);
                GeodeService.getCacheNotifyRegion().put((Object)this.getGroup(), (Object)mapChange);
            }
        } else {
            log.error((Object)"\u7f13\u5b58\u6ca1\u6709\u8bbe\u7f6eDataLoader\uff0c\u4e0d\u80fdload\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u4ee3\u7801\u3002");
        }
    }

    @Override
    public void index(MapIndex<V> idx) {
    }

    @Override
    public Collection<V> values(String indexName, Object o) {
        return null;
    }

    @Override
    public String getGroup() {
        return this.region.getParentRegion().getName();
    }

    @Override
    public String getName() {
        return this.region.getName();
    }

    @Override
    public int size() {
        return this.region.size();
    }

    @Override
    public boolean isEmpty() {
        return this.region.isEmpty();
    }

    @Override
    public void clear() {
        if (this.region.isEmpty()) {
            return;
        }
        this.region.clear();
        this.statistics.clear();
    }

    public Region getRegion() {
        return this.region;
    }
}

