/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.geode;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.cache.GroupCacheable;
import com.seeyon.ctp.common.cache.TimeRing;
import com.seeyon.ctp.common.cache.geode.AbstractGeodeCache;
import com.seeyon.ctp.common.cache.geode.GeodeCacheMap;
import com.seeyon.ctp.common.cache.geode.GeodeCacheObject;
import com.seeyon.ctp.common.cache.geode.GeodeCacheSet;
import com.seeyon.ctp.common.cache.geode.GeodeService;
import com.seeyon.ctp.common.cache.geode.LRUCacheMap;
import com.seeyon.ctp.common.cache.geode.LinkedCacheMap;
import com.seeyon.ctp.util.LRUMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.Region;

public class GeodeCacheAccessable
implements CacheAccessable {
    private Region region;
    private Map<String, GeodeCacheMap> cacheMapPool;
    private Map<String, GeodeCacheSet> cacheSetPool;
    private Map<String, GeodeCacheObject> cacheObjectPool;
    private Map<String, LinkedCacheMap> linkedCacheMapPool;
    private Map<String, LRUCacheMap> lruCacheMapPool;
    private static boolean cacheNotify = false;
    private GeodeCacheMap objectMap;
    static final String OBJECT_REGION_NAME = "OBJECT_REGION_NAME";

    GeodeCacheAccessable(Region region) {
        this.region = region;
        this.cacheMapPool = new ConcurrentHashMap<String, GeodeCacheMap>();
        this.cacheSetPool = new ConcurrentHashMap<String, GeodeCacheSet>();
        this.cacheObjectPool = new ConcurrentHashMap<String, GeodeCacheObject>();
        this.linkedCacheMapPool = new ConcurrentHashMap<String, LinkedCacheMap>();
        this.lruCacheMapPool = new ConcurrentHashMap<String, LRUCacheMap>();
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public Set<String> mapKeySet() {
        return this.cacheMapPool != null ? this.cacheMapPool.keySet() : Collections.emptySet();
    }

    public Set<String> setKeySet() {
        return this.cacheSetPool != null ? this.cacheSetPool.keySet() : Collections.emptySet();
    }

    public Set<String> objectKeySet() {
        return this.cacheObjectPool != null ? this.cacheObjectPool.keySet() : Collections.emptySet();
    }

    public GeodeCacheMap getObjectMap() {
        return this.objectMap;
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> getMap(String cacheName) {
        CacheMap cacheMap = this.cacheMapPool.get(cacheName);
        return cacheMap != null ? cacheMap : (CacheMap)((Object)(this.linkedCacheMapPool.get(cacheName) != null ? (AbstractGeodeCache)this.linkedCacheMapPool.get(cacheName) : (AbstractGeodeCache)this.lruCacheMapPool.get(cacheName)));
    }

    public <K extends Serializable, V extends Serializable> GeodeCacheMap<K, V> getGeodeMap(String cacheName) {
        return this.cacheMapPool.get(cacheName);
    }

    public <K extends Serializable, V extends Serializable> LinkedCacheMap<K, V> getLinkdedMap(String cacheName) {
        return this.linkedCacheMapPool.get(cacheName);
    }

    public <K extends Serializable, V extends Serializable> LRUCacheMap<K, V> getLRUMap(String cacheName) {
        return this.lruCacheMapPool.get(cacheName);
    }

    public <E extends Serializable> GeodeCacheSet<E> getSet(String cacheName) {
        return this.cacheSetPool.get(cacheName);
    }

    @Override
    public GroupCacheable lookup(String cacheName) {
        GroupCacheable cache = null;
        cache = this.cacheMapPool.get(cacheName);
        if (cache == null) {
            cache = this.linkedCacheMapPool.get(cacheName);
        }
        if (cache == null) {
            cache = this.cacheSetPool.get(cacheName);
        }
        if (cache == null) {
            cache = this.cacheObjectPool.get(cacheName);
        }
        if (cache == null) {
            cache = this.lruCacheMapPool.get(cacheName);
        }
        return cache;
    }

    @Override
    public boolean isExist(String cacheName) {
        return this.cacheMapPool.containsKey(cacheName) || this.linkedCacheMapPool.containsKey(cacheName) || this.lruCacheMapPool.containsKey(cacheName);
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> createMap(String cacheName) {
        if (!this.cacheMapPool.containsKey(cacheName)) {
            this.cacheMapPool.put(cacheName, new GeodeCacheMap(GeodeService.getRegionFactory().createSubregion(this.region, cacheName)));
        }
        return this.cacheMapPool.get(cacheName);
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> createMap(String cacheName, CacheConfiguration config) {
        if (config == null || config.getScope().equals((Object)CacheConfiguration.CacheScope.Global)) {
            return this.createMap(cacheName);
        }
        return this.createLocalMap(cacheName);
    }

    private <K extends Serializable, V extends Serializable> CacheMap<K, V> createLocalMap(String cacheName) {
        if (!this.cacheMapPool.containsKey(cacheName)) {
            this.cacheMapPool.put(cacheName, new GeodeCacheMap(GeodeService.getLocalRegionFactory().createSubregion(this.region, cacheName)));
        }
        return this.cacheMapPool.get(cacheName);
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> createLinkedMap(String cacheName) {
        if (!this.linkedCacheMapPool.containsKey(cacheName)) {
            LinkedCacheMap linkedCacheMap = new LinkedCacheMap(this.region.getName(), cacheName, new LinkedHashMap());
            linkedCacheMap.setNeedNotify(cacheNotify);
            this.linkedCacheMapPool.put(cacheName, linkedCacheMap);
        }
        return this.linkedCacheMapPool.get(cacheName);
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> createLRUMap(String cacheName) {
        if (!this.lruCacheMapPool.containsKey(cacheName)) {
            LRUCacheMap lruCacheMap = new LRUCacheMap(this.region.getName(), cacheName, new LRUMap(50000));
            lruCacheMap.setNeedNotify(cacheNotify);
            this.lruCacheMapPool.put(cacheName, lruCacheMap);
        }
        return this.lruCacheMapPool.get(cacheName);
    }

    @Override
    public <E extends Serializable> CacheSet<E> createSet(String cacheName) {
        if (!this.cacheSetPool.containsKey(cacheName)) {
            this.cacheSetPool.put(cacheName, new GeodeCacheSet(GeodeService.getRegionFactory().createSubregion(this.region, cacheName)));
        }
        return this.cacheSetPool.get(cacheName);
    }

    public <E extends Serializable> GeodeCacheObject<E> getObject(String cacheName) {
        return this.cacheObjectPool.get(cacheName);
    }

    @Override
    public <E extends Serializable> CacheObject<E> createObject(String cacheName) {
        if (!this.cacheObjectPool.containsKey(cacheName)) {
            if (this.objectMap == null) {
                this.objectMap = new GeodeCacheMap(GeodeService.getRegionFactory().createSubregion(this.region, OBJECT_REGION_NAME));
            }
            this.cacheObjectPool.put(cacheName, new GeodeCacheObject(this.objectMap, this.region.getName(), cacheName));
        }
        return this.cacheObjectPool.get(cacheName);
    }

    @Override
    public <E extends Serializable> TimeRing<E> createTimeRing(String cacheName) {
        return null;
    }

    @Override
    public String[] getCacheNames() {
        HashSet<String> cacheNameSet = new HashSet<String>();
        cacheNameSet.addAll(this.cacheMapPool.keySet());
        cacheNameSet.addAll(this.cacheSetPool.keySet());
        cacheNameSet.addAll(this.linkedCacheMapPool.keySet());
        cacheNameSet.addAll(this.lruCacheMapPool.keySet());
        Object[] result = new String[cacheNameSet.size()];
        result = cacheNameSet.toArray(result);
        Arrays.sort(result);
        return result;
    }

    public void enableLinkedCacheMapNotify() {
        cacheNotify = true;
        if (this.linkedCacheMapPool == null) {
            return;
        }
        for (Map.Entry<String, LinkedCacheMap> cacheMapEntry : this.linkedCacheMapPool.entrySet()) {
            cacheMapEntry.getValue().setNeedNotify(true);
        }
    }

    public void enableLRUCacheMapNotify() {
        cacheNotify = true;
        if (this.lruCacheMapPool == null) {
            return;
        }
        for (Map.Entry<String, LRUCacheMap> cacheMapEntry : this.lruCacheMapPool.entrySet()) {
            cacheMapEntry.getValue().setNeedNotify(true);
        }
    }

    public void disableLinkedCacheMapNotify() {
        cacheNotify = false;
        if (this.linkedCacheMapPool == null) {
            return;
        }
        for (Map.Entry<String, LinkedCacheMap> cacheMapEntry : this.linkedCacheMapPool.entrySet()) {
            cacheMapEntry.getValue().setNeedNotify(false);
        }
    }

    public void disableLRUCacheMapNotify() {
        cacheNotify = false;
        if (this.lruCacheMapPool == null) {
            return;
        }
        for (Map.Entry<String, LRUCacheMap> cacheMapEntry : this.lruCacheMapPool.entrySet()) {
            cacheMapEntry.getValue().setNeedNotify(false);
        }
    }
}

