/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.cluster;

import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheMapChange;
import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.cache.GroupCacheable;
import com.seeyon.ctp.common.cache.NoSuchCacheException;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.annotation.HandleNotification;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;

public class CacheNotificationHandler {
    private static final Log log = CtpLogFactory.getLog(CacheNotificationHandler.class);
    private Queue<CacheNotification> queue = new ConcurrentLinkedQueue<CacheNotification>();

    @HandleNotification(type=NotificationType.CacheChanged)
    public void updateCache(Object o) {
        if (o instanceof CacheNotification) {
            CacheNotification notification = (CacheNotification)o;
            this.queue.offer(notification);
            if (CacheFactory.isClusterEnabled() || RedisHandler.isRedisEnabled()) {
                this.process();
            }
        }
    }

    private synchronized void process() {
        CacheNotification notification = null;
        do {
            try {
                notification = this.queue.poll();
                this.process(notification);
            }
            catch (Throwable e) {
                log.error((Object)e.getMessage(), e);
            }
        } while (notification != null);
    }

    private void process(CacheNotification notification) {
        if (notification == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handle cache notification " + notification));
        }
        String group = notification.getGroup();
        String cacheName = notification.getCacheName();
        try {
            Collection c;
            int size;
            GroupCacheable gCache;
            try {
                gCache = CacheFactory.getInstance(group).lookup(cacheName);
            }
            catch (NoSuchCacheException e) {
                log.warn((Object)("\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684Cache\uff1a" + group + ":" + cacheName));
                return;
            }
            if (gCache == null) {
                log.warn((Object)("\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684Cache\uff1a" + group + ":" + cacheName));
                return;
            }
            if (CacheNotification.Action.Clear.ordinal() == notification.getAction()) {
                gCache.clear();
                return;
            }
            if (gCache instanceof CacheMap) {
                this.updateMap(notification);
            } else if (gCache instanceof CacheSet) {
                if (RedisHandler.isRedisEnabled()) {
                    notification.setValue(notification.getKey());
                }
                this.updateSet(notification);
            } else if (gCache instanceof CacheObject) {
                if (RedisHandler.isRedisEnabled()) {
                    notification.setValue(notification.getKey());
                }
                this.updateObject(notification);
            } else {
                log.error((Object)("\u4e0d\u53ef\u8bc6\u522b\u7684\u7f13\u5b58\u7c7b\u578b\uff1a" + gCache.getClass().getCanonicalName()));
            }
            Serializable value = notification.getValue();
            if (value != null && value instanceof Collection && (size = (c = (Collection)((Object)value)).size()) > 20) {
                log.error((Object)("\u7f13\u5b58\u7ec4\u4ef6\u4f7f\u7528\u4e0d\u5f53\uff01" + group + "::" + cacheName + "\u53d1\u9001\u7684\u5b9e\u4f53\u592a\u5927\uff1a" + size));
            }
        }
        catch (Exception e) {
            log.error((Object)("\u66f4\u65b0Cache\u51fa\u9519\uff1a" + group + ":" + cacheName), (Throwable)e);
        }
    }

    private void updateMap(CacheNotification notification) {
        CacheMap map = (CacheMap)CacheFactory.getInstance(notification.getGroup()).lookup(notification.getCacheName());
        if (notification.isMapUpdate()) {
            this.processUpdateMap(map, (CacheMapChange)notification.getValue());
            return;
        }
        if (CacheNotification.Action.Put.ordinal() == notification.getAction()) {
            if (map.getDataLoader() == null) {
                if (RedisHandler.isRedisEnabled()) {
                    this.wrapNotification(notification);
                }
                map.put(notification.getKey(), notification.getValue());
            } else {
                map.reload(notification.getKey());
            }
        } else if (CacheNotification.Action.Remove.ordinal() == notification.getAction()) {
            map.remove(notification.getKey());
        } else if (CacheNotification.Action.RemoveAll.ordinal() == notification.getAction()) {
            map.removeAll((List)((Object)notification.getKey()));
        } else if (CacheNotification.Action.PutAll.ordinal() == notification.getAction()) {
            if (RedisHandler.isRedisEnabled()) {
                this.wrapNotification(notification);
            }
            map.putAll((Map)((Object)notification.getKey()));
        } else if (CacheNotification.Action.ReplaceAll.ordinal() == notification.getAction()) {
            if (RedisHandler.isRedisEnabled()) {
                this.wrapNotification(notification);
            }
            map.replaceAll((Map)((Object)notification.getKey()));
        } else if (CacheNotification.Action.Reload.ordinal() == notification.getAction()) {
            map.reload();
        } else if (CacheNotification.Action.ReloadKey.ordinal() == notification.getAction()) {
            map.reload(notification.getKey());
        } else {
            this.warnUnsupport(notification);
        }
    }

    private void wrapNotification(CacheNotification notification) {
        if (notification.getKey() != null) {
            notification.setValue((Serializable)RedisHandler.get(notification.getGroup(), notification.getCacheName(), notification.getKey()));
        } else {
            notification.setKey((Serializable)((Object)RedisHandler.getAll(notification.getGroup(), notification.getCacheName(), (Collection)((Object)notification.getValue()))));
        }
    }

    private void processUpdateMap(CacheMap map, CacheMapChange mapChange) {
        Map dataMap = (Map)map.get(mapChange.getKey());
        if (dataMap == null) {
            return;
        }
        switch (mapChange.getOperation()) {
            case Put: {
                dataMap.put(mapChange.getUpdateKey(), mapChange.getContent());
                break;
            }
            case PutAll: {
                dataMap.putAll((Map)mapChange.getContent());
                break;
            }
            case Remove: {
                dataMap.remove(mapChange.getUpdateKey());
                break;
            }
            case Clear: {
                dataMap.clear();
            }
        }
    }

    private void updateObject(CacheNotification notification) {
        CacheObject c = (CacheObject)CacheFactory.getInstance(notification.getGroup()).lookup(notification.getCacheName());
        if (CacheNotification.Action.Set.ordinal() == notification.getAction()) {
            c.set(notification.getValue());
        } else if (CacheNotification.Action.Clear.ordinal() == notification.getAction()) {
            c.clear();
        } else {
            this.warnUnsupport(notification);
        }
    }

    private void updateSet(CacheNotification notification) {
        CacheSet list = (CacheSet)CacheFactory.getInstance(notification.getGroup()).lookup(notification.getCacheName());
        int action = notification.getAction();
        if (CacheNotification.Action.Add.ordinal() == action) {
            list.add(notification.getValue());
        } else if (CacheNotification.Action.Remove.ordinal() == action) {
            list.remove(notification.getValue());
        } else if (CacheNotification.Action.AddAll.ordinal() == action) {
            list.addAll((Collection)((Object)notification.getValue()));
        } else if (CacheNotification.Action.ReplaceAll.ordinal() == action) {
            list.replaceAll((Collection)((Object)notification.getValue()));
        } else if (CacheNotification.Action.RemoveAll.ordinal() == action) {
            list.removeAll((Collection)((Object)notification.getValue()));
        } else {
            this.warnUnsupport(notification);
        }
    }

    private void warnUnsupport(CacheNotification notification) {
        log.warn((Object)("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\uff1a" + notification.getAction() + " " + notification.getGroup() + ":" + notification.getCacheName()));
    }
}

