/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.FileSynchronization;
import com.seeyon.ctp.common.cache.FileSynchronizationInput;
import com.seeyon.ctp.common.cache.loader.AbstractMapDataLoader;
import com.seeyon.ctp.common.cache.loader.DataLoader;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.springframework.util.FileCopyUtils;

public class FileSynchronizationImpl
implements FileSynchronization {
    private static final Log log = CtpLogFactory.getLog(FileSynchronizationImpl.class);
    private static final CacheAccessable cacheFactory = CacheFactory.getInstance(FileSynchronizationImpl.class);
    private CacheMap<String, String> cache;
    private static final boolean isCluster = NotificationManager.getInstance().isEnabled();
    private static final String SYNCFOLDER = SystemEnvironment.getSystemSyncFolder();
    private static final String APP_PATH = AppContext.getSystemProperty("ApplicationRoot") + File.separator;

    public void init() {
        if (!isCluster) {
            return;
        }
        this.cache = cacheFactory.createMap("FileSyncCache");
        this.cache.setDataLoader((DataLoader<String>)new AbstractMapDataLoader<String, String>(this.cache){

            @Override
            protected Map<String, String> loadLocal() {
                HashMap<String, String> fileCache = new HashMap<String, String>();
                Map<String, FileSynchronizationInput> fileSyncInputs = AppContext.getBeansOfType(FileSynchronizationInput.class);
                if (fileSyncInputs != null && fileSyncInputs.size() > 0) {
                    for (Map.Entry<String, FileSynchronizationInput> entry : fileSyncInputs.entrySet()) {
                        FileSynchronizationInput fileSyncInput = entry.getValue();
                        List<String> files = fileSyncInput.getSyncFileList();
                        if (!CollectionUtils.isNotEmpty(files)) continue;
                        for (String file : files) {
                            String fileName = FileSynchronizationImpl.this.getFileName(file);
                            String key = fileName + "|" + file;
                            fileCache.put(key, fileName);
                        }
                    }
                }
                return fileCache;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String loadLocal(String k) {
                String[] fileData = k.split("[|]");
                String fileName = fileData[0];
                String filePath = fileData[1];
                File tempFile = new File(SYNCFOLDER + File.separator + fileName);
                File targetFile = new File(APP_PATH + filePath.replaceAll("\\\\", "/"));
                if (tempFile.exists() && !targetFile.exists()) {
                    FileInputStream input = null;
                    OutputStream out = null;
                    try {
                        input = new FileInputStream(tempFile);
                        out = new FileOutputStream(targetFile);
                        FileCopyUtils.copy((InputStream)input, (OutputStream)out);
                        log.info((Object)("\u96c6\u7fa4\u56fe\u7247\u540c\u6b65\u6210\u529f,\u6e90\u6587\u4ef6:" + tempFile + " \t \u76ee\u6807\u6587\u4ef6\uff1a" + targetFile));
                    }
                    catch (Exception e) {
                        log.error((Object)("\u96c6\u7fa4\u56fe\u7247\u540c\u6b65\u5931\u8d25,\u6e90\u6587\u4ef6:" + tempFile + " \t \u76ee\u6807\u6587\u4ef6\uff1a" + targetFile), (Throwable)e);
                    }
                    finally {
                        try {
                            if (out != null) {
                                out.flush();
                            }
                            if (input != null) {
                                input.close();
                            }
                        }
                        catch (IOException e) {
                            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                } else {
                    log.info((Object)("\u96c6\u7fa4\u56fe\u7247\u540c\u6b65\u8bb0\u5f55,\u6e90\u6587\u4ef6:" + tempFile + " \t " + tempFile.exists() + " \u76ee\u6807\u6587\u4ef6\uff1a" + targetFile + " \t " + targetFile.exists()));
                }
                return fileName;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(InputStream input, String path) {
        if (!isCluster || input == null || Strings.isBlank(path)) {
            return;
        }
        String fileName = this.getFileName(path);
        OutputStream syncFile = null;
        try {
            syncFile = new FileOutputStream(SYNCFOLDER + File.separator + fileName);
            FileCopyUtils.copy((InputStream)input, (OutputStream)syncFile);
            String key = fileName + "|" + path;
            log.info((Object)("\u96c6\u7fa4\u56fe\u7247\u540c\u6b65\u7f13\u5b58\u7f6e\u5165\uff0ckey:" + key + " \t fileName\uff1a" + fileName));
            this.cache.put(key, fileName);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("\u96c6\u7fa4\u56fe\u7247\u540c\u6b65\u5931\u8d25,\t \u76ee\u6807\u6587\u4ef6\uff1a" + path), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("\u96c6\u7fa4\u56fe\u7247\u540c\u6b65\u5931\u8d25,\t \u76ee\u6807\u6587\u4ef6\uff1a" + path), (Throwable)e);
        }
        finally {
            try {
                if (syncFile != null) {
                    syncFile.flush();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private String getFileName(String path) {
        if (Strings.isEmpty(path)) {
            return "";
        }
        return path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf("."));
    }
}

