/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheEntry;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.cache.GenericCacheMap;
import com.seeyon.ctp.common.cache.GenericCacheObject;
import com.seeyon.ctp.common.cache.GenericCacheSet;
import com.seeyon.ctp.common.cache.GroupCacheable;
import com.seeyon.ctp.common.cache.NoSuchCacheException;
import com.seeyon.ctp.common.cache.geode.LRUCacheMap;
import com.seeyon.ctp.common.cache.redis.RedisCacheMap;
import com.seeyon.ctp.common.cache.redis.RedisCacheObject;
import com.seeyon.ctp.common.cache.redis.RedisCacheSet;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.cache.redis.RedisLinkedCacheMap;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.LRUMap;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public abstract class AbstractCacheFactory
implements CacheAccessable {
    private static Log log = CtpLogFactory.getLog(AbstractCacheFactory.class);
    protected final String group;
    protected CachePool pool;
    protected CacheConfiguration DEFAULT_CONFIG = new CacheConfiguration(CacheConfiguration.CacheScope.Global);

    protected AbstractCacheFactory(String group) {
        this.group = group;
    }

    @Override
    public GroupCacheable lookup(String cacheName) {
        GroupCacheable cache = this.pool.get(this.group, cacheName);
        if (cache == null) {
            throw new NoSuchCacheException(cacheName);
        }
        return cache;
    }

    @Override
    public boolean isExist(String cacheName) {
        GroupCacheable cache = this.pool.get(this.group, cacheName);
        return cache != null;
    }

    protected void register(String cacheName, GroupCacheable cache, CacheConfiguration config) {
        this.pool.register(this.group, cacheName, cache, config);
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> getMap(String cacheName) {
        return (CacheMap)this.lookup(cacheName);
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> createMap(String cacheName) {
        return this.createMap(cacheName, this.DEFAULT_CONFIG);
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> createMap(String cacheName, CacheConfiguration config) {
        return this.createMap(cacheName, config, new ConcurrentHashMap());
    }

    private <K extends Serializable, V extends Serializable> CacheMap<K, V> createMap(String cacheName, CacheConfiguration config, Map<K, CacheEntry<V>> map) {
        GroupCacheable c = this.pool.get(this.group, cacheName);
        if (c != null) {
            return (CacheMap)c;
        }
        CacheMap<K, V> cache = new GenericCacheMap<K, V>(this.group, cacheName, config, map);
        if (RedisHandler.isRedisEnabled()) {
            cache = map instanceof LinkedHashMap ? new RedisLinkedCacheMap<K, V>(cache, cache.getScope()) : new RedisCacheMap<K, V>(cache, cache.getScope());
        }
        this.register(cacheName, cache, config);
        return cache;
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> createLinkedMap(String cacheName) {
        LinkedHashMap map = new LinkedHashMap();
        return this.createMap(cacheName, this.DEFAULT_CONFIG, map);
    }

    @Override
    public <K extends Serializable, V extends Serializable> CacheMap<K, V> createLRUMap(String cacheName) {
        GroupCacheable c = this.pool.get(this.group, cacheName);
        if (c != null) {
            return (CacheMap)c;
        }
        LRUMap map = new LRUMap(50000);
        CacheMap cache = new LRUCacheMap(this.group, cacheName, map);
        if (RedisHandler.isRedisEnabled()) {
            cache = new RedisCacheMap(cache, this.DEFAULT_CONFIG.getScope());
        }
        this.register(cacheName, cache, this.DEFAULT_CONFIG);
        return cache;
    }

    @Override
    public <E extends Serializable> CacheObject<E> getObject(String cacheName) {
        return (CacheObject)this.lookup(cacheName);
    }

    @Override
    public <E extends Serializable> CacheObject<E> createObject(String cacheName) {
        GroupCacheable c = this.pool.get(this.group, cacheName);
        if (c != null) {
            return (CacheObject)c;
        }
        CacheObject cache = new GenericCacheObject(this.group, cacheName, this.DEFAULT_CONFIG);
        if (RedisHandler.isRedisEnabled()) {
            cache = new RedisCacheObject(cache, cache.getScope());
        }
        this.register(cacheName, cache, this.DEFAULT_CONFIG);
        return cache;
    }

    @Override
    public <E extends Serializable> CacheSet<E> createSet(String cacheName) {
        GroupCacheable c = this.pool.get(this.group, cacheName);
        if (c != null) {
            return (CacheSet)c;
        }
        CacheSet cache = new GenericCacheSet(this.group, cacheName, this.DEFAULT_CONFIG);
        if (RedisHandler.isRedisEnabled()) {
            cache = new RedisCacheSet(cache, cache.getScope());
        }
        this.register(cacheName, cache, this.DEFAULT_CONFIG);
        return cache;
    }

    @Override
    public <E extends Serializable> CacheSet<E> getSet(String cacheName) {
        return (CacheSet)this.lookup(cacheName);
    }

    public void clear() {
        this.pool.clear();
    }

    static abstract class CachePool {
        CachePool() {
        }

        protected String buildKey(String group, String cacheName) {
            return group + ":" + cacheName;
        }

        protected String[] parseKey(String key) {
            return key.split(":");
        }

        public void register(String group, String cacheName, GroupCacheable cache, CacheConfiguration config) {
            String key = this.buildKey(group, cacheName);
            if (this.contains(key)) {
                log.warn((Object)("cache already exist:" + key));
            }
            this.put(key, cache);
        }

        public GroupCacheable get(String group, String cacheName) {
            return this.get(this.buildKey(group, cacheName));
        }

        protected abstract GroupCacheable get(String var1);

        protected abstract boolean contains(String var1);

        protected abstract void put(String var1, GroupCacheable var2);

        public abstract String[] getCacheNames(String var1);

        public abstract void clear();
    }
}

