/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.authenticate.domain;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.customize.manager.CustomizeManager;
import com.seeyon.ctp.common.po.customize.CtpCustomize;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserCustomizeCache {
    private static transient CustomizeManager customizeManager;
    private static final String CUSTOMIZEJSONSTR = "customizeJsonStr";
    public static final String DEFAULT_SKIN_PATH = "default_skin_path";

    public static CustomizeManager getCustomizeManager() {
        if (customizeManager == null) {
            customizeManager = (CustomizeManager)AppContext.getBean("customizeManager");
        }
        return customizeManager;
    }

    public static void setCustomize(String key, String value) {
        UserCustomizeCache.getCustomizeManager().saveOrUpdateCustomize(AppContext.currentUserId(), key, value);
        UserCustomizeCache.getCurrentUser().setProperty(CUSTOMIZEJSONSTR, null);
    }

    public static String getCustomize(String key) {
        return UserCustomizeCache.getCustomizeManager().getCustomizeValue(AppContext.currentUserId(), key);
    }

    public static String getCustomizeJsonStr() {
        User currentUser = UserCustomizeCache.getCurrentUser();
        if (currentUser == null) {
            return null;
        }
        String customizeJsonStr = (String)currentUser.getProperty(CUSTOMIZEJSONSTR);
        List<CtpCustomize> customizes = UserCustomizeCache.getCustomizeManager().getCustomizeInfo(AppContext.currentUserId());
        if (customizeJsonStr == null && customizes != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (CtpCustomize cc : customizes) {
                map.put(cc.getCkey(), cc.getCvalue());
            }
            customizeJsonStr = JSONUtil.toJSONString(map);
            currentUser.setProperty(CUSTOMIZEJSONSTR, customizeJsonStr);
        }
        return customizeJsonStr;
    }

    public static String getCustomizeJsonStr(Set<String> keys) {
        User currentUser = UserCustomizeCache.getCurrentUser();
        if (currentUser == null) {
            return null;
        }
        List<CtpCustomize> customizes = UserCustomizeCache.getCustomizeManager().getCustomizeInfo(AppContext.currentUserId());
        if (!Strings.isEmpty(customizes)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (CtpCustomize cc : customizes) {
                String key = cc.getCkey();
                if (!keys.contains(key)) continue;
                map.put(key, cc.getCvalue());
            }
            return JSONUtil.toJSONString(map);
        }
        return "{}";
    }

    public static String getUserDefaultCssPath() {
        CtpCustomize customizes;
        User currentUser = UserCustomizeCache.getCurrentUser();
        if (currentUser == null) {
            return null;
        }
        String defaultSkinPath = (String)currentUser.getProperty(DEFAULT_SKIN_PATH);
        if (Strings.isBlank(defaultSkinPath) && null != (customizes = UserCustomizeCache.getCustomizeManager().getCustomizeInfo(currentUser.getId(), DEFAULT_SKIN_PATH))) {
            defaultSkinPath = customizes.getCvalue();
        }
        return defaultSkinPath;
    }

    public static void reloadCustomize(String key) {
        UserCustomizeCache.getCurrentUser().setProperty(CUSTOMIZEJSONSTR, null);
    }

    public static void setCustomizes(Map<String, String> customize1) {
        UserCustomizeCache.getCurrentUser().setProperty(CUSTOMIZEJSONSTR, null);
    }

    private static User getCurrentUser() {
        return AppContext.getCurrentUser();
    }
}

