/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.authenticate.domain;

import com.seeyon.ctp.util.InetUtil;
import java.io.Serializable;
import java.util.regex.Pattern;

public class IP
implements Serializable {
    private static final long serialVersionUID = 4482098802161034467L;
    private static final String re = "(\\\\d{1,2})";
    private String[] ps;

    public IP(String ip) {
        if (InetUtil.isIPv6Address(ip)) {
            this.ps = new String[1];
            this.ps[0] = ip;
        } else {
            this.ps = ip.split("[.]");
            if (this.ps == null || this.ps.length != 4) {
                throw new IllegalArgumentException("IP\u5730\u5740\u4e0d\u53ef\u7528: " + ip);
            }
        }
    }

    public boolean matching(String ip) {
        if (InetUtil.isIPv6Address(ip)) {
            String newIp = ip.replace(":0:0:0", ":");
            for (int i = 0; i < this.ps.length; ++i) {
                if (!this.ps[i].equals(newIp) && !this.ps[i].equals(ip)) continue;
                return true;
            }
            return false;
        }
        String[] _ps = ip.split("[.]");
        if (_ps == null || _ps.length != 4) {
            throw new IllegalArgumentException("IP\u5730\u5740\u4e0d\u53ef\u7528: " + ip);
        }
        for (int i = 0; i < 4; ++i) {
            if (this.matchingP(_ps[i], i)) continue;
            return false;
        }
        return true;
    }

    private boolean matchingP(String p, int index) {
        if ("*".equals(this.ps[index]) || p.equals(this.ps[index])) {
            return true;
        }
        String rep = this.ps[index].replaceAll("[*]", re);
        return Pattern.matches(rep, p);
    }
}

