/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.authenticate;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.constants.Constants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class LockLoginInfoFactory {
    private static final CacheAccessable cacheFactory = CacheFactory.getInstance(LockLoginInfoFactory.class);
    private CacheMap<String, LockLoginInfo> cache = cacheFactory.createMap("LockLoginCache");
    private static final int DEFAULT_LOGINSIGN = Constants.login_sign.pc.value();
    public static final String KEY_SEP = ":_:";
    private static Object mutex = new Object();
    private static LockLoginInfoFactory instance = new LockLoginInfoFactory();

    private LockLoginInfoFactory() {
    }

    public static LockLoginInfoFactory getInstance() {
        return instance;
    }

    @Deprecated
    public LockLoginInfo add(String loginName, String ip) {
        return this.add(loginName, DEFAULT_LOGINSIGN, ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockLoginInfo add(String loginName, int loginSign, String ip) {
        if (LockLoginInfoFactory.isBlank(loginName)) {
            return null;
        }
        String key = this.buildKey(loginName, loginSign);
        Object object = mutex;
        synchronized (object) {
            LockLoginInfo info = this.cache.get(key);
            if (info == null) {
                info = new LockLoginInfo(loginName, ip);
                info.setLoginSign(loginSign);
                this.cache.put(key, info);
            } else {
                info.update();
                this.cache.notifyUpdate(key);
            }
            return info;
        }
    }

    @Deprecated
    public LockLoginInfo get(String loginName) {
        return this.get(loginName, DEFAULT_LOGINSIGN);
    }

    public LockLoginInfo get(String loginName, int loginSign) {
        if (LockLoginInfoFactory.isBlank(loginName)) {
            return null;
        }
        return this.cache.get(this.buildKey(loginName, loginSign));
    }

    private String buildKey(String loginName, int loginSign) {
        return loginName + KEY_SEP + loginSign;
    }

    public void remove(String loginName) {
        Set<String> keys = this.cache.keySet();
        for (String key : keys) {
            if (!key.startsWith(loginName + KEY_SEP)) continue;
            this.cache.remove(key);
        }
    }

    public void remove(String loginName, int loginSign) {
        String key = this.buildKey(loginName, loginSign);
        if (!LockLoginInfoFactory.isBlank(key) && this.cache.contains(key)) {
            this.cache.remove(key);
        }
    }

    public List<LockLoginInfo> getAll() {
        return new ArrayList<LockLoginInfo>(this.cache.values());
    }

    private static boolean isBlank(String s) {
        return s == null || "".equals(s);
    }

    static /* synthetic */ int access$000() {
        return DEFAULT_LOGINSIGN;
    }

    public static class LockLoginInfo
    implements Serializable {
        private static final long serialVersionUID = 4991373421396910341L;
        private String loginName;
        private String ip;
        private long lockTime;
        private int count;
        private int loginSign = LockLoginInfoFactory.access$000();

        public int getLoginSign() {
            return this.loginSign;
        }

        public void setLoginSign(int loginSign) {
            this.loginSign = loginSign;
        }

        public LockLoginInfo(String loginName, String ip) {
            this.loginName = loginName;
            this.ip = ip;
            this.lockTime = System.currentTimeMillis();
            this.count = 1;
        }

        public String getIp() {
            return this.ip;
        }

        public long getLockTime() {
            return this.lockTime;
        }

        public Date getLockTimestamp() {
            return new Date(this.lockTime);
        }

        public String getLoginName() {
            return this.loginName;
        }

        public int getCount() {
            return this.count;
        }

        protected void update() {
            ++this.count;
            this.lockTime = System.currentTimeMillis();
        }
    }
}

