/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.aspect;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.aspect.AspectAnnotationAware;
import com.seeyon.ctp.common.aspect.AspectContext;
import com.seeyon.ctp.common.aspect.event.MethodInvokeEvent;
import com.seeyon.ctp.event.EventDispatcher;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.springframework.aop.framework.AopProxyUtils;

public class AspectManager {
    private static final Log LOG = LogFactory.getLog(AspectManager.class);
    private static String ASPECT_CONTEXT_KEY = "ASPECT_CONTEXT";

    @Deprecated
    public static String getSourceName(Object clazz, String methodName) {
        if (methodName == null) {
            return "";
        }
        return AspectManager.getSourceName(AopProxyUtils.ultimateTargetClass((Object)clazz), methodName);
    }

    public static String getSourceName(Class clazz, String methodName) {
        return AspectManager.getSourceName(clazz.getCanonicalName(), methodName);
    }

    public static String getSourceName(String className, String methodName) {
        return AspectManager.getKey(className, methodName);
    }

    @Deprecated
    public static void execute(Object clazz, String methodName) {
        if (methodName == null) {
            return;
        }
        if (AspectAnnotationAware.methods.contains(methodName)) {
            AspectManager.execute(AopProxyUtils.ultimateTargetClass((Object)clazz), methodName);
        }
    }

    public static void execute(Class clazz, String methodName) {
        AspectManager.execute(clazz.getCanonicalName(), methodName);
    }

    public static void execute(String className, String methodName) {
        String methodInvokeInfo = AspectManager.getKey(className, methodName);
        Collection<AspectAnnotationAware.ExecuteUnit> collection = AspectAnnotationAware.cache.get(methodInvokeInfo);
        if (collection != null) {
            for (AspectAnnotationAware.ExecuteUnit unit : collection) {
                try {
                    unit.execute();
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (SystemEnvironment.isDistributedMode() && AspectAnnotationAware.needPubMethodInvokes.contains(methodInvokeInfo)) {
            EventDispatcher.fireEvent(new MethodInvokeEvent(methodInvokeInfo, SystemEnvironment.getAppId()));
        }
    }

    private static String getKey(String className, String methodName) {
        return className + "." + methodName;
    }

    public static void execute(JoinPoint joinPoint) {
        AspectManager.execute(joinPoint.getTarget().getClass(), joinPoint.getSignature().getName());
    }

    @Deprecated
    public static boolean withParameters(Object clazz, String methodName) {
        if (methodName == null) {
            return false;
        }
        return AspectAnnotationAware.methods.contains(methodName) && AspectManager.withParameters(AopProxyUtils.ultimateTargetClass((Object)clazz), methodName);
    }

    public static boolean withParameters(Class clazz, String methodName) {
        String className = clazz.getCanonicalName();
        return AspectAnnotationAware.needParameterSet.contains(AspectManager.getKey(className, methodName));
    }

    public static void initContext(AspectContext contexct) {
        AppContext.putThreadContext(ASPECT_CONTEXT_KEY, contexct);
    }

    public static AspectContext getContext() {
        Object ctx = AppContext.getThreadContext(ASPECT_CONTEXT_KEY);
        return ctx == null ? null : (AspectContext)ctx;
    }
}

