/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster.notification;

import com.seeyon.ctp.cluster.notification.BatchNotification;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotificationTransactionManager {
    private static final Log LOG = LogFactory.getLog(NotificationTransactionManager.class);
    private static final NotificationTransactionManager INSTANCE = new NotificationTransactionManager();
    private static ThreadLocal<BatchNotification> queue = new ThreadLocal();

    private NotificationTransactionManager() {
    }

    public static final NotificationTransactionManager getInstance() {
        return INSTANCE;
    }

    public boolean hasTransaction() {
        return queue.get() != null;
    }

    public void addNotification(NotificationType type, Object content) {
        BatchNotification notification = queue.get();
        if (notification == null) {
            LOG.warn((Object)("\u5f53\u524d\u7ebf\u7a0b\u4e0d\u5b58\u5728\u96c6\u7fa4\u901a\u77e5\u4e8b\u52a1\uff0c\u5ffd\u7565add\u64cd\u4f5c\u3002" + (Object)((Object)type)));
            return;
        }
        notification.add(type, content);
    }

    public void beginTransaction() {
        if (!this.hasTransaction()) {
            queue.set(new BatchNotification());
        }
    }

    public void commit() {
        if (!this.hasTransaction()) {
            return;
        }
        BatchNotification notification = queue.get();
        queue.set(null);
        if (notification == null) {
            return;
        }
        int size = notification.size();
        if (size == 0) {
            return;
        }
        LOG.debug((Object)("commit batch notification:" + size));
        NotificationManager.getInstance().send(notification);
    }

    public void rollback() {
        queue.set(null);
    }

    public void removeThreadLocal() {
        if (this.hasTransaction()) {
            LOG.warn((Object)"\u5b58\u5728\u672a\u63d0\u4ea4\u7684\u901a\u77e5\u4e8b\u52a1\uff0c\u5f3a\u5236\u63d0\u4ea4\u3002\u4e8b\u52a1\u63d0\u4ea4\u903b\u8f91\u5b58\u5728\u7f3a\u9677\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\u3002");
            this.commit();
        }
        queue.remove();
    }
}

