/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.config.PropertiesLoader;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.DirectoryScanner;

class PropertiesReader {
    private static final Log LOG = CtpLogFactory.getLog(PropertiesReader.class);

    PropertiesReader() {
    }

    public static Set<String>[] readProperties() {
        String confFolder = AppContext.getCfgHome().getAbsolutePath();
        return PropertiesReader.readProperties(confFolder);
    }

    private static Set<String>[] readProperties(String cfgHome) {
        File propfile;
        int i;
        Set[] datas = new Set[2];
        HashSet<String> ves = new HashSet<String>();
        HashSet<String> vps = new HashSet<String>();
        datas[0] = ves;
        datas[1] = vps;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(cfgHome);
        ds.setIncludes(new String[]{"plugin/*/pluginProperties.properties", "component/*/pluginProperties.properties"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (i = 0; i < files.length; ++i) {
            propfile = new File(cfgHome + "/" + files[i]);
            Set<String>[] p = PropertiesReader.readProperties(propfile, "#M");
            LOG.debug((Object)("\u89e3\u6790\u914d\u7f6e\u6587\u4ef6" + propfile.getAbsolutePath()));
            ves.addAll(p[0]);
            vps.addAll(p[1]);
        }
        ds = new DirectoryScanner();
        ds.setBasedir(cfgHome);
        ds.setIncludes(new String[]{"base/systemProperties.xml", "plugin/*/pluginProperties.xml", "component/*/pluginProperties.xml"});
        ds.scan();
        files = ds.getIncludedFiles();
        for (i = 0; i < files.length; ++i) {
            propfile = new File(cfgHome + "/" + files[i]);
            Properties props = PropertiesLoader.load(propfile);
            for (Object o : props.keySet()) {
                String key = (String)o;
                String value = props.getProperty(key + ".mark");
                if (value == null) continue;
                if (value.contains("{VE}")) {
                    ves.add(key);
                    continue;
                }
                if (!value.contains("{VP}")) continue;
                vps.add(key);
            }
        }
        return datas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String>[] readProperties(File propfile, String prefix) {
        Set[] datas;
        block24: {
            datas = new Set[2];
            HashSet<String> ves = new HashSet<String>();
            HashSet<String> vps = new HashSet<String>();
            datas[0] = ves;
            datas[1] = vps;
            if (!(propfile.isFile() && propfile.exists() && propfile.getName().toLowerCase().endsWith("properties"))) {
                return datas;
            }
            FileInputStream in = null;
            BufferedReader reader = null;
            try {
                in = new FileInputStream(propfile);
                if (in == null) break block24;
                char[] convtBuf = new char[1024];
                String line = null;
                reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if ("".equals(line) || !(line = line.trim()).startsWith(prefix)) continue;
                    String line1 = reader.readLine();
                    if (line1 == null) {
                        break;
                    }
                    char[] lineC = line1.toCharArray();
                    int fengefu = -1;
                    for (int i = 0; i < lineC.length; ++i) {
                        char c = lineC[i];
                        if (c != '=' && c != ':' && c != '\t') continue;
                        fengefu = i;
                        break;
                    }
                    if (fengefu < 0) continue;
                    String key = PropertiesReader.loadConvert(lineC, 0, fengefu, convtBuf).trim();
                    if (line.indexOf("{VE}") >= 0) {
                        ves.add(key);
                        LOG.debug((Object)("VE:" + key));
                        continue;
                    }
                    if (line.indexOf("{VP}") < 0) continue;
                    vps.add(key);
                    LOG.debug((Object)("VP:" + key));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception exception) {}
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return datas;
    }

    private static String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        char[] buf = convtBuf;
        if (buf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            buf = new char[newLen];
        }
        char[] out = buf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }
}

