/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster;

import com.seeyon.ctp.cluster.notification.NotificationFactory;
import com.seeyon.ctp.cluster.notification.NotificationListener;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.cluster.notification.PendingNotificationQueue;
import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.util.annotation.AnnotationAware;
import com.seeyon.ctp.util.annotation.AnnotationFactory;
import com.seeyon.ctp.util.annotation.HandleNotification;
import com.seeyon.ctp.util.annotation.MethodAnnotation;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotificationAnnotationAware
extends AbstractSystemInitializer
implements AnnotationAware {
    private static final Log logger = LogFactory.getLog(NotificationAnnotationAware.class);
    private AnnotationFactory annotationFactory;
    private static boolean registerFinished;

    @Override
    public void setAnnotationFactory(AnnotationFactory annotationFactory) {
        this.annotationFactory = annotationFactory;
    }

    @Override
    public void initialize() {
        NotificationFactory manager = NotificationManager.getInstance();
        if (!manager.isEnabled()) {
            logger.debug((Object)"\u96c6\u7fa4\u672a\u542f\u7528\uff0c\u5ffd\u7565\u3002");
            return;
        }
        Set<MethodAnnotation> methodAnnotation = this.annotationFactory.getAnnotationOfMethod(HandleNotification.class);
        if (methodAnnotation != null) {
            for (MethodAnnotation annotation : methodAnnotation) {
                if (!(annotation.getAnnotation() instanceof HandleNotification)) continue;
                try {
                    manager.register(new AnnotationReflectListener(annotation.getBeanName(), annotation.getMethodName(), ((HandleNotification)annotation.getAnnotation()).type()));
                }
                catch (Exception e) {
                    logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        registerFinished = true;
        PendingNotificationQueue.getInstance().handle();
    }

    public static boolean isRegisterFinished() {
        return registerFinished;
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getSortOrder() {
        return -8;
    }

    class AnnotationReflectListener
    implements NotificationListener {
        private final NotificationType type;
        private final String beanName;
        private final String methodName;
        private final Method method;
        private final Object bean;

        public AnnotationReflectListener(String beanName, String methodName, NotificationType type) throws Exception {
            this.type = type;
            this.beanName = beanName;
            this.methodName = methodName;
            this.bean = AppContext.getBean(beanName);
            if (this.bean == null) {
                throw new UnsupportedOperationException("bean not found:" + beanName);
            }
            this.method = this.bean.getClass().getMethod(methodName, Object.class);
        }

        @Override
        public NotificationType getType() {
            return this.type;
        }

        @Override
        public void handle(Object o) {
            try {
                this.method.invoke(this.bean, o);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }

        public String toString() {
            Object bean2;
            StringBuilder s = new StringBuilder();
            s.append("AnnotationReflectListener:");
            String simpleName = "";
            if (this.beanName != null && (bean2 = AppContext.getBean(this.beanName)) != null) {
                simpleName = bean2.getClass().getSimpleName();
            }
            s.append(simpleName).append(".").append(this.methodName);
            return s.toString();
        }
    }
}

