/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.cluster.NodeInfo;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.timer.TimerHolder;

class NodeManager {
    private CacheAccessable factory = CacheFactory.getInstance(ClusterConfigBean.class);
    private final CacheMap<String, NodeInfo> nodes = this.factory.createMap("nodes");

    NodeManager() {
    }

    public void init(final String clusterHostIndex) {
        NodeInfo info = new NodeInfo();
        info.setStartTime(System.currentTimeMillis());
        info.setPort(ClusterConfigBean.getInstance().getClusterMainHostPort());
        this.nodes.put(clusterHostIndex, info);
        TimerHolder.newTimer(new Runnable(){

            @Override
            public void run() {
                NodeInfo info = (NodeInfo)NodeManager.this.nodes.get(clusterHostIndex);
                info.setLastActiveTime(System.currentTimeMillis());
                NodeManager.this.nodes.put(clusterHostIndex, info);
            }
        }, 180000L);
    }

    public boolean isAlive(String node) {
        int timeout = 601000;
        NodeInfo info = this.nodes.get(node);
        if (info == null) {
            return false;
        }
        Long lastActiveTime = info.getLastActiveTime();
        return lastActiveTime != null && lastActiveTime + (long)timeout > System.currentTimeMillis();
    }

    public Long getStartTime(String node) {
        NodeInfo info = this.nodes.get(node);
        if (info == null) {
            return null;
        }
        return info.getStartTime();
    }

    public NodeInfo getNodeInfo(String node) {
        return this.nodes.get(node);
    }
}

