/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster;

import com.seeyon.ctp.cluster.NotificationListenerRegistry;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.SystemInitializer;
import com.seeyon.ctp.common.authenticate.LockLoginInfoFactory;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.plugin.PluginAddEvent;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.services.security.ServiceManager;
import com.seeyon.ctp.util.PropertiesUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterCacheSystemInitialition
implements SystemInitializer {
    private static final Log log = LogFactory.getLog(ClusterCacheSystemInitialition.class);

    private void initSingleton() {
        ServiceManager.getInstance();
        LockLoginInfoFactory.getInstance();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void initialize() {
        this.checkPlugins();
        if (NotificationManager.getInstance().isEnabled()) {
            NotificationListenerRegistry registry = (NotificationListenerRegistry)AppContext.getBean("notificationListenerRegistry");
            registry.init();
            try {
                this.initSingleton();
            }
            catch (Throwable e) {
                log.error((Object)e.getLocalizedMessage(), e);
            }
            CacheFactory.setClusterEnabled(true);
        }
    }

    private void checkPlugins() {
        log.info((Object)"\u5f00\u59cb\u63d2\u4ef6\u8865\u507f\uff1a");
        Collection lastPluginIds = new ArrayList();
        Collection<String> pluginIds = SystemEnvironment.getPluginIds();
        String current = JSONUtil.toJSONString(pluginIds);
        log.info((Object)("current:" + current));
        File file = new File(SystemEnvironment.getBaseFolder() + "/conf/plugininfo.properties");
        Properties prop = new Properties();
        if (file.exists()) {
            prop = PropertiesUtil.getFromFile(file);
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                log.error((Object)("\u521b\u5efa\u63d2\u4ef6\u8bb0\u5f55\u6587\u4ef6\u5931\u8d25\u3002" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        String property = prop.getProperty("last");
        if (!Strings.isBlank(property)) {
            lastPluginIds = (Collection)JSONUtil.parseJSONString(property);
            log.info((Object)("last:" + property));
        }
        pluginIds.removeAll(lastPluginIds);
        prop.setProperty("last", current);
        PropertiesUtil.saveToFile(prop, file, "");
        if (pluginIds.size() > 0) {
            log.info((Object)("\u53d1\u73b0\u63d2\u4ef6\u589e\u52a0\uff0c\u89e6\u53d1\u8865\u507f\uff1a" + pluginIds));
            EventDispatcher.fireEvent(new PluginAddEvent(new HashSet<String>(pluginIds), this));
        }
    }
}

