/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.seeyon.client.CTPRestClient;
import com.seeyon.ctp.services.UserToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpSession;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;

public class GenericRestClient
implements CTPRestClient {
    private static final String APPLICATION_JSON = "application/json";
    private final String baseUrl;
    private String token = "";
    private String sessionId = "";
    private Locale locale = Locale.SIMPLIFIED_CHINESE;
    private static JacksonJsonProvider jacksonJsonProvider = (JacksonJsonProvider)((JacksonJsonProvider)new JacksonJaxbJsonProvider().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    public GenericRestClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public boolean authenticate(final String userName, final String password) {
        Map data = this.post("token", new HashMap(){
            {
                this.put("userName", userName);
                this.put("password", password);
            }
        }, Map.class);
        this.token = (String)data.get("id");
        return !UserToken.getNullToken().getId().equals(this.token);
    }

    @Override
    public <T> T get(String path, Class<T> clazz) {
        return this.get(path, clazz, APPLICATION_JSON);
    }

    @Override
    public <T> T get(String path, Class<T> clazz, String accept) {
        return this.get(path, "", clazz, accept);
    }

    public <T> T get(String path, Object body, Class<T> clazz, String accept) {
        Response response = this.build(path, accept).get();
        this.throwException(response);
        return this.getEntity(clazz, response);
    }

    @Override
    public <T> List<T> getList(String path, final Class<T> clazz) {
        ParameterizedType parameterizedGenericType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{clazz};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return List.class;
            }
        };
        GenericType genericType = new GenericType<List<T>>(parameterizedGenericType){};
        return (List)this.build(path, APPLICATION_JSON).get(genericType);
    }

    @Override
    public <T> T put(String path, Object body, Class<T> clazz) {
        String accept = APPLICATION_JSON;
        return this.put(path, body, clazz, accept);
    }

    @Override
    public <T> T put(String path, Object body, Class<T> clazz, String accept) {
        Response response = this.build(path, accept).put(Entity.entity((Object)body, (String)accept));
        this.throwException(response);
        return this.getEntity(clazz, response);
    }

    @Override
    public <T> T post(String path, Object body, Class<T> clazz) {
        return this.post(path, body, clazz, APPLICATION_JSON);
    }

    @Override
    public <T> T post(String path, Object body, Class<T> clazz, String accept) {
        Response response = this.build(path, accept).post(Entity.entity((Object)body, (String)APPLICATION_JSON));
        this.throwException(response);
        return this.getEntity(clazz, response);
    }

    private Invocation.Builder build(String path, String accept) {
        return this.cookie(this.buildWebResource(path).request(new String[]{accept})).header("token", (Object)this.token).acceptLanguage(new Locale[]{this.locale});
    }

    private <T> T getEntity(Class<T> clazz, Response response) {
        if (clazz.equals(Response.class)) {
            return (T)response;
        }
        return (T)response.readEntity(clazz);
    }

    @Override
    public <T> T delete(String path, Object body, Class<T> clazz) {
        Response response = this.build(path, APPLICATION_JSON).delete();
        this.throwException(response);
        try {
            return (T)response.readEntity(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private WebTarget buildWebResource(String path) {
        Client client;
        boolean isHttps = this.baseUrl.toLowerCase().startsWith("https");
        ClientConfig cfg = new ClientConfig();
        cfg.register((Object)jacksonJsonProvider);
        if (isHttps) {
            TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(null, certs, new SecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            if (ctx != null) {
                HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
            }
            client = ClientBuilder.newBuilder().withConfig((Configuration)cfg).hostnameVerifier((HostnameVerifier)new TrustAllHostNameVerifier()).sslContext(ctx).build();
        } else {
            client = ClientBuilder.newClient((Configuration)cfg);
        }
        WebTarget resource = client.target(this.baseUrl);
        String[] split = path.split("\\?");
        resource = resource.path(split[0]);
        if (split.length > 1) {
            String[] pairs;
            for (String s : pairs = split[1].split("&")) {
                String[] split2 = s.split("=");
                String key = split2[0];
                String value = split2.length == 1 ? "" : split2[1];
                resource = resource.queryParam(key, new Object[]{value});
            }
        }
        return resource;
    }

    private Invocation.Builder cookie(Invocation.Builder resource) {
        if (this.sessionId != null) {
            Cookie cookie = new Cookie("JSESSIONID", this.sessionId);
            return resource.cookie(cookie);
        }
        resource.acceptLanguage(new Locale[]{this.locale});
        return resource;
    }

    private void throwException(Response response) {
        if (response.getStatus() != 200 && response.getStatus() != 500) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus() + " . " + response.toString());
        }
    }

    public Object get(String path) throws Exception {
        URL url = new URL(this.baseUrl + path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", APPLICATION_JSON);
        this.throwException(conn);
        StringBuilder output = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String s = "";
            while ((s = br.readLine()) != null) {
                output.append(s);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        conn.disconnect();
        return output.toString();
    }

    private void throwException(HttpURLConnection conn) throws IOException {
        if (conn.getResponseCode() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
        }
    }

    @Override
    public void setSession(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public void setSession(HttpSession session) {
        this.sessionId = session.getId();
    }

    public <T> T get(String path, Object body, Class<T> clazz) {
        return this.get(path, body, clazz, APPLICATION_JSON);
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void bindUser(final String loginName) {
        Map data = this.put("token", new HashMap(){
            {
                this.put("loginName", loginName);
                this.put("token", GenericRestClient.this.token);
            }
        }, Map.class);
    }

    @Override
    public void bindUserByCode(final String code) {
        Map data = this.put("token", new HashMap(){
            {
                this.put("code", code);
                this.put("token", GenericRestClient.this.token);
            }
        }, Map.class);
    }

    public static class TrustAllHostNameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

